/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public class RandomUtils {
    private static final Random random = new Random();

    public static float lerp(String[] list, int levelIndex, int nextLevelIndex, float distance) {
        float previousValue = Float.parseFloat(list[levelIndex]);
        float nextValue = Float.parseFloat(list[nextLevelIndex]);
        return previousValue + distance * (nextValue - previousValue);
    }

    public static <T> T weightedRandom(LinkedList<WeightedPair<T>> weightList) {
        if (weightList.size() == 0) {
            return null;
        }
        Float maxWeight = weightList.getLast().getThreshold();
        Float selectedWeight = Float.valueOf(random.nextFloat() * maxWeight.floatValue());
        for (WeightedPair weightedPair : weightList) {
            if (!(selectedWeight.floatValue() < weightedPair.getThreshold().floatValue())) continue;
            return weightedPair.getValue();
        }
        return weightList.getFirst().getValue();
    }

    public static void populateIntegerProbabilityMap(LinkedList<WeightedPair<Integer>> probabilityMap, ConfigurationSection nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        RandomUtils.populateProbabilityMap(Integer.class, probabilityMap, nodeMap, levelIndex, nextLevelIndex, distance);
    }

    public static void populateStringProbabilityMap(LinkedList<WeightedPair<String>> probabilityMap, ConfigurationSection nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        RandomUtils.populateProbabilityMap(String.class, probabilityMap, nodeMap, levelIndex, nextLevelIndex, distance);
    }

    public static void populateFloatProbabilityMap(LinkedList<WeightedPair<Float>> probabilityMap, ConfigurationSection nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        RandomUtils.populateProbabilityMap(Float.class, probabilityMap, nodeMap, levelIndex, nextLevelIndex, distance);
    }

    public static <T> void populateProbabilityMap(Class<T> valueClass, LinkedList<WeightedPair<T>> probabilityMap, ConfigurationSection nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        Float currentThreshold = Float.valueOf(0.0f);
        if (nodeMap != null) {
            Set keys = nodeMap.getKeys(false);
            for (String key : keys) {
                String value = nodeMap.getString(key);
                key = key.replace("^", ".");
                currentThreshold = Float.valueOf(currentThreshold.floatValue() + RandomUtils.lerp(value.split(","), levelIndex, nextLevelIndex, distance));
                probabilityMap.add(new WeightedPair<T>(currentThreshold, key, valueClass));
            }
        }
    }
}

