/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class InventoryUtils
extends NMSUtils {
    public static boolean saveTagsToNBT(ConfigurationSection tags, Object node, String[] tagNames) {
        if (node == null) {
            Bukkit.getLogger().warning("Tring to save tags to a null node");
            return false;
        }
        if (!class_NBTTagCompound.isAssignableFrom(node.getClass())) {
            Bukkit.getLogger().warning("Tring to save tags to a non-CompoundTag");
            return false;
        }
        String[] stringArray = tagNames;
        int n = tagNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tagName = stringArray[n2];
            InventoryUtils.setMeta(node, tagName, tags.getString(tagName));
            ++n2;
        }
        return true;
    }

    public static boolean loadTagsFromNBT(ConfigurationSection tags, Object node, String[] tagNames) {
        if (node == null) {
            Bukkit.getLogger().warning("Tring to load tags from a null node");
            return false;
        }
        if (!class_NBTTagCompound.isAssignableFrom(node.getClass())) {
            Bukkit.getLogger().warning("Tring to load tags from a non-CompoundTag");
            return false;
        }
        String[] stringArray = tagNames;
        int n = tagNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tagName = stringArray[n2];
            String meta = InventoryUtils.getMeta(node, tagName);
            if (meta != null && meta.length() > 0) {
                ConfigurationUtils.set(tags, tagName, meta);
            }
            ++n2;
        }
        return true;
    }

    public static Inventory createInventory(InventoryHolder holder, int size, String name) {
        Inventory inventory = null;
        try {
            Constructor inventoryConstructor = class_CraftInventoryCustom.getConstructor(InventoryHolder.class, Integer.TYPE, String.class);
            inventory = (Inventory)inventoryConstructor.newInstance(holder, size, ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return inventory;
    }

    public static boolean inventorySetItem(Inventory inventory, int index, ItemStack item) {
        try {
            Method setItemMethod = class_CraftInventoryCustom.getMethod("setItem", Integer.TYPE, ItemStack.class);
            setItemMethod.invoke((Object)inventory, index, item);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean setInventoryResults(Inventory inventory, ItemStack item) {
        try {
            Method getResultsMethod = inventory.getClass().getMethod("getResultInventory", new Class[0]);
            Object inv = getResultsMethod.invoke((Object)inventory, new Object[0]);
            Method setItemMethod = inv.getClass().getMethod("setItem", Integer.TYPE, class_ItemStack);
            setItemMethod.invoke(inv, 0, InventoryUtils.getHandle(item));
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void addPotionEffect(LivingEntity entity, Color color) {
        InventoryUtils.addPotionEffect(entity, color.asRGB());
    }

    public static void clearPotionEffect(LivingEntity entity) {
        InventoryUtils.addPotionEffect(entity, 0);
    }

    public static void addPotionEffect(LivingEntity entity, int color) {
        try {
            Method geHandleMethod = class_CraftLivingEntity.getMethod("getHandle", new Class[0]);
            Object entityLiving = geHandleMethod.invoke((Object)entity, new Object[0]);
            Method getDataWatcherMethod = class_Entity.getMethod("getDataWatcher", new Class[0]);
            Object dataWatcher = getDataWatcherMethod.invoke(entityLiving, new Object[0]);
            Method watchMethod = class_DataWatcher.getMethod("watch", Integer.TYPE, Object.class);
            watchMethod.invoke(dataWatcher, 7, color);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setInvulnerable(Entity entity) {
        try {
            Object handle = InventoryUtils.getHandle(entity);
            Field invulnerableField = class_Entity.getDeclaredField("invulnerable");
            invulnerableField.setAccessible(true);
            invulnerableField.set(handle, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void removePotionEffect(LivingEntity entity) {
        InventoryUtils.addPotionEffect(entity, 0);
    }

    public static Painting spawnPainting(Location location, BlockFace facing, Art art) {
        Painting newPainting;
        block3: {
            Entity bukkitEntity;
            block4: {
                newPainting = null;
                Constructor paintingConstructor = class_EntityPainting.getConstructor(class_World, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                Method addEntity = class_World.getMethod("addEntity", class_Entity, CreatureSpawnEvent.SpawnReason.class);
                Object worldHandle = InventoryUtils.getHandle(location.getWorld());
                Object newEntity = paintingConstructor.newInstance(worldHandle, location.getBlockX(), location.getBlockY(), location.getBlockZ(), InventoryUtils.getFacing(facing));
                if (newEntity == null) break block3;
                addEntity.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                bukkitEntity = InventoryUtils.getBukkitEntity(newEntity);
                if (bukkitEntity != null && bukkitEntity instanceof Painting) break block4;
                return null;
            }
            try {
                newPainting = (Painting)bukkitEntity;
                newPainting.setArt(art, true);
                newPainting.setFacingDirection(facing, true);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return newPainting;
    }

    public static ItemFrame spawnItemFrame(Location location, BlockFace facing, ItemStack item) {
        ItemFrame newItemFrame;
        block3: {
            Entity bukkitEntity;
            block4: {
                newItemFrame = null;
                Constructor itemFrameConstructor = class_EntityItemFrame.getConstructor(class_World, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                Method addEntity = class_World.getMethod("addEntity", class_Entity, CreatureSpawnEvent.SpawnReason.class);
                Object worldHandle = InventoryUtils.getHandle(location.getWorld());
                Object newEntity = itemFrameConstructor.newInstance(worldHandle, location.getBlockX(), location.getBlockY(), location.getBlockZ(), InventoryUtils.getFacing(facing));
                if (newEntity == null) break block3;
                addEntity.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                bukkitEntity = InventoryUtils.getBukkitEntity(newEntity);
                if (bukkitEntity != null && bukkitEntity instanceof ItemFrame) break block4;
                return null;
            }
            try {
                newItemFrame = (ItemFrame)bukkitEntity;
                newItemFrame.setItem(InventoryUtils.getCopy(item));
                newItemFrame.setFacingDirection(facing, true);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return newItemFrame;
    }
}

