/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.traders;

import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.util.UUID;
import net.dandielo.citizens.traders_v3.core.exceptions.InvalidItemException;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeValueNotFoundException;
import net.dandielo.citizens.traders_v3.utils.items.Attribute;
import net.dandielo.citizens.traders_v3.utils.items.ItemFlag;
import org.bukkit.inventory.ItemStack;

@Attribute(name="Magic Wand", key=".wand")
public class WandFlag
extends ItemFlag {
    public WandFlag(String key) {
        super(key);
    }

    public void onAssign(ItemStack itemStack) throws InvalidItemException {
        if (itemStack == null) {
            throw new InvalidItemException();
        }
        Object wandNode = InventoryUtils.createNode(itemStack, "wand");
        if (wandNode != null) {
            InventoryUtils.setMeta(wandNode, "id", UUID.randomUUID().toString());
        }
    }

    public ItemStack onReturnAssign(ItemStack itemStack, boolean endItem) throws InvalidItemException {
        if (itemStack == null) {
            throw new InvalidItemException();
        }
        itemStack = InventoryUtils.makeReal(itemStack);
        this.onAssign(itemStack);
        return itemStack;
    }

    public void onFactorize(ItemStack item) throws AttributeValueNotFoundException {
        if (!Wand.isWand(item)) {
            throw new AttributeValueNotFoundException();
        }
        this.item.addFlag(".nostack");
    }
}

