/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.wand;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class WandOrganizer {
    private final Wand wand;
    private final Mage mage;
    protected static final int inventoryOrganizeSize = 22;
    protected static final int inventoryOrganizeNewGroupSize = 16;
    protected static final int favoriteCastCountThreshold = 20;
    private int currentInventoryIndex = 0;
    private int currentInventoryCount = 0;
    private Inventory currentInventory = null;
    private boolean addToHotbar = true;

    public WandOrganizer(Wand wand, Mage mage) {
        this.wand = wand;
        this.mage = mage;
        this.addToHotbar = true;
    }

    protected void nextInventory() {
        ++this.currentInventoryIndex;
        this.currentInventoryCount = 0;
        this.currentInventory = this.wand.getInventoryByIndex(this.currentInventoryIndex);
    }

    protected void addToInventory(ItemStack itemStack) {
        HashMap result;
        if (this.addToHotbar) {
            this.addToHotbar = false;
            Inventory hotbar = this.wand.getHotbar();
            int i = 0;
            while (i < 9) {
                ItemStack hotbarItem = hotbar.getItem(i);
                if (hotbarItem == null || hotbarItem.getType() == Material.AIR) {
                    this.addToHotbar = true;
                    hotbar.setItem(i, itemStack);
                    return;
                }
                ++i;
            }
        }
        if (this.currentInventoryCount > 22) {
            this.nextInventory();
        }
        if ((result = this.currentInventory.addItem(new ItemStack[]{itemStack})).size() > 0) {
            this.nextInventory();
            for (ItemStack skipped : result.values()) {
                this.currentInventory.addItem(new ItemStack[]{skipped});
                ++this.currentInventoryCount;
            }
        } else {
            ++this.currentInventoryCount;
        }
    }

    public void organize() {
        HashSet<String> hotbarSpellNames = new HashSet<String>();
        HashSet<String> hotbarMaterialNames = new HashSet<String>();
        Inventory hotbar = this.wand.getHotbar();
        int hotbarSize = 9;
        int i = 0;
        while (i < hotbarSize) {
            ItemStack hotbarItem = hotbar.getItem(i);
            if (hotbarItem != null && hotbarItem.getType() != Material.AIR) {
                String spellName = Wand.getSpell(hotbarItem);
                if (spellName != null) {
                    hotbarSpellNames.add(spellName);
                } else {
                    String materialKey = Wand.getBrush(hotbarItem);
                    if (materialKey != null) {
                        hotbarMaterialNames.add(materialKey);
                    }
                }
            }
            ++i;
        }
        MagicController master = this.wand.getMaster();
        TreeMap favoriteSpells = new TreeMap();
        TreeMap<String, TreeSet<String>> groupedSpells = new TreeMap<String, TreeSet<String>>();
        Collection spells = this.wand.getSpells();
        for (String spellName : spells) {
            TreeSet<String> spellList;
            Object spell;
            Object object = spell = this.mage == null ? master.getSpell(spellName) : this.mage.getSpell(spellName);
            if (spell == null || hotbarSpellNames.contains(spellName)) continue;
            long castCount = spell.getCastCount();
            if (castCount > 20L) {
                List<String> favorites = null;
                if (!favoriteSpells.containsKey(castCount)) {
                    favorites = new ArrayList();
                    favoriteSpells.put(castCount, favorites);
                } else {
                    favorites = (List)favoriteSpells.get(castCount);
                }
                favorites.add(spellName);
                spell = null;
            }
            if (spell == null) continue;
            String category = spell.getCategory();
            if (category == null || category.length() == 0) {
                category = "default";
            }
            if ((spellList = (TreeSet<String>)groupedSpells.get(category)) == null) {
                spellList = new TreeSet<String>();
                groupedSpells.put(category, spellList);
            }
            spellList.add(spellName);
        }
        Collection wandMaterials = this.wand.getBrushes();
        for (String hotbarItemName : hotbarMaterialNames) {
            wandMaterials.remove(hotbarItemName);
        }
        TreeMap<String, String> materials = new TreeMap<String, String>();
        for (String materialKey : wandMaterials) {
            if (MaterialBrush.isSpecialMaterialKey(materialKey)) {
                materials.put(" " + materialKey, materialKey);
                continue;
            }
            materials.put(materialKey, materialKey);
        }
        this.wand.clearInventories();
        this.currentInventoryIndex = 0;
        this.currentInventoryCount = 0;
        this.currentInventory = this.wand.getInventoryByIndex(this.currentInventoryIndex);
        for (String hotbarSpellName : hotbarSpellNames) {
            this.addToInventory(this.wand.createSpellIcon(hotbarSpellName));
        }
        for (String hotbarMaterialName : hotbarMaterialNames) {
            this.addToInventory(this.wand.createBrushIcon(hotbarMaterialName));
        }
        for (List favorites : favoriteSpells.descendingMap().values()) {
            for (String spellName : favorites) {
                this.addToInventory(this.wand.createSpellIcon(spellName));
            }
        }
        for (Collection spellGroup : groupedSpells.values()) {
            if (this.currentInventoryCount > 16) {
                this.nextInventory();
            }
            for (String spellName : spellGroup) {
                this.addToInventory(this.wand.createSpellIcon(spellName));
            }
        }
        if (materials.size() > 0) {
            this.nextInventory();
            for (String materialName : materials.values()) {
                this.addToInventory(this.wand.createBrushIcon(materialName));
            }
        }
    }
}

