/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.wand;

import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.spell.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.spell.Spell;
import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class WandLevel {
    private static TreeMap<Integer, WandLevel> levelMap = null;
    private static int[] levels = null;
    private final LinkedList<WeightedPair<Integer>> spellCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> materialCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<String>> spellProbability = new LinkedList();
    private final LinkedList<WeightedPair<String>> materialProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> useProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> addUseProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> propertyCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> costReductionProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> powerProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionPhysicalProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionProjectilesProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionFallingProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionFireProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionExplosionsProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> xpRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> xpMaxProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> healthRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> hungerRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> hasteProbability = new LinkedList();
    public static float maxValue = 1.0f;
    public static int maxUses = 500;
    public static int maxMaxXp = 1500;
    public static int maxXpRegeneration = 150;
    public static int maxHungerRegeneration = 5;
    public static int maxHealthRegeneration = 5;
    public static float maxDamageReduction = 0.4f;
    public static float maxCostReduction = 0.5f;
    public static float maxCooldownReduction = 0.5f;
    public static float maxFlySpeedIncrease = 0.1f;
    public static float maxWalkSpeedIncrease = 0.4f;
    public static float maxFlySpeed = 0.8f;
    public static float maxWalkSpeed = 0.8f;
    public static int minLevel = 10;
    public static int maxLevel = 40;

    public static void load(ConfigurationSection properties) {
        maxValue = (float)properties.getDouble("max_property_value", (double)maxValue);
        maxUses = properties.getInt("max_uses", maxUses);
        maxMaxXp = properties.getInt("max_mana", maxMaxXp);
        maxXpRegeneration = properties.getInt("max_mana_regeneration", maxXpRegeneration);
        maxHealthRegeneration = properties.getInt("max_health_regeneration", maxHealthRegeneration);
        maxHungerRegeneration = properties.getInt("max_hunger_regeneration", maxHungerRegeneration);
        minLevel = properties.getInt("min_enchant_level", minLevel);
        maxLevel = properties.getInt("max_enchant_level", maxLevel);
        maxDamageReduction = (float)properties.getDouble("max_damage_reduction", (double)maxDamageReduction);
        maxCostReduction = (float)properties.getDouble("max_cost_reduction", (double)maxCostReduction);
        maxCooldownReduction = (float)properties.getDouble("max_cooldown_reduction", (double)maxCooldownReduction);
        maxFlySpeedIncrease = (float)properties.getDouble("max_fly_speed_increase", (double)maxFlySpeedIncrease);
        maxWalkSpeedIncrease = (float)properties.getDouble("max_walk_speed_increase", (double)maxWalkSpeedIncrease);
        maxFlySpeed = (float)properties.getDouble("max_fly_speed", (double)maxFlySpeed);
        maxWalkSpeed = (float)properties.getDouble("max_walk_speed", (double)maxWalkSpeed);
    }

    public static WandLevel getLevel(int level) {
        if (levelMap == null) {
            return null;
        }
        if (!levelMap.containsKey(level)) {
            if (level > levelMap.lastKey()) {
                return levelMap.lastEntry().getValue();
            }
            return levelMap.firstEntry().getValue();
        }
        return levelMap.get(level);
    }

    public static void mapLevels(ConfigurationSection template) {
        levelMap = new TreeMap();
        String[] levelStrings = StringUtils.split((String)template.getString("levels"), (String)",");
        levels = new int[levelStrings.length];
        int i = 0;
        while (i < levels.length) {
            WandLevel.levels[i] = Integer.parseInt(levelStrings[i]);
            ++i;
        }
        int level = 1;
        while (level <= levels[levels.length - 1]) {
            levelMap.put(level, new WandLevel(level, template));
            ++level;
        }
    }

    private WandLevel(int level, ConfigurationSection template) {
        int levelIndex = 0;
        int nextLevelIndex = 0;
        float distance = 1.0f;
        levelIndex = 0;
        while (levelIndex < levels.length) {
            if (level == levels[levelIndex] || levelIndex == levels.length - 1) {
                nextLevelIndex = levelIndex;
                distance = 0.0f;
                break;
            }
            if (level > levels[levelIndex]) {
                nextLevelIndex = levelIndex + 1;
                int previousLevel = levels[levelIndex];
                int nextLevel = levels[nextLevelIndex];
                distance = (float)(level - previousLevel) / (float)(nextLevel - previousLevel);
            }
            ++levelIndex;
        }
        RandomUtils.populateStringProbabilityMap(this.spellProbability, template.getConfigurationSection("spells"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.spellCountProbability, template.getConfigurationSection("spell_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateStringProbabilityMap(this.materialProbability, template.getConfigurationSection("materials"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.materialCountProbability, template.getConfigurationSection("material_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.useProbability, template.getConfigurationSection("uses"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.addUseProbability, template.getConfigurationSection("add_uses"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.propertyCountProbability, template.getConfigurationSection("property_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.costReductionProbability, template.getConfigurationSection("cost_reduction"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProbability, template.getConfigurationSection("protection"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionPhysicalProbability, template.getConfigurationSection("protection_physical"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFallingProbability, template.getConfigurationSection("protection_falling"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProjectilesProbability, template.getConfigurationSection("protection_projectiles"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFireProbability, template.getConfigurationSection("protection_fire"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionExplosionsProbability, template.getConfigurationSection("protection_explosions"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.xpRegenerationProbability, template.getConfigurationSection("xp_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.xpMaxProbability, template.getConfigurationSection("xp_max"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.healthRegenerationProbability, template.getConfigurationSection("health_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.hungerRegenerationProbability, template.getConfigurationSection("hunger_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.hasteProbability, template.getConfigurationSection("haste"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.powerProbability, template.getConfigurationSection("power"), levelIndex, nextLevelIndex, distance);
    }

    /*
     * Handled impossible loop by duplicating code
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private boolean randomizeWand(Wand wand, boolean additive) {
        boolean bl;
        double costReduction;
        MemoryConfiguration wandProperties;
        boolean addedMaterials;
        int maxXpCost;
        void var7_10;
        boolean addedSpells;
        block40: {
            Integer n;
            void v0;
            void var15_39;
            block39: {
                addedSpells = false;
                Collection wandSpells = wand.getSpells();
                LinkedList remainingSpells = new LinkedList();
                for (WeightedPair weightedPair : this.spellProbability) {
                    if (wandSpells.contains(weightedPair.getValue())) continue;
                    remainingSpells.add(weightedPair);
                }
                Object var7_9 = null;
                if (remainingSpells.size() > 0) {
                    Integer spellCount = (Integer)RandomUtils.weightedRandom(this.spellCountProbability);
                    int retries = 10;
                    int i = 0;
                    while (i < spellCount) {
                        String spellKey = (String)RandomUtils.weightedRandom(remainingSpells);
                        if (wand.addSpell(spellKey)) {
                            if (var7_10 == null) {
                                Spell spell = wand.getMaster().getSpell(spellKey);
                            }
                            addedSpells = true;
                        } else if (retries-- > 0) {
                            --i;
                        }
                        ++i;
                    }
                }
                boolean needsMaterials = false;
                maxXpCost = 0;
                Collection spells = wand.getSpells();
                for (String spellName : spells) {
                    Spell spell = wand.getMaster().getSpell(spellName);
                    if (spell == null) continue;
                    needsMaterials = needsMaterials || spell instanceof BrushSpell && !((BrushSpell)spell).hasBrushOverride();
                    Collection<CastingCost> collection = spell.getCosts();
                    if (collection == null) continue;
                    for (CastingCost castingCost : collection) {
                        maxXpCost = Math.max(maxXpCost, castingCost.getXP());
                    }
                }
                addedMaterials = false;
                Collection wandMaterials = wand.getBrushes();
                LinkedList remainingMaterials = new LinkedList();
                for (WeightedPair weightedPair : this.materialProbability) {
                    String materialKey = (String)weightedPair.getValue();
                    materialKey = materialKey.replace("|", ":");
                    if (wandMaterials.contains(weightedPair.getValue()) || !MaterialBrush.isValidMaterial(materialKey, false)) continue;
                    remainingMaterials.add(weightedPair);
                }
                if (needsMaterials && remainingMaterials.size() > 0) {
                    void var15_35;
                    int n2 = wand.getBrushes().size();
                    Integer n3 = (Integer)RandomUtils.weightedRandom(this.materialCountProbability);
                    if (n2 == 0) {
                        Integer n4 = Math.max(1, n3);
                    }
                    int retries = 100;
                    int i = 0;
                    while (i < var15_35.intValue()) {
                        String materialKey = (String)RandomUtils.weightedRandom(remainingMaterials);
                        if (!wand.addBrush(materialKey = materialKey.replace("|", ":"))) {
                            if (retries-- > 0) {
                                --i;
                            }
                        } else {
                            addedMaterials = true;
                        }
                        ++i;
                    }
                }
                boolean bl2 = false;
                Integer n5 = (Integer)RandomUtils.weightedRandom(this.propertyCountProbability);
                wandProperties = new MemoryConfiguration();
                costReduction = wand.getCostReduction();
                if (!true) break block39;
                v0 = var15_39;
                n = v0.intValue() - 1;
                if (v0.intValue() <= 0) break block40;
            }
            do {
                int randomProperty = (int)(Math.random() * 10.0);
                switch (randomProperty) {
                    case 0: {
                        if (!(costReduction < (double)maxValue)) break;
                        boolean bl3 = true;
                        costReduction = Math.min((double)maxValue, costReduction + (double)((Float)RandomUtils.weightedRandom(this.costReductionProbability)).floatValue());
                        wandProperties.set("cost_reduction", (Object)costReduction);
                        break;
                    }
                    case 1: {
                        float power = wand.getPower();
                        if (!(power < maxValue)) break;
                        boolean bl3 = true;
                        wandProperties.set("power", (Object)Math.min(maxValue, power + ((Float)RandomUtils.weightedRandom(this.powerProbability)).floatValue()));
                        break;
                    }
                    case 2: {
                        float damageReduction = wand.getDamageReduction();
                        if (!(damageReduction < maxValue)) break;
                        boolean bl3 = true;
                        wandProperties.set("protection", (Object)Math.min(maxValue, damageReduction + ((Float)RandomUtils.weightedRandom(this.damageReductionProbability)).floatValue()));
                        break;
                    }
                    case 3: {
                        float damageReductionPhysical = wand.getDamageReductionPhysical();
                        if (!(damageReductionPhysical < maxValue)) break;
                        boolean bl3 = true;
                        wandProperties.set("protection_physical", (Object)Math.min(maxValue, damageReductionPhysical + ((Float)RandomUtils.weightedRandom(this.damageReductionPhysicalProbability)).floatValue()));
                        break;
                    }
                    case 4: {
                        float damageReductionProjectiles = wand.getDamageReductionProjectiles();
                        if (!(damageReductionProjectiles < maxValue)) break;
                        boolean bl3 = true;
                        wandProperties.set("protection_projectiles", (Object)Math.min(maxValue, damageReductionProjectiles + ((Float)RandomUtils.weightedRandom(this.damageReductionProjectilesProbability)).floatValue()));
                        break;
                    }
                    case 5: {
                        float damageReductionFalling = wand.getDamageReductionFalling();
                        if (!(damageReductionFalling < maxValue)) break;
                        boolean bl3 = true;
                        wandProperties.set("protection_falling", (Object)Math.min(maxValue, damageReductionFalling + ((Float)RandomUtils.weightedRandom(this.damageReductionFallingProbability)).floatValue()));
                        break;
                    }
                    case 6: {
                        float damageReductionFire = wand.getDamageReductionFire();
                        if (!(damageReductionFire < maxValue)) break;
                        boolean bl3 = true;
                        wandProperties.set("protection_fire", (Object)Math.min(maxValue, damageReductionFire + ((Float)RandomUtils.weightedRandom(this.damageReductionFireProbability)).floatValue()));
                        break;
                    }
                    case 7: {
                        float damageReductionExplosions = wand.getDamageReductionExplosions();
                        if (!(damageReductionExplosions < maxValue)) break;
                        boolean bl3 = true;
                        wandProperties.set("protection_explosions", (Object)Math.min(maxValue, damageReductionExplosions + ((Float)RandomUtils.weightedRandom(this.damageReductionExplosionsProbability)).floatValue()));
                        break;
                    }
                    case 10: {
                        int healthRegeneration = wand.getHealthRegeneration();
                        if (!((float)healthRegeneration < maxValue)) break;
                        boolean bl3 = true;
                        wandProperties.set("health_regeneration", (Object)((int)Math.min(maxValue, (float)(healthRegeneration + (Integer)RandomUtils.weightedRandom(this.healthRegenerationProbability)))));
                        break;
                    }
                    case 11: {
                        int hungerRegeneration = wand.getHungerRegeneration();
                        if (!((float)hungerRegeneration < maxValue)) break;
                        boolean bl3 = true;
                        wandProperties.set("hunger_regeneration", (Object)((int)Math.min(maxValue, (float)(hungerRegeneration + (Integer)RandomUtils.weightedRandom(this.hungerRegenerationProbability)))));
                        break;
                    }
                }
                v0 = var15_39;
                n = v0.intValue() - 1;
            } while (v0.intValue() > 0);
        }
        if (costReduction > 1.0) {
            wandProperties.set("xp_regeneration", (Object)0);
            wandProperties.set("xp_max", (Object)0);
            wandProperties.set("xp", (Object)0);
        } else {
            int xpMax;
            int xpRegeneration = wand.getXpRegeneration();
            if (xpRegeneration < maxXpRegeneration) {
                boolean bl4 = true;
                wandProperties.set("xp_regeneration", (Object)Math.min(maxXpRegeneration, xpRegeneration + (Integer)RandomUtils.weightedRandom(this.xpRegenerationProbability)));
            }
            if ((xpMax = wand.getXpMax()) < maxMaxXp) {
                xpMax = Math.min(maxMaxXp, xpMax + (Integer)RandomUtils.weightedRandom(this.xpMaxProbability));
                xpMax = Math.max(maxXpCost, xpMax);
                wandProperties.set("xp_max", (Object)xpMax);
                boolean bl5 = true;
            }
            wandProperties.set("xp", (Object)xpMax);
        }
        if (additive) {
            int wandUses = wand.getUses();
            if (wandUses > 0 && wandUses < maxUses) {
                wandProperties.set("uses", (Object)Math.min(maxUses, wandUses + (Integer)RandomUtils.weightedRandom(this.addUseProbability)));
                bl = true;
            }
        } else {
            wandProperties.set("uses", (Object)Math.min(maxUses, (Integer)RandomUtils.weightedRandom(this.useProbability)));
            String spellName = "Nothing";
            if (var7_10 != null) {
                spellName = var7_10.getName();
            }
            String updatedName = wand.getName();
            wand.setName(updatedName.replace("{Spell}", spellName));
        }
        wand.loadProperties((ConfigurationSection)wandProperties);
        return addedMaterials || addedSpells || bl;
    }

    public static boolean randomizeWand(Wand wand, boolean additive, int level) {
        WandLevel wandLevel = WandLevel.getLevel(level);
        return wandLevel.randomizeWand(wand, additive);
    }

    public static Set<Integer> getLevels() {
        if (levels == null) {
            return null;
        }
        HashSet<Integer> filteredLevels = new HashSet<Integer>();
        int[] nArray = levels;
        int n = levels.length;
        int n2 = 0;
        while (n2 < n) {
            Integer level = nArray[n2];
            if (level >= minLevel && level <= maxLevel) {
                filteredLevels.add(level);
            }
            ++n2;
        }
        return filteredLevels;
    }

    public static int getMaxLevel() {
        if (levels == null) {
            return 0;
        }
        return Math.min(levels[levels.length - 1], maxLevel);
    }
}

