/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.Target;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DisintegrateSpell
extends BlockSpell {
    private static final int DEFAULT_PLAYER_DAMAGE = 1;
    private static final int DEFAULT_ENTITY_DAMAGE = 100;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Entity targetEntity;
        Target target = this.getTarget();
        int playerDamage = parameters.getInt("player_damage", 1);
        int entityDamage = parameters.getInt("entity_damage", 100);
        if (target.hasEntity() && (targetEntity = target.getEntity()) instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)targetEntity;
            if (li instanceof Player) {
                li.damage((double)(this.mage.getDamageMultiplier() * (float)playerDamage), (Entity)this.getPlayer());
            } else {
                li.damage((double)(this.mage.getDamageMultiplier() * (float)entityDamage), (Entity)this.getPlayer());
            }
            return SpellResult.CAST;
        }
        if (!target.hasTarget()) {
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = target.getBlock();
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.mage.isIndestructible(targetBlock)) {
            return SpellResult.NO_TARGET;
        }
        BlockList disintigrated = new BlockList();
        disintigrated.add(targetBlock);
        if (this.isUnderwater()) {
            targetBlock.setType(Material.STATIONARY_WATER);
        } else {
            targetBlock.setType(Material.AIR);
        }
        this.registerForUndo(disintigrated);
        return SpellResult.CAST;
    }
}

