/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.spell.BrushSpell;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class BridgeSpell
extends BrushSpell {
    int MAX_SEARCH_DISTANCE = 16;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block attachBlock;
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(playerBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        BlockFace direction = this.getPlayerFacing();
        Block targetBlock = attachBlock = playerBlock;
        int distance = 0;
        while (this.isTargetable(targetBlock.getType()) && distance <= this.MAX_SEARCH_DISTANCE) {
            ++distance;
            attachBlock = targetBlock;
            targetBlock = attachBlock.getRelative(direction);
        }
        if (this.isTargetable(targetBlock.getType())) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialBrush buildWith = this.getMaterialBrush();
        buildWith.setTarget(attachBlock.getLocation(), targetBlock.getLocation());
        buildWith.update(this.mage, targetBlock.getLocation());
        BlockList bridgeBlocks = new BlockList();
        bridgeBlocks.add(targetBlock);
        buildWith.modify(targetBlock);
        bridgeBlocks.setTimeToLive(parameters.getInt("undo", 0));
        this.registerForUndo(bridgeBlocks);
        this.controller.updateBlock(targetBlock);
        return SpellResult.CAST;
    }
}

