/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.spell.Spell;
import com.elmakers.mine.bukkit.utility.Messages;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CastingCost
implements com.elmakers.mine.bukkit.api.spell.CastingCost {
    protected MaterialAndData item;
    protected double amount;
    protected int xp;

    public CastingCost(String key, double cost) {
        if (key.toLowerCase().equals("xp")) {
            this.xp = (int)cost;
        } else {
            this.item = MaterialBrush.parseMaterialKey(key, true);
            this.amount = cost;
        }
    }

    public CastingCost(Material item, double amount) {
        this.item = new MaterialAndData(item, 0);
        this.amount = amount;
    }

    public CastingCost(Material item, byte data, double amount) {
        this.item = new MaterialAndData(item, data);
        this.amount = amount;
    }

    @Override
    public MaterialAndData getMaterial() {
        return this.item;
    }

    public Map<String, Object> export() {
        HashMap<String, Object> cost = new HashMap<String, Object>();
        cost.put("material", MaterialBrush.getMaterialName(this.item));
        cost.put("amount", this.amount);
        cost.put("xp", this.xp);
        return cost;
    }

    public boolean has(Spell spell) {
        boolean hasXp;
        Mage mage = spell.getMage();
        Inventory inventory = mage.getInventory();
        int amount = this.getAmount(spell);
        boolean hasItem = this.item == null || amount <= 0 || inventory.containsAtLeast(this.item.getItemStack(amount), amount);
        boolean bl = hasXp = this.xp <= 0 || mage.getExperience() >= this.getXP(spell);
        return hasItem && hasXp;
    }

    public void use(Spell spell) {
        int xp;
        Mage mage = spell.getMage();
        Inventory inventory = mage.getInventory();
        int amount = this.getAmount(spell);
        if (this.item != null && amount > 0) {
            ItemStack itemStack = this.getItemStack(spell);
            inventory.removeItem(new ItemStack[]{itemStack});
        }
        if ((xp = this.getXP(spell)) > 0) {
            mage.removeExperience(xp);
        }
    }

    protected ItemStack getItemStack() {
        return this.item.getItemStack(this.getAmount());
    }

    protected ItemStack getItemStack(CostReducer reducer) {
        return this.item.getItemStack(this.getAmount(reducer));
    }

    @Override
    public int getAmount() {
        return (int)Math.ceil(this.amount);
    }

    @Override
    public int getXP() {
        return this.xp;
    }

    @Override
    public int getAmount(CostReducer reducer) {
        float reduction;
        double reducedAmount = this.amount;
        float f = reduction = reducer == null ? 0.0f : reducer.getCostReduction();
        if (reduction > 0.0f) {
            reducedAmount = (double)(1.0f - reduction) * reducedAmount;
        }
        return (int)Math.ceil(reducedAmount);
    }

    @Override
    public int getXP(CostReducer reducer) {
        float reduction;
        float reducedAmount = this.xp;
        float f = reduction = reducer == null ? 0.0f : reducer.getCostReduction();
        if (reduction > 0.0f) {
            reducedAmount = (1.0f - reduction) * reducedAmount;
        }
        return (int)Math.ceil(reducedAmount);
    }

    @Override
    public boolean hasCosts(CostReducer reducer) {
        return this.item != null && this.getAmount(reducer) > 0 || this.getXP(reducer) > 0;
    }

    @Override
    public String getDescription(CostReducer reducer) {
        if (this.item != null && this.getAmount() != 0) {
            return MaterialBrush.getMaterialName(this.item);
        }
        if (reducer != null && !reducer.usesMana()) {
            return Messages.get("costs.xp");
        }
        return Messages.get("costs.mana");
    }

    @Override
    public String getFullDescription(CostReducer reducer) {
        if (this.item != null) {
            return String.valueOf(this.getAmount(reducer)) + " " + MaterialBrush.getMaterialName(this.item);
        }
        if (reducer != null && !reducer.usesMana()) {
            return Messages.get("costs.xp_amount").replace("$amount", Integer.valueOf(this.getXP(reducer)).toString());
        }
        return Messages.get("costs.mana_amount").replace("$amount", Integer.valueOf(this.getXP(reducer)).toString());
    }
}

