/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.listener;

import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import com.elmakers.mine.bukkit.plugins.magic.wand.WandLevel;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

public class EnchantingController
implements Listener {
    private final MagicController controller;
    private boolean enchantingEnabled = false;

    public EnchantingController(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection properties) {
        this.enchantingEnabled = properties.getBoolean("enable_enchanting", this.enchantingEnabled);
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        if (this.enchantingEnabled && Wand.isWand(event.getItem())) {
            event.getEnchantsToAdd().clear();
            int level = event.getExpLevelCost();
            Wand wand = new Wand(this.controller, event.getItem());
            if (!WandLevel.randomizeWand(wand, true, level)) {
                event.getEnchanter().sendMessage("This wand is fully enchanted (for now)");
            }
            wand.makeEnchantable(true);
            event.setCancelled(false);
            event.getEnchantsToAdd().put(null, 0);
        }
    }

    @EventHandler
    public void onPrepareEnchantItem(PrepareItemEnchantEvent event) {
        if (Wand.isWand(event.getItem())) {
            if (!this.enchantingEnabled) {
                event.setCancelled(true);
                return;
            }
            Wand wandItem = new Wand(this.controller, event.getItem());
            Player player = event.getEnchanter();
            if (!wandItem.isModifiable()) {
                event.setCancelled(true);
                return;
            }
            if (!wandItem.canUse(player)) {
                event.setCancelled(true);
                return;
            }
            wandItem.makeEnchantable(true);
            Set<Integer> levelSet = WandLevel.getLevels();
            ArrayList<Integer> levels = new ArrayList<Integer>();
            levels.addAll(levelSet);
            int[] offered = event.getExpLevelCostsOffered();
            int bonusLevels = event.getEnchantmentBonus();
            int maxLevel = (Integer)levels.get(levels.size() - 1) - 20 + bonusLevels;
            int i = 0;
            while (i < offered.length - 1) {
                int levelIndex = (int)((float)i * (float)levels.size() / (float)offered.length);
                levelIndex = (int)((float)levelIndex + (float)bonusLevels * (float)((i + 1) / offered.length));
                levelIndex = Math.min(levelIndex, levels.size() - 1);
                offered[i] = (Integer)levels.get(levelIndex);
                ++i;
            }
            offered[offered.length - 1] = maxLevel;
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        InventoryType inventoryType = event.getInventory().getType();
        InventoryType.SlotType slotType = event.getSlotType();
        if (this.enchantingEnabled && inventoryType == InventoryType.ENCHANTING && slotType == InventoryType.SlotType.CRAFTING) {
            Wand wand;
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            if (Wand.isWand(cursor) && (wand = new Wand(this.controller, cursor)).isModifiable()) {
                wand.makeEnchantable(true);
            }
            if (Wand.isWand(current) && (wand = new Wand(this.controller, current)).isModifiable()) {
                wand.makeEnchantable(false);
            }
            return;
        }
    }
}

