/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.BoundingBox;
import com.elmakers.mine.bukkit.block.VolumeBatch;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.spell.BlockSpell;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class RegenerateBatch
extends VolumeBatch {
    private final BlockList regeneratedBlocks = new BlockList();
    private final BlockList restoredBlocks = new BlockList();
    private final World world;
    private final Mage mage;
    private final BlockSpell spell;
    private final int absx;
    private final int absz;
    private final int dx;
    private final int dz;
    private final int x;
    private final int z;
    private int ix = 0;
    private int iz = 0;
    private int blockY = 0;
    private int blockX = 0;
    private int blockZ = 0;
    private int restoringIndex = 0;
    private boolean expand = false;
    private BoundingBox bounds = new BoundingBox();
    private RegenerateState state;

    public RegenerateBatch(BlockSpell spell, Location p1, Location p2) {
        super(spell.getMage().getController(), p1.getWorld().getName());
        this.mage = spell.getMage();
        this.world = this.mage.getPlayer().getWorld();
        this.spell = spell;
        this.state = RegenerateState.SAVING;
        int deltax = p2.getBlock().getChunk().getX() - p1.getChunk().getX();
        int deltaz = p2.getChunk().getZ() - p1.getChunk().getZ();
        this.absx = Math.abs(deltax) + 1;
        this.absz = Math.abs(deltaz) + 1;
        this.dx = (int)Math.signum(deltax);
        this.dz = (int)Math.signum(deltaz);
        this.x = p1.getChunk().getX();
        this.z = p1.getChunk().getZ();
        this.bounds = new BoundingBox(p1.toVector(), p2.toVector());
    }

    @Override
    public int size() {
        return this.absx * this.absz * 16 * 16 * 256;
    }

    @Override
    public int remaining() {
        return (this.absx - this.ix) * (this.absz - this.iz) * 16 * 16 * 256;
    }

    public boolean checkDimension(int maxDimension) {
        return maxDimension <= 0 || this.absx * 16 <= maxDimension && this.absz * 16 <= maxDimension;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int process(int maxBlocks) {
        int processedBlocks = 0;
        switch (this.state) {
            case SAVING: {
                block5: while (true) {
                    if (processedBlocks > maxBlocks || this.ix >= this.absx) {
                        if (this.ix < this.absx) return processedBlocks;
                        this.state = RegenerateState.REGENERATING;
                        this.ix = 0;
                        this.iz = 0;
                        return processedBlocks;
                    }
                    while (true) {
                        if (processedBlocks > maxBlocks || this.blockY >= 256) {
                            if (this.blockY < 256) continue block5;
                            this.blockX = 0;
                            this.blockZ = 0;
                            this.blockY = 0;
                            ++this.iz;
                            if (this.iz < this.absz) continue block5;
                            this.iz = 0;
                            ++this.ix;
                            continue block5;
                        }
                        Chunk chunk = this.world.getChunkAt(this.x + this.ix * this.dx, this.z + this.iz * this.dz);
                        if (!chunk.isLoaded()) {
                            chunk.load();
                            return processedBlocks;
                        }
                        Block block = chunk.getBlock(this.blockX, this.blockY, this.blockZ);
                        if (!this.spell.hasBuildPermission(block)) {
                            this.spell.sendMessage(this.spell.getMessage("insufficient_permissions"));
                            this.finish();
                            return processedBlocks;
                        }
                        if (!this.expand && !this.bounds.contains(block.getLocation().toVector())) {
                            this.restoredBlocks.add(block);
                        } else {
                            this.regeneratedBlocks.add(block);
                        }
                        ++processedBlocks;
                        ++this.blockX;
                        if (this.blockX <= 15) continue;
                        this.blockX = 0;
                        ++this.blockZ;
                        if (this.blockZ <= 15) continue;
                        this.blockZ = 0;
                        ++this.blockY;
                    }
                    break;
                }
            }
            case REGENERATING: {
                while (true) {
                    if (processedBlocks > maxBlocks || this.ix >= this.absx) {
                        if (this.ix < this.absx) return processedBlocks;
                        this.state = RegenerateState.RESTORING;
                        return processedBlocks;
                    }
                    Chunk chunk = this.world.getChunkAt(this.x + this.ix * this.dx, this.z + this.iz * this.dz);
                    if (!chunk.isLoaded()) {
                        chunk.load();
                        return processedBlocks;
                    }
                    processedBlocks += 65536;
                    this.world.regenerateChunk(chunk.getX(), chunk.getZ());
                    ++this.iz;
                    if (this.iz < this.absz) continue;
                    this.iz = 0;
                    ++this.ix;
                }
            }
            case RESTORING: {
                while (true) {
                    if (processedBlocks >= maxBlocks || this.restoringIndex >= this.restoredBlocks.size()) {
                        if (this.restoringIndex < this.restoredBlocks.size()) return processedBlocks;
                        this.finish();
                        return processedBlocks;
                    }
                    this.restoredBlocks.get(this.restoringIndex).restore();
                    ++this.restoringIndex;
                    ++processedBlocks;
                }
            }
        }
        return processedBlocks;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            super.finish();
            this.spell.registerForUndo(this.regeneratedBlocks);
            String message = this.spell.getMessage("cast_finish");
            this.spell.sendMessage(message);
        }
    }

    public int getXSize() {
        return this.absx;
    }

    public int getZSize() {
        return this.absz;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }

    private static enum RegenerateState {
        SAVING,
        REGENERATING,
        RESTORING;

    }
}

