/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.ConstructionType;
import com.elmakers.mine.bukkit.block.EntityData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.block.VolumeBatch;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.spell.BrushSpell;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.material.Button;
import org.bukkit.material.Lever;
import org.bukkit.material.MaterialData;
import org.bukkit.material.PistonBaseMaterial;
import org.bukkit.material.PoweredRail;
import org.bukkit.material.RedstoneWire;
import org.bukkit.util.Vector;

public class ConstructBatch
extends VolumeBatch {
    private final BlockList constructedBlocks = new BlockList();
    private final Location center;
    private Vector orient = null;
    private final int radius;
    private final ConstructionType type;
    private final int thickness;
    private final Mage mage;
    private final BrushSpell spell;
    private final boolean spawnFallingBlocks;
    private float fallingBlockSpeed = 0.0f;
    private boolean copyEntities = true;
    private final Map<Long, BlockData> attachedBlockMap = new HashMap<Long, BlockData>();
    private final List<BlockData> attachedBlockList = new ArrayList<BlockData>();
    private final List<BlockData> delayedBlocks = new ArrayList<BlockData>();
    private final Set<Material> attachables;
    private final Set<Material> attachablesWall;
    private final Set<Material> attachablesDouble;
    private final Set<Material> delayed;
    private Set<Material> replace;
    private Map<String, String> commandMap;
    private boolean finishedNonAttached = false;
    private boolean finishedAttached = false;
    private int attachedBlockIndex = 0;
    private int delayedBlockIndex = 0;
    private Integer maxOrientDimension = null;
    private Integer minOrientDimension = null;
    private boolean power = false;
    private int x = 0;
    private int y = 0;
    private int z = 0;
    private int r = 0;
    private boolean limitYAxis = false;

    public ConstructBatch(BrushSpell spell, Location center, ConstructionType type, int radius, int thickness, boolean spawnFallingBlocks, Location orientToLocation) {
        super(spell.getMage().getController(), center.getWorld().getName());
        this.center = center;
        this.radius = radius;
        this.type = type;
        this.thickness = thickness;
        this.spawnFallingBlocks = spawnFallingBlocks;
        this.mage = spell.getMage();
        this.spell = spell;
        this.attachables = this.mage.getController().getMaterialSet("attachable");
        this.attachablesWall = this.mage.getController().getMaterialSet("attachable_wall");
        this.attachablesDouble = this.mage.getController().getMaterialSet("attachable_double");
        this.delayed = this.mage.getController().getMaterialSet("delayed");
        if (orientToLocation != null) {
            Vector orientTo = orientToLocation.toVector().subtract(center.toVector());
            orientTo.setX(Math.abs(orientTo.getX()));
            orientTo.setY(Math.abs(orientTo.getY()));
            orientTo.setZ(Math.abs(orientTo.getZ()));
            this.orient = orientTo.getX() < orientTo.getZ() && orientTo.getX() < orientTo.getY() ? new Vector(1, 0, 0) : (orientTo.getZ() < orientTo.getX() && orientTo.getZ() < orientTo.getY() ? new Vector(0, 0, 1) : new Vector(0, 1, 0));
        } else {
            this.orient = new Vector(0, 1, 0);
        }
    }

    public void setPower(boolean power) {
        this.power = power;
    }

    public void setFallingBlockSpeed(float speed) {
        this.fallingBlockSpeed = speed;
    }

    public void setOrientDimensionMax(int maxDim) {
        this.maxOrientDimension = maxDim;
    }

    public void setOrientDimensionMin(int minDim) {
        this.minOrientDimension = minDim;
    }

    protected boolean canAttachTo(Material attachMaterial, Material material, boolean vertical) {
        if (vertical && attachMaterial == material) {
            return true;
        }
        if (material.isTransparent()) {
            return false;
        }
        return !this.attachables.contains(material) && !this.attachablesWall.contains(material) && !this.attachablesDouble.contains(material);
    }

    @Override
    public int size() {
        return this.radius * this.radius * this.radius * 8;
    }

    @Override
    public int remaining() {
        if (this.r >= this.radius) {
            return 0;
        }
        return (this.radius - this.r) * (this.radius - this.r) * (this.radius - this.r) * 8;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int process(int maxBlocks) {
        block25: {
            block24: {
                processedBlocks = 0;
                if (!this.finishedAttached) break block24;
                if (this.delayedBlockIndex < this.delayedBlocks.size()) ** GOTO lbl16
                this.finish();
                break block25;
lbl-1000:
                // 1 sources

                {
                    delayed = this.delayedBlocks.get(this.delayedBlockIndex);
                    block = delayed.getBlock();
                    if (!block.getChunk().isLoaded()) {
                        block.getChunk().load();
                        return processedBlocks;
                    }
                    this.constructedBlocks.add(block);
                    delayed.modify(block);
                    ++this.delayedBlockIndex;
lbl16:
                    // 2 sources

                    ** while (this.delayedBlockIndex < this.delayedBlocks.size() && processedBlocks < maxBlocks)
                }
lbl17:
                // 1 sources

                break block25;
            }
            if (this.finishedNonAttached) {
                while (this.attachedBlockIndex < this.attachedBlockList.size() && processedBlocks < maxBlocks) {
                    attach = this.attachedBlockList.get(this.attachedBlockIndex);
                    block = attach.getBlock();
                    if (!block.getChunk().isLoaded()) {
                        block.getChunk().load();
                        return processedBlocks;
                    }
                    underneath = block.getRelative(BlockFace.DOWN);
                    material = attach.getMaterial();
                    ok = this.canAttachTo(material, underneath.getType(), true);
                    if (!ok && this.attachablesDouble.contains(material)) {
                        attachedUnder = this.attachedBlockMap.get(BlockData.getBlockId(underneath));
                        v0 = ok = attachedUnder != null && attachedUnder.getMaterial() == material;
                        if (!ok) {
                            above = block.getRelative(BlockFace.UP);
                            attachedAbove = this.attachedBlockMap.get(BlockData.getBlockId(above));
                            v1 = ok = attachedAbove != null && attachedAbove.getMaterial() == material;
                        }
                    }
                    if (!ok && (canAttachToWall = this.attachablesWall.contains(material))) {
                        var11_17 = faces = new BlockFace[]{BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH};
                        var12_18 = faces.length;
                        var13_19 = 0;
                        while (var13_19 < var12_18) {
                            face = var11_17[var13_19];
                            if (this.canAttachTo(material, block.getRelative(face).getType(), false)) {
                                ok = true;
                                break;
                            }
                            ++var13_19;
                        }
                    }
                    if (ok) {
                        this.constructedBlocks.add(block);
                        attach.modify(block);
                    }
                    ++this.attachedBlockIndex;
                }
                if (this.attachedBlockIndex >= this.attachedBlockList.size()) {
                    this.finishedAttached = true;
                }
            } else {
                yBounds = this.radius;
                if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockY() > 0) {
                    this.limitYAxis = true;
                    yBounds = Math.max(this.minOrientDimension == null ? this.radius : this.minOrientDimension, this.maxOrientDimension == null ? this.radius : this.maxOrientDimension);
                }
                yBounds = Math.min(yBounds, 255);
                while (processedBlocks <= maxBlocks && !this.finishedNonAttached) {
                    if (!this.fillBlock(this.x, this.y, this.z)) {
                        return processedBlocks;
                    }
                    xBounds = this.r;
                    zBounds = this.r;
                    if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockX() > 0) {
                        xBounds = Math.max(this.minOrientDimension == null ? this.r : this.minOrientDimension, this.maxOrientDimension == null ? this.r : this.maxOrientDimension);
                    }
                    if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockZ() > 0) {
                        zBounds = Math.max(this.minOrientDimension == null ? this.r : this.minOrientDimension, this.maxOrientDimension == null ? this.r : this.maxOrientDimension);
                    }
                    ++this.y;
                    if (this.y > yBounds) {
                        this.y = 0;
                        if (this.x < xBounds) {
                            ++this.x;
                        } else {
                            --this.z;
                            if (this.z < 0) {
                                ++this.r;
                                zBounds = this.r;
                                if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockZ() > 0) {
                                    zBounds = Math.max(this.minOrientDimension == null ? this.r : this.minOrientDimension, this.maxOrientDimension == null ? this.r : this.maxOrientDimension);
                                }
                                this.z = zBounds;
                                this.x = 0;
                            }
                        }
                    }
                    if (this.r > this.radius) {
                        this.finishedNonAttached = true;
                        break;
                    }
                    ++processedBlocks;
                }
            }
        }
        return processedBlocks;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            super.finish();
            MaterialBrush brush = this.spell.getMaterialBrush();
            if (this.copyEntities && this.thickness == 0 && brush != null && brush.hasEntities()) {
                List<EntityData> entities = brush.getEntities(this.center, this.radius);
                for (EntityData entity : entities) {
                    Location targetLocation = entity.getLocation();
                    switch (entity.getType()) {
                        case PAINTING: {
                            InventoryUtils.spawnPainting(targetLocation, entity.getFacing(), entity.getArt());
                            break;
                        }
                        case ITEM_FRAME: {
                            InventoryUtils.spawnItemFrame(targetLocation, entity.getFacing(), entity.getItem());
                            break;
                        }
                    }
                }
            }
            this.spell.registerForUndo(this.constructedBlocks);
            String message = this.spell.getMessage("cast_finish");
            message = message.replace("$count", Integer.toString(this.constructedBlocks.size()));
            this.mage.sendMessage(message);
        }
    }

    public void setCopyEntities(boolean doCopy) {
        this.copyEntities = doCopy;
    }

    public boolean fillBlock(int x, int y, int z) {
        boolean fillBlock = false;
        switch (this.type) {
            case SPHERE: {
                int maxDistanceSquared = this.radius * this.radius;
                float mx = (float)x - 0.5f;
                float my = (float)y - 0.5f;
                float mz = (float)z - 0.5f;
                int distanceSquared = (int)(mx * mx + my * my + mz * mz);
                if (this.thickness == 0) {
                    fillBlock = distanceSquared <= maxDistanceSquared;
                    break;
                }
                int outerDistanceSquared = (int)((mx += 1.0f) * mx + (my += 1.0f) * my + (mz += 1.0f) * mz);
                fillBlock = maxDistanceSquared >= distanceSquared - this.thickness && maxDistanceSquared <= outerDistanceSquared;
                break;
            }
            case PYRAMID: {
                int elevation = this.radius - y;
                if (this.thickness == 0) {
                    fillBlock = x <= elevation && z <= elevation;
                    break;
                }
                fillBlock = x <= elevation && x >= elevation - this.thickness && z <= elevation || z <= elevation && z >= elevation - this.thickness && x <= elevation;
                break;
            }
            default: {
                fillBlock = this.thickness == 0 ? true : x >= this.radius - this.thickness || y >= this.radius - this.thickness || z >= this.radius - this.thickness;
            }
        }
        boolean success = true;
        if (fillBlock) {
            if (y != 0) {
                boolean bl = success = success && this.constructBlock(x, -y, z);
                if (x != 0) {
                    boolean bl2 = success = success && this.constructBlock(-x, -y, z);
                }
                if (z != 0) {
                    boolean bl3 = success = success && this.constructBlock(x, -y, -z);
                }
                if (x != 0 && z != 0) {
                    success = success && this.constructBlock(-x, -y, -z);
                }
            }
            boolean bl = success = success && this.constructBlock(x, y, z);
            if (x != 0) {
                boolean bl4 = success = success && this.constructBlock(-x, y, z);
            }
            if (z != 0) {
                boolean bl5 = success = success && this.constructBlock(x, y, -z);
            }
            if (z != 0 && x != 0) {
                success = success && this.constructBlock(-x, y, -z);
            }
        }
        return success;
    }

    public boolean constructBlock(int dx, int dy, int dz) {
        if (this.limitYAxis && this.minOrientDimension != null && dy < -this.minOrientDimension.intValue()) {
            return true;
        }
        if (this.limitYAxis && this.maxOrientDimension != null && dy > this.maxOrientDimension) {
            return true;
        }
        int x = this.center.getBlockX() + dx;
        int y = this.center.getBlockY() + dy;
        int z = this.center.getBlockZ() + dz;
        if (y < 0 || y > 255) {
            return true;
        }
        Block block = this.center.getWorld().getBlockAt(x, y, z);
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load();
            return false;
        }
        if (this.power) {
            Material material = block.getType();
            BlockState blockState = block.getState();
            MaterialData data = blockState.getData();
            boolean powerBlock = false;
            if (data instanceof Button) {
                Button powerData = (Button)data;
                this.constructedBlocks.add(block);
                powerData.setPowered(!powerData.isPowered());
                powerBlock = true;
            } else if (data instanceof Lever) {
                Lever powerData = (Lever)data;
                this.constructedBlocks.add(block);
                powerData.setPowered(!powerData.isPowered());
                powerBlock = true;
            } else if (data instanceof PistonBaseMaterial) {
                PistonBaseMaterial powerData = (PistonBaseMaterial)data;
                this.constructedBlocks.add(block);
                powerData.setPowered(!powerData.isPowered());
                powerBlock = true;
            } else if (data instanceof PoweredRail) {
                PoweredRail powerData = (PoweredRail)data;
                this.constructedBlocks.add(block);
                powerData.setPowered(!powerData.isPowered());
                powerBlock = true;
            } else if (data instanceof RedstoneWire) {
                RedstoneWire wireData = (RedstoneWire)data;
                this.constructedBlocks.add(block);
                wireData.setData((byte)(15 - wireData.getData()));
                powerBlock = true;
            } else if (material == Material.REDSTONE_BLOCK) {
                this.constructedBlocks.add(block);
                block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, material.getId());
                block.setType(Material.AIR);
            } else if (material == Material.REDSTONE_TORCH_OFF) {
                this.constructedBlocks.add(block);
                block.setType(Material.REDSTONE_TORCH_ON);
            } else if (material == Material.REDSTONE_TORCH_ON) {
                this.constructedBlocks.add(block);
                block.setType(Material.REDSTONE_TORCH_OFF);
            } else if (material == Material.TNT) {
                block.setType(Material.AIR);
                block.getLocation().getWorld().spawnEntity(block.getLocation(), EntityType.PRIMED_TNT);
            }
            if (powerBlock) {
                blockState.update();
            }
            return true;
        }
        MaterialBrush brush = this.spell.getMaterialBrush();
        brush.update(this.mage, block.getLocation());
        if (!brush.isReady()) {
            brush.prepare();
            return false;
        }
        if (this.attachables.contains(brush.getMaterial()) || this.attachablesWall.contains(brush.getMaterial()) || this.attachablesDouble.contains(brush.getMaterial())) {
            BlockData attachBlock = new BlockData(block);
            attachBlock.updateFrom(brush);
            this.attachedBlockMap.put(attachBlock.getId(), attachBlock);
            this.attachedBlockList.add(attachBlock);
            return true;
        }
        if (this.delayed.contains(brush.getMaterial())) {
            BlockData delayBlock = new BlockData(block);
            delayBlock.updateFrom(brush);
            this.delayedBlocks.add(delayBlock);
            return true;
        }
        if (!this.spell.isDestructible(block)) {
            return true;
        }
        if (this.replace != null && this.replace.size() > 0 && !this.replace.contains(block.getType())) {
            return true;
        }
        if (!this.spell.hasBuildPermission(block)) {
            return true;
        }
        Material previousMaterial = block.getType();
        byte previousData = block.getData();
        if (brush.isDifferent(block)) {
            String commandKey;
            this.updateBlock(this.center.getWorld().getName(), x, y, z);
            this.constructedBlocks.add(block);
            if (this.commandMap != null && brush.getMaterial() == Material.COMMAND && (commandKey = brush.getCommandLine()) != null && commandKey.length() > 0 && this.commandMap.containsKey(commandKey)) {
                brush.setCommandLine(this.commandMap.get(commandKey));
            }
            brush.modify(block);
            if (this.spawnFallingBlocks) {
                FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation(), previousMaterial, previousData);
                falling.setDropItem(false);
                if (this.fallingBlockSpeed != 0.0f) {
                    Vector direction = falling.getLocation().subtract(this.center).toVector().normalize().multiply(this.fallingBlockSpeed);
                    falling.setVelocity(direction);
                }
            }
        }
        return true;
    }

    public void setTimeToLive(int timeToLive) {
        this.constructedBlocks.setTimeToLive(timeToLive);
    }

    public void addCommandMapping(String key, String command) {
        if (this.commandMap == null) {
            this.commandMap = new HashMap<String, String>();
        }
        this.commandMap.put(key, command);
    }

    public void setReplace(Collection<Material> replace) {
        this.replace = new HashSet<Material>();
        this.replace.addAll(replace);
    }
}

