/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.traders;

import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import java.util.UUID;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeValueNotFoundException;
import net.dandielo.citizens.traders_v3.utils.items.Attribute;
import net.dandielo.citizens.traders_v3.utils.items.ItemAttr;
import org.bukkit.inventory.ItemStack;

@Attribute(name="Wand Unique Id", key="wand_id", priority=5)
public class WandIdAttr
extends ItemAttr {
    public WandIdAttr(String key) {
        super(key);
    }

    public void onFactorize(ItemStack itemStack) throws AttributeValueNotFoundException {
        if (itemStack == null || !InventoryUtils.hasMeta(itemStack, "wand")) {
            throw new AttributeValueNotFoundException();
        }
        Object tagNode = InventoryUtils.getNode(itemStack, "wand");
        if (tagNode == null) {
            throw new AttributeValueNotFoundException();
        }
        String tagData = InventoryUtils.getMeta(tagNode, "id");
        if (tagData == null || tagData.length() == 0) {
            throw new AttributeValueNotFoundException();
        }
    }

    public void onLoad(String itemKey) {
    }

    public String onSave() {
        return "";
    }

    public boolean equalsWeak(ItemAttr other) {
        return other instanceof WandIdAttr;
    }

    public boolean equalsStrong(ItemAttr other) {
        return other instanceof WandIdAttr;
    }

    public void onAssign(ItemStack itemStack) {
        Object wandNode = InventoryUtils.createNode(itemStack, "wand");
        InventoryUtils.setMeta(wandNode, "id", UUID.randomUUID().toString());
    }

    public ItemStack onReturnAssign(ItemStack itemStack, boolean endItem) {
        if (itemStack != null && endItem) {
            itemStack = InventoryUtils.makeReal(itemStack);
            this.onAssign(itemStack);
        }
        return itemStack;
    }
}

