/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.traders;

import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeValueNotFoundException;
import net.dandielo.citizens.traders_v3.utils.items.ItemFlag;
import org.bukkit.inventory.ItemStack;

public abstract class NBTItemFlag
extends ItemFlag {
    private static final boolean DEBUG = false;
    private String tagName;
    private String subtagName;

    public NBTItemFlag(String key, String tag, String subtag) {
        super(key);
        this.tagName = tag;
        this.subtagName = subtag;
    }

    public void onFactorize(ItemStack itemStack) throws AttributeValueNotFoundException {
        if (itemStack == null || !InventoryUtils.hasMeta(itemStack, this.tagName)) {
            throw new AttributeValueNotFoundException();
        }
        String testData = null;
        if (this.subtagName != null && this.subtagName.length() > 0) {
            Object tagNode = InventoryUtils.getNode(itemStack, this.tagName);
            if (tagNode == null) {
                throw new AttributeValueNotFoundException();
            }
            testData = InventoryUtils.getMeta(tagNode, this.subtagName);
        } else {
            testData = InventoryUtils.getMeta(itemStack, this.tagName);
        }
        if (!this.parseBoolean(testData)) {
            throw new AttributeValueNotFoundException();
        }
    }

    protected boolean parseBoolean(String s) {
        return s != null && (s.equalsIgnoreCase("true") || s.equals("1"));
    }

    public void onAssign(ItemStack itemStack) {
        if (itemStack != null) {
            if (this.subtagName != null && this.subtagName.length() > 0) {
                Object tagNode = InventoryUtils.createNode(itemStack, this.tagName);
                if (tagNode != null) {
                    InventoryUtils.setMeta(tagNode, this.subtagName, "true");
                }
            } else {
                InventoryUtils.setMeta(itemStack, this.tagName, "true");
            }
        }
    }
}

