/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.traders;

import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeInvalidValueException;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeValueNotFoundException;
import net.dandielo.citizens.traders_v3.utils.items.ItemAttr;
import org.bukkit.inventory.ItemStack;

public abstract class NBTItemAttr
extends ItemAttr {
    private static final boolean DEBUG = false;
    private String tagName;
    private String subtagName;
    private String defaultValue = "";
    private String defaultValue2 = "";
    private String tagData = "";

    public NBTItemAttr(String key, String tag, String subtag) {
        super(key);
        this.tagName = tag;
        this.subtagName = subtag;
    }

    public NBTItemAttr(String key, String tag, String subtag, String def) {
        super(key);
        this.tagName = tag;
        this.subtagName = subtag;
        this.defaultValue = def;
    }

    public NBTItemAttr(String key, String tag, String subtag, String def, String def2) {
        super(key);
        this.tagName = tag;
        this.subtagName = subtag;
        this.defaultValue = def;
        this.defaultValue2 = def2;
    }

    public void onFactorize(ItemStack itemStack) throws AttributeValueNotFoundException {
        this.tagData = null;
        if (itemStack == null || !InventoryUtils.hasMeta(itemStack, this.tagName)) {
            throw new AttributeValueNotFoundException();
        }
        if (this.subtagName != null && this.subtagName.length() > 0) {
            Object tagNode = InventoryUtils.getNode(itemStack, this.tagName);
            if (tagNode == null) {
                throw new AttributeValueNotFoundException();
            }
            this.tagData = InventoryUtils.getMeta(tagNode, this.subtagName);
        } else {
            this.tagData = InventoryUtils.getMeta(itemStack, this.tagName);
        }
        if (this.tagData == null || this.tagData.length() == 0 || this.tagData.equals(this.defaultValue) || this.tagData.equals(this.defaultValue2)) {
            throw new AttributeValueNotFoundException();
        }
    }

    public void onLoad(String itemKey) throws AttributeInvalidValueException {
        if (itemKey == null || itemKey.length() == 0 || itemKey.equals(this.defaultValue) || itemKey.equals(this.defaultValue2)) {
            throw new AttributeInvalidValueException(this.info, "No data: " + this.defaultValue);
        }
        this.tagData = itemKey;
        this.tagData = this.tagData.replace("|", ":");
    }

    public String onSave() {
        if (this.tagData == null) {
            this.tagData = "";
        }
        return this.tagData.replace(":", "|");
    }

    public void onAssign(ItemStack itemStack) {
        if (this.tagData != null && this.tagData.length() > 0 && itemStack != null) {
            if (this.subtagName != null && this.subtagName.length() > 0) {
                Object tagNode = InventoryUtils.createNode(itemStack, this.tagName);
                if (tagNode != null) {
                    InventoryUtils.setMeta(tagNode, this.subtagName, this.tagData);
                }
            } else {
                InventoryUtils.setMeta(itemStack, this.tagName, this.tagData);
            }
        }
    }

    public ItemStack onReturnAssign(ItemStack itemStack, boolean endItem) {
        if (this.tagData != null && this.tagData.length() > 0 && itemStack != null) {
            itemStack = InventoryUtils.makeReal(itemStack);
            this.onAssign(itemStack);
        }
        return itemStack;
    }

    public boolean equalsWeak(ItemAttr other) {
        if (other instanceof NBTItemAttr) {
            return this.tagData.equalsIgnoreCase(((NBTItemAttr)other).tagData);
        }
        return false;
    }

    public boolean equalsStrong(ItemAttr other) {
        if (other instanceof NBTItemAttr) {
            return this.tagData.equalsIgnoreCase(((NBTItemAttr)other).tagData);
        }
        return false;
    }
}

