/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.wand;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.utility.RunnableJob;
import java.util.LinkedList;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class WandCleanupRunnable
extends RunnableJob {
    private final LinkedList<LostWand> lostWands = new LinkedList();
    private final World world;
    private final MagicAPI api;
    private final String owner;
    private final boolean removeAll;

    public WandCleanupRunnable(MagicAPI api, World world, String owner) {
        super(api.getLogger());
        this.world = world;
        this.api = api;
        this.lostWands.addAll(api.getLostWands());
        this.removeAll = false;
        this.owner = owner == null ? "" : owner;
    }

    public WandCleanupRunnable(MagicAPI api, World world) {
        super(api.getLogger());
        this.world = world;
        this.api = api;
        this.removeAll = true;
        this.owner = "";
        this.lostWands.addAll(api.getLostWands());
    }

    @Override
    public void finish() {
        super.finish();
        this.lostWands.clear();
    }

    public void run() {
        Entity[] entities;
        Chunk chunk;
        if (this.lostWands.isEmpty()) {
            this.finish();
            return;
        }
        LostWand lostWand = this.lostWands.getFirst();
        Location location = lostWand.getLocation();
        if (this.world != null && !location.getWorld().getName().equals(this.world.getName())) {
            this.lostWands.removeFirst();
            return;
        }
        String lostWandOwner = lostWand.getOwner();
        String string = lostWandOwner = lostWandOwner == null ? "" : lostWandOwner;
        if (!this.removeAll) {
            if (this.owner.length() == 0 && lostWandOwner.length() > 0) {
                this.lostWands.removeFirst();
                return;
            }
            if (this.owner.length() > 0 && !lostWandOwner.equals(this.owner)) {
                this.lostWands.removeFirst();
                return;
            }
        }
        if (!(chunk = location.getChunk()).isLoaded()) {
            chunk.load();
            return;
        }
        for (Entity entity : entities = chunk.getEntities()) {
            Wand wand;
            Item item;
            ItemStack itemStack;
            if (!(entity instanceof Item) || !this.api.isWand(itemStack = (item = (Item)entity).getItemStack()) || !(wand = this.api.getWand(itemStack)).getId().equals(lostWand.getId())) continue;
            this.logger.info("Removed lost wand " + lostWand.getName() + " (" + lostWand.getOwner() + "), id " + lostWand.getId() + " in " + location.getWorld().getName() + " at " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
            this.api.removeLostWand(lostWand.getId());
            item.remove();
            this.lostWands.removeFirst();
            return;
        }
        this.lostWands.removeFirst();
        this.api.removeLostWand(lostWand.getId());
        this.logger.info("Could not find wand " + lostWand.getName() + " (" + lostWand.getOwner() + "), id " + lostWand.getId() + ", removing from list");
    }
}

