/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.spell.BlockSpell;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class TunnelSpell
extends BlockSpell {
    private int defaultDepth = 8;
    private int defaultWidth = 3;
    private int defaultHeight = 3;
    private int defaultSearchDistance = 32;
    private int torchFrequency = 4;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block bottomBlock;
        this.defaultDepth = parameters.getInt("depth", this.defaultDepth);
        this.defaultWidth = parameters.getInt("width", this.defaultWidth);
        this.defaultHeight = parameters.getInt("height", this.defaultHeight);
        this.defaultSearchDistance = parameters.getInt("search_distance", this.defaultSearchDistance);
        this.torchFrequency = parameters.getInt("torch_frequency", this.torchFrequency);
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(playerBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        BlockFace direction = this.getPlayerFacing();
        Block searchBlock = playerBlock.getRelative(BlockFace.UP).getRelative(BlockFace.UP);
        for (int searchDistance = 0; searchBlock.getType() == Material.AIR && searchDistance < this.defaultSearchDistance; ++searchDistance) {
            searchBlock = searchBlock.getRelative(direction);
        }
        int depth = this.defaultDepth;
        int height = this.defaultHeight;
        int width = this.defaultWidth;
        BlockList tunneledBlocks = new BlockList();
        BlockFace toTheLeft = TunnelSpell.goLeft(direction);
        BlockFace toTheRight = TunnelSpell.goRight(direction);
        Block bottomLeftBlock = bottomBlock = searchBlock.getRelative(BlockFace.DOWN);
        for (int i = 0; i < width / 2; ++i) {
            bottomLeftBlock = bottomLeftBlock.getRelative(toTheLeft);
        }
        Block targetBlock = bottomLeftBlock;
        for (int d = 0; d < depth; ++d) {
            bottomBlock = bottomLeftBlock;
            for (int w = 0; w < width; ++w) {
                targetBlock = bottomBlock;
                for (int h = 0; h < height; ++h) {
                    if (this.isDestructible(targetBlock) && this.hasBuildPermission(targetBlock)) {
                        boolean useTorch = false;
                        tunneledBlocks.add(targetBlock);
                        if (useTorch) {
                            Block checkBlock = null;
                            checkBlock = w == 0 ? targetBlock.getRelative(toTheLeft) : targetBlock.getRelative(toTheRight);
                            if (checkBlock.getType() == Material.AIR) {
                                targetBlock.setType(Material.AIR);
                            } else {
                                targetBlock.setType(Material.TORCH);
                            }
                        } else {
                            targetBlock.setType(Material.AIR);
                        }
                    }
                    targetBlock = targetBlock.getRelative(BlockFace.UP);
                }
                bottomBlock = bottomBlock.getRelative(toTheRight);
            }
            bottomLeftBlock = bottomLeftBlock.getRelative(direction);
        }
        this.registerForUndo(tunneledBlocks);
        return SpellResult.CAST;
    }
}

