/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.BlockRecurse;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.block.ReplaceMaterialAction;
import com.elmakers.mine.bukkit.plugins.magic.spell.BrushSpell;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class RecurseSpell
extends BrushSpell {
    private final BlockRecurse blockRecurse = new BlockRecurse();

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialBrush buildWith = this.getMaterialBrush();
        int size = parameters.getInt("size", 8);
        size = (int)(this.mage.getRadiusMultiplier() * (float)size);
        this.blockRecurse.setMaxRecursion(size);
        Material targetMaterial = targetBlock.getType();
        ReplaceMaterialAction action = new ReplaceMaterialAction(this.mage, targetBlock, buildWith);
        if (targetMaterial == Material.STATIONARY_WATER || targetMaterial == Material.WATER) {
            for (byte i = 0; i < 9; i = (byte)(i + 1)) {
                action.addReplaceable(Material.STATIONARY_WATER, i);
                action.addReplaceable(Material.WATER, i);
            }
        } else if (targetMaterial == Material.STATIONARY_LAVA || targetMaterial == Material.LAVA) {
            for (byte i = 0; i < 9; i = (byte)(i + 1)) {
                action.addReplaceable(Material.STATIONARY_LAVA, i);
                action.addReplaceable(Material.LAVA, i);
            }
        } else if (targetMaterial == Material.SNOW) {
            for (byte i = 0; i < 8; i = (byte)(i + 1)) {
                action.addReplaceable(Material.SNOW, i);
            }
        }
        this.blockRecurse.recurse(targetBlock, action);
        this.mage.registerForUndo(action.getBlocks());
        this.controller.updateBlock(targetBlock);
        return SpellResult.CAST;
    }
}

