/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.spell.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.spell.TargetingSpell;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.entity.EntityDamageEvent;

public class InvincibleSpell
extends TargetingSpell {
    protected float protectAmount = 0.0f;
    protected int amount = 100;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        this.amount = parameters.getInt("amount", this.amount);
        if (this.protectAmount != 0.0f) {
            this.deactivate();
            return SpellResult.COST_FREE;
        }
        this.activate();
        return SpellResult.CAST;
    }

    @Override
    public void onDeactivate() {
        this.controller.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
        this.protectAmount = 0.0f;
    }

    @Override
    public void onActivate() {
        this.controller.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
        this.protectAmount = (float)this.amount / 100.0f;
    }

    @Override
    public void onPlayerDamage(EntityDamageEvent event) {
        if (this.protectAmount > 0.0f) {
            if (this.protectAmount >= 1.0f) {
                event.setCancelled(true);
            } else {
                int newDamage = (int)Math.floor((double)(1.0f - this.protectAmount) * event.getDamage());
                if (newDamage == 0) {
                    newDamage = 1;
                }
                event.setDamage((double)newDamage);
            }
        }
    }
}

