/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.spell.TargetingSpell;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class HatSpell
extends TargetingSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block target;
        Player player = this.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        Material material = Material.AIR;
        Set<Material> buildingMaterials = this.controller.getBuildingMaterials();
        byte data = 0;
        if (!this.isUnderwater()) {
            this.noTargetThrough(Material.STATIONARY_WATER);
            this.noTargetThrough(Material.WATER);
        }
        if ((target = this.getTargetBlock()) == null) {
            return SpellResult.NO_TARGET;
        }
        material = target.getType();
        data = target.getData();
        if (material == null || material == Material.AIR || !buildingMaterials.contains(material)) {
            return SpellResult.NO_TARGET;
        }
        ItemStack hatItem = new ItemStack(material, 1, (short)data);
        ItemStack itemStack = player.getInventory().getHelmet();
        player.getInventory().setHelmet(hatItem);
        if (itemStack != null && itemStack.getType() != Material.AIR) {
            player.getWorld().dropItemNaturally(player.getLocation(), itemStack);
        }
        return SpellResult.CAST;
    }
}

