/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.Target;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class GotoSpell
extends TargetingSpell {
    LivingEntity targetEntity = null;
    int playerIndex = 0;
    private Color effectColor = null;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        this.effectColor = this.mage.getEffectColor();
        if (this.effectColor == null) {
            this.effectColor = Color.fromRGB((int)Integer.parseInt(parameters.getString("effect_color", "FF0000"), 16));
        }
        if (this.targetEntity != null && this.targetEntity instanceof LivingEntity) {
            Mage targetMage;
            if (!this.targetEntity.isValid() || this.targetEntity.isDead()) {
                this.releaseTarget();
            }
            if (this.targetEntity != null && this.targetEntity instanceof Player && (targetMage = this.controller.getMage((Player)this.targetEntity)).isSuperProtected()) {
                this.releaseTarget();
            }
        }
        if (this.targetEntity == null || !this.isLookingUp() && !this.isLookingDown()) {
            Mage targetMage;
            Target target = this.getTarget();
            if (!target.hasEntity() || !(target.getEntity() instanceof LivingEntity)) {
                return this.teleportTarget(target.getLocation()) ? SpellResult.CAST : SpellResult.NO_TARGET;
            }
            if (this.targetEntity instanceof Player && (targetMage = this.controller.getMage((Player)this.targetEntity)).isSuperProtected()) {
                return SpellResult.NO_TARGET;
            }
            this.selectTarget((LivingEntity)target.getEntity());
            return SpellResult.TARGET_SELECTED;
        }
        if (this.isLookingUp() && this.targetEntity != null) {
            this.getCurrentTarget().setEntity((Entity)this.targetEntity);
            this.getPlayer().teleport(this.targetEntity.getLocation());
            this.castMessage(this.getMessage("cast_to_player").replace("$target", GotoSpell.getTargetName((Entity)this.targetEntity)));
            this.releaseTarget();
            return SpellResult.CAST;
        }
        ArrayList<String> playerNames = new ArrayList<String>(this.controller.getPlugin().getPlayerNames());
        if (playerNames.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        if (this.playerIndex < 0) {
            this.playerIndex = playerNames.size() - 1;
        }
        if (this.playerIndex >= playerNames.size()) {
            this.playerIndex = 0;
            this.releaseTarget();
            return SpellResult.TARGET_SELECTED;
        }
        Player player = this.getPlayer();
        String playerName = (String)playerNames.get(this.playerIndex);
        if (player != null && playerName.equals(player.getName())) {
            if (playerNames.size() == 1) {
                return SpellResult.NO_TARGET;
            }
            this.playerIndex = (this.playerIndex + 1) % playerNames.size();
            playerName = (String)playerNames.get(this.playerIndex);
        }
        ++this.playerIndex;
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            return SpellResult.NO_TARGET;
        }
        this.selectTarget((LivingEntity)targetPlayer);
        return SpellResult.TARGET_SELECTED;
    }

    protected boolean teleportTarget(Location location) {
        if (this.targetEntity == null || location == null) {
            return false;
        }
        this.targetEntity.teleport(location);
        this.getCurrentTarget().setEntity((Entity)this.targetEntity);
        return true;
    }

    protected void selectTarget(LivingEntity entity) {
        this.releaseTarget();
        this.targetEntity = entity;
        this.getCurrentTarget().setEntity((Entity)entity);
        if (this.effectColor != null) {
            InventoryUtils.addPotionEffect(this.targetEntity, this.effectColor);
        }
    }

    protected void releaseTarget() {
        if (this.targetEntity != null && this.effectColor != null) {
            InventoryUtils.clearPotionEffect(this.targetEntity);
        }
        this.targetEntity = null;
    }

    @Override
    public boolean onCancel() {
        if (this.targetEntity != null) {
            this.releaseTarget();
            return true;
        }
        return false;
    }
}

