/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.spell.BlockSpell;
import com.elmakers.mine.bukkit.utilities.ConfigurationUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public abstract class BrushSpell
extends BlockSpell {
    private MaterialBrush brush;
    private boolean hasBrush = false;
    public static final String[] BRUSH_PARAMETERS = new String[]{"brushmod", "brush", "obx", "oby", "obz", "obworld", "btarget"};

    @Override
    protected void processParameters(ConfigurationSection parameters) {
        super.processParameters(parameters);
        String materialKey = parameters.getString("brush", null);
        if (materialKey != null) {
            this.brush = new MaterialBrush(this.mage, this.getLocation(), materialKey);
            if (parameters.contains("brushmod")) {
                this.brush.update(parameters.getString("brushmod"));
                this.brush.update(materialKey);
            }
            Double dmxValue = ConfigurationUtils.getDouble(parameters, "obx", null);
            Double dmyValue = ConfigurationUtils.getDouble(parameters, "oby", null);
            Double dmzValue = ConfigurationUtils.getDouble(parameters, "obz", null);
            String targetWorldName = parameters.getString("obworld", null);
            if (dmxValue != null || dmyValue != null || dmzValue != null || targetWorldName != null) {
                Vector offset = new Vector(dmxValue == null ? 0.0 : dmxValue, dmyValue == null ? 0.0 : dmyValue, dmzValue == null ? 0.0 : dmzValue);
                this.brush.clearCloneTarget();
                this.brush.setTargetOffset(offset, targetWorldName);
            }
            if (parameters.getBoolean("brushtarget", false)) {
                this.brush.clearCloneLocation();
            }
        } else {
            this.brush = null;
        }
    }

    @Override
    protected void loadTemplate(ConfigurationSection node) {
        super.loadTemplate(node);
        this.hasBrush = this.parameters.contains("brush");
    }

    public MaterialBrush getMaterialBrush() {
        if (this.brush != null) {
            return this.brush;
        }
        return this.mage.getBrush();
    }

    @Override
    public MaterialAndData getEffectMaterial() {
        return this.brush != null ? this.brush : this.mage.getBrush();
    }

    public boolean hasBrushOverride() {
        return this.brush != null || this.hasBrush;
    }

    @Override
    protected String getDisplayMaterialName() {
        MaterialBrush useBrush = this.getMaterialBrush();
        if (useBrush != null) {
            return useBrush.getName();
        }
        return super.getDisplayMaterialName();
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(BRUSH_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("bmod") || parameterKey.equals("brush")) {
            examples.addAll(this.controller.getMaterials());
        } else if (parameterKey.equals("btarget")) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("obx") || parameterKey.equals("oby") || parameterKey.equals("obz")) {
            examples.addAll(Arrays.asList(EXAMPLE_VECTOR_COMPONENTS));
        } else if (parameterKey.equals("obworld")) {
            List worlds = Bukkit.getWorlds();
            for (World world : worlds) {
                examples.add(world.getName());
            }
        }
    }
}

