/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.plugins.magic.spell.Spell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public abstract class BaseSpell
extends Spell {
    protected static final double VIEW_HEIGHT = 1.65;
    protected static final double LOOK_THRESHOLD_RADIANS = 0.8;
    private long lastMessageSent = 0L;
    private Set<Material> preventPassThroughMaterials = null;

    @Override
    public Player getPlayer() {
        return this.mage.getPlayer();
    }

    @Override
    public CommandSender getCommandSender() {
        return this.mage.getCommandSender();
    }

    public boolean allowPassThrough(Material mat) {
        if (this.mage != null && this.mage.isSuperPowered()) {
            return true;
        }
        return this.preventPassThroughMaterials == null || !this.preventPassThroughMaterials.contains(mat);
    }

    public boolean isOkToStandIn(Material mat) {
        return mat == Material.AIR || mat == Material.WATER || mat == Material.STATIONARY_WATER || mat == Material.SNOW || mat == Material.TORCH || mat == Material.SIGN_POST || mat == Material.REDSTONE_TORCH_ON || mat == Material.REDSTONE_TORCH_OFF || mat == Material.YELLOW_FLOWER || mat == Material.RED_ROSE || mat == Material.RED_MUSHROOM || mat == Material.BROWN_MUSHROOM || mat == Material.LONG_GRASS;
    }

    public boolean isWater(Material mat) {
        return mat == Material.WATER || mat == Material.STATIONARY_WATER;
    }

    public boolean isOkToStandOn(Material mat) {
        return mat != Material.AIR && mat != Material.LAVA && mat != Material.STATIONARY_LAVA;
    }

    public boolean isSafeLocation(Block block) {
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return false;
        }
        if (block.getY() > 255) {
            return false;
        }
        Block blockOneUp = block.getRelative(BlockFace.UP);
        Block blockOneDown = block.getRelative(BlockFace.DOWN);
        Player player = this.mage.getPlayer();
        return (this.isOkToStandOn(blockOneDown.getType()) || player != null && player.isFlying()) && this.isOkToStandIn(blockOneUp.getType()) && this.isOkToStandIn(block.getType());
    }

    public boolean isSafeLocation(Location loc) {
        return this.isSafeLocation(loc.getBlock());
    }

    public Location tryFindPlaceToStand(Location targetLoc) {
        return this.tryFindPlaceToStand(targetLoc, 4, 253);
    }

    public Location tryFindPlaceToStand(Location targetLoc, int minY, int maxY) {
        Location location = this.findPlaceToStand(targetLoc, minY, maxY);
        return location == null ? targetLoc : location;
    }

    public Location findPlaceToStand(Location targetLoc, int minY, int maxY) {
        if (!targetLoc.getBlock().getChunk().isLoaded()) {
            return null;
        }
        int targetY = targetLoc.getBlockY();
        if (targetY >= minY && targetY <= maxY && this.isSafeLocation(targetLoc)) {
            return targetLoc;
        }
        Location location = null;
        if (targetY < minY) {
            location = targetLoc.clone();
            location.setY((double)minY);
            location = this.findPlaceToStand(location, true, minY, maxY);
        } else if (targetY > maxY) {
            location = targetLoc.clone();
            location.setY((double)maxY);
            location = this.findPlaceToStand(location, false, minY, maxY);
        } else {
            int y = targetLoc.getBlockY();
            int testMinY = Math.max(minY, y - 4);
            location = this.findPlaceToStand(targetLoc, false, testMinY, maxY);
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, true, minY, maxY);
            }
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, false, minY, maxY);
            }
        }
        return location;
    }

    public Location findPlaceToStand(Location target, boolean goUp) {
        return this.findPlaceToStand(target, goUp, 4, 253);
    }

    public Location findPlaceToStand(Location target, boolean goUp, int minY, int maxY) {
        int direction = goUp ? 1 : -1;
        Location targetLocation = target.clone();
        while ((double)minY <= targetLocation.getY() && targetLocation.getY() <= (double)maxY) {
            Block block = targetLocation.getBlock();
            if (!(!this.isSafeLocation(block) || goUp && this.isUnderwater() && this.isWater(block.getType()))) {
                return targetLocation;
            }
            if (!this.allowPassThrough(block.getType())) {
                return null;
            }
            targetLocation.setY(targetLocation.getY() + (double)direction);
        }
        return null;
    }

    public Block getPlayerBlock() {
        return this.getLocation().getBlock().getRelative(BlockFace.DOWN);
    }

    public BlockFace getPlayerFacing() {
        float playerRot;
        for (playerRot = this.getLocation().getYaw(); playerRot < 0.0f; playerRot += 360.0f) {
        }
        while (playerRot > 360.0f) {
            playerRot -= 360.0f;
        }
        BlockFace direction = BlockFace.NORTH;
        if (playerRot <= 45.0f || playerRot > 315.0f) {
            direction = BlockFace.SOUTH;
        } else if (playerRot > 45.0f && playerRot <= 135.0f) {
            direction = BlockFace.WEST;
        } else if (playerRot > 135.0f && playerRot <= 225.0f) {
            direction = BlockFace.NORTH;
        } else if (playerRot > 225.0f && playerRot <= 315.0f) {
            direction = BlockFace.EAST;
        }
        return direction;
    }

    @Override
    public void castMessage(String message) {
        if (this.canSendMessage() && message != null && message.length() > 0) {
            this.mage.castMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    @Override
    public void sendMessage(String message) {
        if (this.canSendMessage() && message != null && message.length() > 0) {
            this.mage.sendMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    @Override
    public Location getLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        if (this.mage != null) {
            return this.mage.getLocation();
        }
        return null;
    }

    public Location getEyeLocation() {
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        location.setY(location.getY() + 1.5);
        return location;
    }

    @Override
    public Vector getDirection() {
        if (this.location == null) {
            return this.mage.getDirection();
        }
        return this.location.getDirection();
    }

    public boolean isLookingUp() {
        Vector direction = this.getDirection();
        if (direction == null) {
            return false;
        }
        return direction.getY() > 0.8;
    }

    public boolean isLookingDown() {
        Vector direction = this.getDirection();
        if (direction == null) {
            return false;
        }
        return direction.getY() < -0.8;
    }

    public World getWorld() {
        Location location = this.getLocation();
        if (location != null) {
            return location.getWorld();
        }
        return null;
    }

    public boolean isUnderwater() {
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            return false;
        }
        return (playerBlock = playerBlock.getRelative(BlockFace.UP)).getType() == Material.WATER || playerBlock.getType() == Material.STATIONARY_WATER;
    }

    protected String getBlockSkin(Material blockType) {
        String skinName = null;
        switch (blockType) {
            case CACTUS: {
                skinName = "MHF_Cactus";
                break;
            }
            case CHEST: {
                skinName = "MHF_Chest";
                break;
            }
            case MELON_BLOCK: {
                skinName = "MHF_Melon";
                break;
            }
            case TNT: {
                if (Math.random() > 0.5) {
                    skinName = "MHF_TNT";
                    break;
                }
                skinName = "MHF_TNT2";
                break;
            }
            case LOG: {
                skinName = "MHF_OakLog";
                break;
            }
            case PUMPKIN: {
                skinName = "MHF_Pumpkin";
                break;
            }
        }
        return skinName;
    }

    protected String getMobSkin(EntityType mobType) {
        String mobSkin = null;
        switch (mobType) {
            case BLAZE: {
                mobSkin = "MHF_Blaze";
                break;
            }
            case CAVE_SPIDER: {
                mobSkin = "MHF_CaveSpider";
                break;
            }
            case CHICKEN: {
                mobSkin = "MHF_Chicken";
                break;
            }
            case COW: {
                mobSkin = "MHF_Cow";
                break;
            }
            case ENDERMAN: {
                mobSkin = "MHF_Enderman";
                break;
            }
            case GHAST: {
                mobSkin = "MHF_Ghast";
                break;
            }
            case IRON_GOLEM: {
                mobSkin = "MHF_Golem";
                break;
            }
            case MAGMA_CUBE: {
                mobSkin = "MHF_LavaSlime";
                break;
            }
            case MUSHROOM_COW: {
                mobSkin = "MHF_MushroomCow";
                break;
            }
            case OCELOT: {
                mobSkin = "MHF_Ocelot";
                break;
            }
            case PIG: {
                mobSkin = "MHF_Pig";
                break;
            }
            case PIG_ZOMBIE: {
                mobSkin = "MHF_PigZombie";
                break;
            }
            case SHEEP: {
                mobSkin = "MHF_Sheep";
                break;
            }
            case SLIME: {
                mobSkin = "MHF_Slime";
                break;
            }
            case SPIDER: {
                mobSkin = "MHF_Spider";
                break;
            }
            case SQUID: {
                mobSkin = "MHF_Squid";
                break;
            }
            case VILLAGER: {
                mobSkin = "MHF_Villager";
            }
        }
        return mobSkin;
    }

    protected static Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters) {
        PotionEffectType[] effectTypes;
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (PotionEffectType effectType : effectTypes = PotionEffectType.values()) {
            String parameterName;
            if (effectType == null || !parameters.contains(parameterName = "effect_" + effectType.getName().toLowerCase())) continue;
            String value = parameters.getString(parameterName);
            String[] pieces = value.split(",");
            try {
                Integer ticks = Integer.parseInt(pieces[0]);
                Integer power = 1;
                if (pieces.length > 0) {
                    power = Integer.parseInt(pieces[1]);
                }
                PotionEffect effect = new PotionEffect(effectType, ticks.intValue(), power.intValue(), true);
                effects.add(effect);
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Error parsing potion effect for " + effectType + ": " + value);
            }
        }
        return effects;
    }

    public boolean isInCircle(int x, int z, int R) {
        return x * x + z * z - R * R <= 0;
    }

    private boolean canSendMessage() {
        if (this.lastMessageSent == 0L) {
            return true;
        }
        int throttle = this.controller.getMessageThrottle();
        long now = System.currentTimeMillis();
        return this.lastMessageSent < now - (long)throttle;
    }

    @Override
    protected Location getEffectLocation() {
        return this.getEyeLocation();
    }

    @Override
    protected void processParameters(ConfigurationSection parameters) {
        super.processParameters(parameters);
        this.preventPassThroughMaterials = parameters.contains("prevent_passthrough") ? this.controller.getMaterialSet(parameters.getString("prevent_passthrough")) : (parameters.contains("indestructible") ? this.controller.getMaterialSet(parameters.getString("indestructible")) : this.controller.getMaterialSet("indestructible"));
    }
}

