/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.wand;

import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.spell.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.spell.Spell;
import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class WandLevel {
    private static TreeMap<Integer, WandLevel> levelMap = null;
    private static int[] levels = null;
    private final LinkedList<WeightedPair<Integer>> spellCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> materialCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<String>> spellProbability = new LinkedList();
    private final LinkedList<WeightedPair<String>> materialProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> useProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> addUseProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> propertyCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> costReductionProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> powerProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionPhysicalProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionProjectilesProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionFallingProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionFireProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionExplosionsProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> xpRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> xpMaxProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> healthRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> hungerRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> hasteProbability = new LinkedList();
    public static final int maxUses = 500;
    public static final int maxMaxXp = 1000;
    public static final int maxXpRegeneration = 50;
    public static final int maxRegeneration = 5;
    public static final float maxDamageReduction = 0.2f;
    public static final float maxCostReduction = 0.5f;
    public static final float maxReduction = 0.9f;
    public static final float maxProtection = 0.9f;
    public static float maxFlySpeedIncrease = 0.1f;
    public static float maxWalkSpeedIncrease = 0.4f;
    public static float maxFlySpeed = 0.8f;
    public static float maxWalkSpeed = 0.8f;
    public static float maxPower = 1.0f;
    public static int minLevel = 10;
    public static int maxLevel = 40;

    public static WandLevel getLevel(int level) {
        if (levelMap == null) {
            return null;
        }
        if (!levelMap.containsKey(level)) {
            if (level > levelMap.lastKey()) {
                return levelMap.lastEntry().getValue();
            }
            return levelMap.firstEntry().getValue();
        }
        return levelMap.get(level);
    }

    public static void mapLevels(ConfigurationSection template) {
        levelMap = new TreeMap();
        String[] levelStrings = StringUtils.split((String)template.getString("levels"), (String)",");
        levels = new int[levelStrings.length];
        for (int i = 0; i < levels.length; ++i) {
            WandLevel.levels[i] = Integer.parseInt(levelStrings[i]);
        }
        for (int level = 1; level <= levels[levels.length - 1]; ++level) {
            levelMap.put(level, new WandLevel(level, template));
        }
    }

    private WandLevel(int level, ConfigurationSection template) {
        int levelIndex = 0;
        int nextLevelIndex = 0;
        float distance = 1.0f;
        for (levelIndex = 0; levelIndex < levels.length; ++levelIndex) {
            if (level == levels[levelIndex] || levelIndex == levels.length - 1) {
                nextLevelIndex = levelIndex;
                distance = 0.0f;
                break;
            }
            if (level <= levels[levelIndex]) continue;
            nextLevelIndex = levelIndex + 1;
            int previousLevel = levels[levelIndex];
            int nextLevel = levels[nextLevelIndex];
            distance = (float)(level - previousLevel) / (float)(nextLevel - previousLevel);
        }
        RandomUtils.populateStringProbabilityMap(this.spellProbability, template.getConfigurationSection("spells"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.spellCountProbability, template.getConfigurationSection("spell_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateStringProbabilityMap(this.materialProbability, template.getConfigurationSection("materials"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.materialCountProbability, template.getConfigurationSection("material_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.useProbability, template.getConfigurationSection("uses"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.addUseProbability, template.getConfigurationSection("add_uses"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.propertyCountProbability, template.getConfigurationSection("property_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.costReductionProbability, template.getConfigurationSection("cost_reduction"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProbability, template.getConfigurationSection("protection"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionPhysicalProbability, template.getConfigurationSection("protection_physical"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFallingProbability, template.getConfigurationSection("protection_falling"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProjectilesProbability, template.getConfigurationSection("protection_projectiles"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFireProbability, template.getConfigurationSection("protection_fire"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionExplosionsProbability, template.getConfigurationSection("protection_explosions"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.xpRegenerationProbability, template.getConfigurationSection("xp_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.xpMaxProbability, template.getConfigurationSection("xp_max"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.healthRegenerationProbability, template.getConfigurationSection("health_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.hungerRegenerationProbability, template.getConfigurationSection("hunger_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.hasteProbability, template.getConfigurationSection("haste"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.powerProbability, template.getConfigurationSection("power"), levelIndex, nextLevelIndex, distance);
    }

    /*
     * WARNING - void declaration
     */
    private boolean randomizeWand(Wand wand, boolean additive) {
        boolean bl;
        boolean addedSpells = false;
        Collection wandSpells = wand.getSpells();
        LinkedList remainingSpells = new LinkedList();
        for (WeightedPair weightedPair : this.spellProbability) {
            if (wandSpells.contains(weightedPair.getValue())) continue;
            remainingSpells.add(weightedPair);
        }
        Spell firstSpell = null;
        if (remainingSpells.size() > 0) {
            Integer n = (Integer)RandomUtils.weightedRandom(this.spellCountProbability);
            int retries = 10;
            for (int i = 0; i < n; ++i) {
                String spellKey = (String)RandomUtils.weightedRandom(remainingSpells);
                if (wand.addSpell(spellKey)) {
                    if (firstSpell == null) {
                        firstSpell = wand.getMaster().getSpell(spellKey);
                    }
                    addedSpells = true;
                    continue;
                }
                if (retries-- <= 0) continue;
                --i;
            }
        }
        boolean bl2 = false;
        int maxXpCost = 0;
        Collection spells = wand.getSpells();
        for (String spellName : spells) {
            Spell spell = wand.getMaster().getSpell(spellName);
            if (spell == null) continue;
            boolean bl3 = bl = bl || spell instanceof BrushSpell && !((BrushSpell)spell).hasBrushOverride();
            Collection<CastingCost> costs = spell.getCosts();
            if (costs == null) continue;
            for (CastingCost cost : costs) {
                maxXpCost = Math.max(maxXpCost, cost.getXP());
            }
        }
        boolean addedMaterials = false;
        Collection wandMaterials = wand.getBrushes();
        LinkedList remainingMaterials = new LinkedList();
        for (WeightedPair weightedPair : this.materialProbability) {
            String materialKey = (String)weightedPair.getValue();
            materialKey = materialKey.replace("|", ":");
            if (wandMaterials.contains(weightedPair.getValue()) || !MaterialBrush.isValidMaterial(materialKey, false)) continue;
            remainingMaterials.add(weightedPair);
        }
        if (bl && remainingMaterials.size() > 0) {
            void var14_27;
            int currentMaterialCount = wand.getBrushes().size();
            Integer n = (Integer)RandomUtils.weightedRandom(this.materialCountProbability);
            if (currentMaterialCount == 0) {
                Integer n2 = Math.max(1, n);
            }
            int retries = 100;
            for (int i = 0; i < var14_27.intValue(); ++i) {
                String materialKey = (String)RandomUtils.weightedRandom(remainingMaterials);
                if (!wand.addBrush(materialKey = materialKey.replace("|", ":"))) {
                    if (retries-- <= 0) continue;
                    --i;
                    continue;
                }
                addedMaterials = true;
            }
        }
        Integer propertyCount = (Integer)RandomUtils.weightedRandom(this.propertyCountProbability);
        MemoryConfiguration memoryConfiguration = new MemoryConfiguration();
        double costReduction = wand.getCostReduction();
        while (true) {
            Integer materialKey = propertyCount;
            Integer n = propertyCount = Integer.valueOf(propertyCount - 1);
            if (materialKey <= 0) break;
            int randomProperty = (int)(Math.random() * 10.0);
            switch (randomProperty) {
                case 0: {
                    if (!(costReduction < (double)0.9f)) break;
                    costReduction = Math.min((double)0.9f, costReduction + (double)((Float)RandomUtils.weightedRandom(this.costReductionProbability)).floatValue());
                    memoryConfiguration.set("cost_reduction", (Object)costReduction);
                    break;
                }
                case 1: {
                    float power = wand.getPower();
                    if (!(power < maxPower)) break;
                    memoryConfiguration.set("power", (Object)Math.min(maxPower, power + ((Float)RandomUtils.weightedRandom(this.powerProbability)).floatValue()));
                    break;
                }
                case 2: {
                    float damageReduction = wand.getDamageReduction();
                    if (!(damageReduction < 0.9f)) break;
                    memoryConfiguration.set("protection", (Object)Math.min(0.9f, damageReduction + ((Float)RandomUtils.weightedRandom(this.damageReductionProbability)).floatValue()));
                    break;
                }
                case 3: {
                    float damageReductionPhysical = wand.getDamageReductionPhysical();
                    if (!(damageReductionPhysical < 0.9f)) break;
                    memoryConfiguration.set("protection_physical", (Object)Math.min(0.9f, damageReductionPhysical + ((Float)RandomUtils.weightedRandom(this.damageReductionPhysicalProbability)).floatValue()));
                    break;
                }
                case 4: {
                    float damageReductionProjectiles = wand.getDamageReductionProjectiles();
                    if (!(damageReductionProjectiles < 0.9f)) break;
                    memoryConfiguration.set("protection_projectiles", (Object)Math.min(0.9f, damageReductionProjectiles + ((Float)RandomUtils.weightedRandom(this.damageReductionProjectilesProbability)).floatValue()));
                    break;
                }
                case 5: {
                    float damageReductionFalling = wand.getDamageReductionFalling();
                    if (!(damageReductionFalling < 0.9f)) break;
                    memoryConfiguration.set("protection_falling", (Object)Math.min(0.9f, damageReductionFalling + ((Float)RandomUtils.weightedRandom(this.damageReductionFallingProbability)).floatValue()));
                    break;
                }
                case 6: {
                    float damageReductionFire = wand.getDamageReductionFire();
                    if (!(damageReductionFire < 0.9f)) break;
                    memoryConfiguration.set("protection_fire", (Object)Math.min(0.9f, damageReductionFire + ((Float)RandomUtils.weightedRandom(this.damageReductionFireProbability)).floatValue()));
                    break;
                }
                case 7: {
                    float damageReductionExplosions = wand.getDamageReductionExplosions();
                    if (!(damageReductionExplosions < 0.9f)) break;
                    memoryConfiguration.set("protection_explosions", (Object)Math.min(0.9f, damageReductionExplosions + ((Float)RandomUtils.weightedRandom(this.damageReductionExplosionsProbability)).floatValue()));
                    break;
                }
                case 10: {
                    int healthRegeneration = wand.getHealthRegeneration();
                    if (healthRegeneration >= 5) break;
                    memoryConfiguration.set("health_regeneration", (Object)Math.min(5, healthRegeneration + (Integer)RandomUtils.weightedRandom(this.healthRegenerationProbability)));
                    break;
                }
                case 11: {
                    int hungerRegeneration = wand.getHungerRegeneration();
                    if (hungerRegeneration >= 5) break;
                    memoryConfiguration.set("hunger_regeneration", (Object)Math.min(5, hungerRegeneration + (Integer)RandomUtils.weightedRandom(this.hungerRegenerationProbability)));
                }
            }
        }
        if (costReduction >= 1.0) {
            memoryConfiguration.set("xp_regeneration", (Object)0);
            memoryConfiguration.set("xp_max", (Object)0);
            memoryConfiguration.set("xp", (Object)0);
        } else {
            int xpMax;
            int xpRegeneration = wand.getXpRegeneration();
            if (xpRegeneration < 50) {
                memoryConfiguration.set("xp_regeneration", (Object)Math.min(50, xpRegeneration + (Integer)RandomUtils.weightedRandom(this.xpRegenerationProbability)));
            }
            if ((xpMax = wand.getXpMax()) < 1000) {
                xpMax = Math.min(1000, xpMax + (Integer)RandomUtils.weightedRandom(this.xpMaxProbability));
                xpMax = Math.max(maxXpCost, xpMax);
                memoryConfiguration.set("xp_max", (Object)xpMax);
            }
            memoryConfiguration.set("xp", (Object)xpMax);
        }
        if (additive) {
            int wandUses = wand.getUses();
            if (wandUses > 0 && wandUses < 500) {
                memoryConfiguration.set("uses", (Object)Math.min(500, wandUses + (Integer)RandomUtils.weightedRandom(this.addUseProbability)));
            }
        } else {
            memoryConfiguration.set("uses", (Object)Math.min(500, (Integer)RandomUtils.weightedRandom(this.useProbability)));
            String spellName = "Nothing";
            if (firstSpell != null) {
                spellName = firstSpell.getName();
            }
            String updatedName = wand.getName();
            wand.setName(updatedName.replace("{Spell}", spellName));
        }
        wand.loadProperties((ConfigurationSection)memoryConfiguration);
        return addedMaterials || addedSpells;
    }

    public static boolean randomizeWand(Wand wand, boolean additive, int level) {
        WandLevel wandLevel = WandLevel.getLevel(level);
        return wandLevel.randomizeWand(wand, additive);
    }

    public static Set<Integer> getLevels() {
        if (levels == null) {
            return null;
        }
        HashSet<Integer> filteredLevels = new HashSet<Integer>();
        int[] arr$ = levels;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer level = arr$[i$];
            if (level < minLevel || level > maxLevel) continue;
            filteredLevels.add(level);
        }
        return filteredLevels;
    }

    public static int getMaxLevel() {
        if (levels == null) {
            return 0;
        }
        return Math.min(levels[levels.length - 1], maxLevel);
    }
}

