/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utilities.Target;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class UndoSpell
extends TargetingSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        Player player = this.getPlayer();
        if (target.hasEntity() && target.getEntity() instanceof Player) {
            if (player != null && target.getEntity() != player && !this.mage.isSuperPowered()) {
                return SpellResult.NO_TARGET;
            }
            Mage mage = this.controller.getMage((Player)target.getEntity());
            return mage.undo() ? SpellResult.CAST : SpellResult.FAIL;
        }
        if (target.isValid()) {
            boolean targetAll = this.mage.isSuperPowered();
            boolean undone = false;
            if (targetAll) {
                Mage targetMage = this.controller.undoAny(target.getBlock());
                if (targetMage != null) {
                    undone = true;
                    this.setTargetName(targetMage.getName());
                }
            } else {
                undone = this.mage.undo(target.getBlock());
            }
            if (undone) {
                return SpellResult.CAST;
            }
        }
        return SpellResult.NO_TARGET;
    }
}

