/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.spell.BlockSpell;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.Target;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShrinkSpell
extends BlockSpell {
    private int DEFAULT_PLAYER_DAMAGE = 1;
    private int DEFAULT_ENTITY_DAMAGE = 100;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        String castType = parameters.getString("type");
        if (castType != null && castType.equalsIgnoreCase("self")) {
            this.dropHead(this.getLocation(), this.getPlayer().getName(), null, (byte)3);
            return SpellResult.CAST;
        }
        String giveName = parameters.getString("name");
        if (giveName != null) {
            this.dropHead(this.getLocation(), giveName, null, (byte)3);
            return SpellResult.CAST;
        }
        Target target = this.getTarget();
        if (target.hasEntity()) {
            if (!(target.getEntity() instanceof LivingEntity)) {
                return SpellResult.NO_TARGET;
            }
            int playerDamage = parameters.getInt("player_damage", this.DEFAULT_PLAYER_DAMAGE);
            int entityDamage = parameters.getInt("entity_damage", this.DEFAULT_ENTITY_DAMAGE);
            Entity targetEntity = target.getEntity();
            LivingEntity li = (LivingEntity)targetEntity;
            boolean alreadyDead = li.isDead() || li.getHealth() <= 0.0;
            String ownerName = null;
            String itemName = null;
            byte data = 3;
            if (li instanceof Player) {
                li.damage((double)(this.mage.getDamageMultiplier() * (float)playerDamage), (Entity)this.getPlayer());
                ownerName = ((Player)li).getName();
            } else {
                li.damage((double)(this.mage.getDamageMultiplier() * (float)entityDamage));
                switch (li.getType()) {
                    case CREEPER: {
                        data = 4;
                        ownerName = null;
                        break;
                    }
                    case ZOMBIE: {
                        data = 2;
                        ownerName = null;
                        break;
                    }
                    case SKELETON: {
                        Skeleton skeleton = (Skeleton)li;
                        data = (byte)(skeleton.getSkeletonType() != Skeleton.SkeletonType.NORMAL ? 1 : 0);
                        ownerName = null;
                        break;
                    }
                    default: {
                        ownerName = this.getMobSkin(li.getType());
                        if (ownerName == null) break;
                        itemName = li.getType().getName() + " Head";
                    }
                }
            }
            if ((ownerName != null || data != 3) && li.isDead() && !alreadyDead) {
                Location targetLocation = targetEntity.getLocation();
                if (li instanceof Ageable && ((Ageable)li).isAdult() && !(li instanceof Player)) {
                    LivingEntity baby = targetLocation.getWorld().spawnCreature(targetLocation, targetEntity.getType());
                    if (baby instanceof Ageable) {
                        ((Ageable)baby).setBaby();
                    }
                } else {
                    this.dropHead(targetEntity.getLocation(), ownerName, itemName, data);
                }
            }
        } else {
            Block targetBlock = target.getBlock();
            if (targetBlock == null) {
                return SpellResult.NO_TARGET;
            }
            String blockSkin = this.getBlockSkin(targetBlock.getType());
            if (blockSkin == null) {
                return SpellResult.NO_TARGET;
            }
            if (!this.hasBuildPermission(targetBlock)) {
                return SpellResult.INSUFFICIENT_PERMISSION;
            }
            if (this.mage.isIndestructible(targetBlock)) {
                return SpellResult.NO_TARGET;
            }
            BlockList shrunk = new BlockList();
            shrunk.add(targetBlock);
            this.dropHead(targetBlock.getLocation(), blockSkin, targetBlock.getType().name(), (byte)3);
            targetBlock.setType(Material.AIR);
            this.registerForUndo(shrunk);
        }
        return SpellResult.CAST;
    }

    protected void dropHead(Location location, String ownerName, String itemName, byte data) {
        ItemStack shrunkenHead = new ItemStack(Material.SKULL_ITEM, 1, 0, Byte.valueOf(data));
        if (ownerName != null) {
            shrunkenHead = InventoryUtils.getCopy(shrunkenHead);
            ItemMeta itemMeta = shrunkenHead.getItemMeta();
            if (itemName != null) {
                itemMeta.setDisplayName(itemName);
            }
            shrunkenHead.setItemMeta(itemMeta);
            InventoryUtils.setMeta(shrunkenHead, "SkullOwner", ownerName);
        }
        location.getWorld().dropItemNaturally(location, shrunkenHead);
    }
}

