/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.spell.BlockSpell;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.util.Vector;

public class GrenadeSpell
extends BlockSpell {
    int defaultSize = 6;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        int size = parameters.getInt("size", this.defaultSize);
        int count = parameters.getInt("count", 1);
        size = (int)(this.mage.getRadiusMultiplier() * (float)size);
        int fuse = parameters.getInt("fuse", 80);
        boolean useFire = parameters.getBoolean("fire", false);
        Block target = this.getTarget().getBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Location loc = this.getEyeLocation();
        Random rand = new Random();
        for (int i = 0; i < count; ++i) {
            TNTPrimed grenade;
            Location targetLoc = loc.clone();
            if (count > 1) {
                targetLoc.setX(targetLoc.getX() + (double)rand.nextInt(2 * count) - (double)count);
                targetLoc.setZ(targetLoc.getZ() + (double)rand.nextInt(2 * count) - (double)count);
            }
            if ((grenade = (TNTPrimed)this.getWorld().spawnEntity(targetLoc, EntityType.PRIMED_TNT)) == null) {
                return SpellResult.FAIL;
            }
            Vector aim = this.getDirection();
            grenade.setVelocity(aim);
            grenade.setYield((float)size);
            grenade.setFuseTicks(fuse);
            grenade.setIsIncendiary(useFire);
        }
        return SpellResult.CAST;
    }
}

