/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.SimpleBlockAction;
import com.elmakers.mine.bukkit.plugins.magic.spell.BlockSpell;
import com.elmakers.mine.bukkit.utilities.ConfigurationUtils;
import com.elmakers.mine.bukkit.utilities.Target;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FrostSpell
extends BlockSpell {
    private static final int DEFAULT_RADIUS = 2;
    private static final int DEFAULT_TIME_TO_LIVE = 0;
    private static final int DEFAULT_PLAYER_DAMAGE = 1;
    private static final int DEFALT_ENTITY_DAMAGE = 10;
    private static final int DEFAULT_SLOWNESS = 1;
    private static final int DEFAULT_SLOWNESS_DURATION = 200;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Entity targetEntity;
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            return SpellResult.NO_TARGET;
        }
        int playerDamage = parameters.getInt("player_damage", 1);
        int entityDamage = parameters.getInt("entity_damage", 10);
        int defaultRadius = parameters.getInt("radius", 2);
        int timeToLive = parameters.getInt("undo", 0);
        int slowness = parameters.getInt("slowness", 1);
        int slownessDuration = parameters.getInt("slowness_duration", 200);
        Material iceMaterial = ConfigurationUtils.getMaterial(parameters, "ice", Material.ICE);
        if (target.hasEntity() && (targetEntity = target.getEntity()) instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)targetEntity;
            if (slowness > 0) {
                PotionEffect effect = new PotionEffect(PotionEffectType.SLOW, slownessDuration, slowness, false);
                li.addPotionEffect(effect);
            }
            if (li instanceof Player) {
                li.damage((double)playerDamage, (Entity)this.getPlayer());
            } else {
                li.damage((double)entityDamage, (Entity)this.getPlayer());
            }
        }
        if (!this.hasBuildPermission(target.getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", defaultRadius);
        radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        FrostAction action = new FrostAction(iceMaterial);
        if (radius <= 1) {
            action.perform(target.getBlock());
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        BlockList frozenBlocks = action.getBlocks();
        frozenBlocks.setTimeToLive(timeToLive);
        this.registerForUndo(frozenBlocks);
        this.controller.updateBlock(target.getBlock());
        return SpellResult.CAST;
    }

    public int checkPosition(int x, int z, int R) {
        return x * x + z * z - R * R;
    }

    public class FrostAction
    extends SimpleBlockAction {
        private Material iceMaterial;

        public FrostAction(Material iceMaterial) {
            this.iceMaterial = iceMaterial;
        }

        @Override
        public SpellResult perform(Block block) {
            if (FrostSpell.this.isTransparent(block.getType())) {
                return SpellResult.NO_TARGET;
            }
            Material material = Material.SNOW;
            if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER) {
                material = this.iceMaterial;
            } else if (block.getType() == Material.LAVA) {
                material = Material.COBBLESTONE;
            } else if (block.getType() == Material.STATIONARY_LAVA) {
                material = Material.OBSIDIAN;
            } else if (block.getType() == Material.FIRE) {
                material = Material.AIR;
            } else if (block.getType() == Material.SNOW) {
                material = Material.SNOW;
            } else {
                block = block.getRelative(BlockFace.UP);
            }
            super.perform(block);
            if (block.getType() == Material.SNOW && material == Material.SNOW) {
                if (block.getData() < 7) {
                    block.setData((byte)(block.getData() + 1));
                }
            } else {
                block.setType(material);
            }
            return SpellResult.CAST;
        }
    }
}

