/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.effects.EffectUtils;
import com.elmakers.mine.bukkit.plugins.magic.spell.TargetingSpell;
import java.lang.reflect.Field;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class FireworkSpell
extends TargetingSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Random rand = new Random();
        int power = rand.nextInt(2) + 1;
        Color color1 = null;
        Color color2 = null;
        FireworkEffect.Type fireworkType = null;
        Boolean flicker = null;
        Boolean trail = null;
        power = parameters.getInt("size", power);
        if (parameters.contains("color1")) {
            color1 = this.getColor(parameters.getString("color1"));
        } else if (this.mage.getEffectColor() != null) {
            color1 = this.mage.getEffectColor();
        }
        if (parameters.contains("color2")) {
            color2 = this.getColor(parameters.getString("color2"));
        }
        if (parameters.contains("type")) {
            fireworkType = this.getType(parameters.getString("type"));
        }
        flicker = parameters.getBoolean("flicker");
        trail = parameters.getBoolean("trail");
        int flareCount = parameters.getInt("count", 1);
        Block target = this.getTarget().getBlock();
        FireworkEffect effect = this.mage.getFireworkEffect(color1, color2, fireworkType, flicker, trail);
        for (int i = 0; i < flareCount; ++i) {
            EffectUtils.spawnFireworkEffect(target.getLocation(), effect, power);
        }
        return SpellResult.CAST;
    }

    protected Color getColor(String name) {
        try {
            Field colorConstant = Color.class.getField(name.toUpperCase());
            return (Color)colorConstant.get(null);
        }
        catch (Exception exception) {
            return Color.WHITE;
        }
    }

    protected FireworkEffect.Type getType(String name) {
        for (FireworkEffect.Type t : FireworkEffect.Type.values()) {
            if (!t.name().equalsIgnoreCase(name)) continue;
            return t;
        }
        return FireworkEffect.Type.BALL;
    }
}

