/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.SimpleBlockAction;
import com.elmakers.mine.bukkit.plugins.magic.spell.BlockSpell;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class FireSpell
extends BlockSpell {
    private static final int DEFAULT_RADIUS = 4;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block target = this.getTargetBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", 4);
        radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        FireAction action = new FireAction();
        if (radius <= 1) {
            action.perform(target);
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        this.registerForUndo(action.getBlocks());
        this.controller.updateBlock(target);
        return SpellResult.CAST;
    }

    public int checkPosition(int x, int z, int R) {
        return x * x + z * z - R * R;
    }

    public class FireAction
    extends SimpleBlockAction {
        @Override
        public SpellResult perform(Block block) {
            if (block.getType() == Material.AIR || block.getType() == Material.FIRE) {
                return SpellResult.NO_TARGET;
            }
            Material material = Material.FIRE;
            if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER || block.getType() == Material.ICE || block.getType() == Material.SNOW) {
                material = Material.AIR;
            } else {
                block = block.getRelative(BlockFace.UP);
            }
            super.perform(block);
            block.setType(material);
            return SpellResult.CAST;
        }
    }
}

