/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.spell.BlockSpell;
import java.util.Collection;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class DropSpell
extends BlockSpell {
    private static final int DEFAULT_MAX_RECURSION = 16;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block target = this.getTargetBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        Set<Material> dropMaterials = this.controller.getMaterialSet(parameters.getString("drop"));
        if (!dropMaterials.contains(target.getType())) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int maxRecursion = parameters.getInt("recursion_depth", 16);
        BlockList droppedBlocks = new BlockList();
        this.drop(target, dropMaterials, droppedBlocks, maxRecursion);
        this.registerForUndo(droppedBlocks);
        return SpellResult.CAST;
    }

    protected void drop(Block block, Set<Material> dropTypes, BlockList minedBlocks, int maxRecursion) {
        this.drop(block, dropTypes, minedBlocks, maxRecursion, 0);
    }

    protected void drop(Block block, Set<Material> dropTypes, BlockList droppedBlocks, int maxRecursion, int rDepth) {
        droppedBlocks.add(block);
        Collection drops = block.getDrops();
        for (ItemStack drop : drops) {
            block.getWorld().dropItemNaturally(block.getLocation(), drop);
        }
        block.setType(Material.AIR);
        if (rDepth < maxRecursion) {
            this.tryDrop(block.getRelative(BlockFace.NORTH), dropTypes, droppedBlocks, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.WEST), dropTypes, droppedBlocks, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.SOUTH), dropTypes, droppedBlocks, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.EAST), dropTypes, droppedBlocks, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.UP), dropTypes, droppedBlocks, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.DOWN), dropTypes, droppedBlocks, maxRecursion, rDepth + 1);
        }
    }

    protected void tryDrop(Block target, Set<Material> dropTypes, BlockList minedBlocks, int maxRecursion, int rDepth) {
        if (!dropTypes.contains(target.getType()) || minedBlocks.contains(target)) {
            return;
        }
        this.drop(target, dropTypes, minedBlocks, maxRecursion, rDepth);
    }
}

