/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.effects.EffectPlayer;
import com.elmakers.mine.bukkit.effects.EffectSingle;
import com.elmakers.mine.bukkit.effects.EffectTrail;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.spell.CastingCost;
import com.elmakers.mine.bukkit.utilities.ConfigurationUtils;
import com.elmakers.mine.bukkit.utilities.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public abstract class Spell
implements Comparable<SpellTemplate>,
Cloneable,
CostReducer,
com.elmakers.mine.bukkit.api.spell.Spell {
    protected static final Material DEFAULT_EFFECT_MATERIAL = Material.STATIONARY_WATER;
    public static final int MAX_Y = 255;
    public static final String[] EXAMPLE_VECTOR_COMPONENTS = new String[]{"-1", "-0.5", "0", "0.5", "1", "~-1", "~-0.5", "~0", "~0.5", "~1"};
    public static final String[] EXAMPLE_SIZES = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "12", "16", "32", "64"};
    public static final String[] EXAMPLE_BOOLEANS = new String[]{"true", "false"};
    public static final String[] EXAMPLE_DURATIONS = new String[]{"500", "1000", "2000", "5000", "10000", "60000", "120000"};
    public static final String[] EXAMPLE_PERCENTAGES = new String[]{"0", "0.1", "0.25", "0.5", "0.75", "1"};
    public static final String[] OTHER_PARAMETERS = new String[]{"transparent", "target", "target_type", "range", "duration", "player"};
    public static final String[] WORLD_PARAMETERS = new String[]{"pworld", "tworld", "otworld", "t2world"};
    protected static final Set<String> worldParameterMap = new HashSet<String>(Arrays.asList(WORLD_PARAMETERS));
    public static final String[] VECTOR_PARAMETERS = new String[]{"px", "py", "pz", "pdx", "pdy", "pdz", "tx", "ty", "tz", "otx", "oty", "otz", "t2x", "t2y", "t2z"};
    protected static final Set<String> vectorParameterMap = new HashSet<String>(Arrays.asList(VECTOR_PARAMETERS));
    public static final String[] BOOLEAN_PARAMETERS = new String[]{"allow_max_range", "prevent_passthrough", "bypass_build", "bypass_pvp", "target_npc"};
    protected static final Set<String> booleanParameterMap = new HashSet<String>(Arrays.asList(BOOLEAN_PARAMETERS));
    public static final String[] PERCENTAGE_PARAMETERS = new String[]{"fizzle_chance", "backfire_chance", "cooldown_reduction"};
    protected static final Set<String> percentageParameterMap = new HashSet<String>(Arrays.asList(PERCENTAGE_PARAMETERS));
    private static final String BUILTIN_CLASSPATH = "com.elmakers.mine.bukkit.plugins.magic.spell.builtin";
    public static final String[] COMMON_PARAMETERS = (String[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])VECTOR_PARAMETERS, (Object[])BOOLEAN_PARAMETERS), (Object[])OTHER_PARAMETERS), (Object[])WORLD_PARAMETERS), (Object[])PERCENTAGE_PARAMETERS);
    protected MagicController controller;
    protected Mage mage;
    protected Location location;
    private String key;
    private String name;
    private String description;
    private String usage;
    private String category;
    private MaterialAndData icon = new MaterialAndData(Material.AIR);
    private List<CastingCost> costs = null;
    private List<CastingCost> activeCosts = null;
    protected ConfigurationSection parameters = null;
    private float cooldownReduction = 0.0f;
    private float costReduction = 0.0f;
    private int cooldown = 0;
    private int duration = 0;
    private long lastCast = 0L;
    private long castCount = 0L;
    private boolean isActive = false;
    private Map<SpellResult, List<EffectPlayer>> effects = new HashMap<SpellResult, List<EffectPlayer>>();
    private float fizzleChance = 0.0f;
    private float backfireChance = 0.0f;

    public static Spell loadSpell(String name, ConfigurationSection node, MagicController controller) {
        Object newObject;
        String className = node.getString("class");
        if (className == null) {
            return null;
        }
        if (className.indexOf(46) <= 0) {
            className = "com.elmakers.mine.bukkit.plugins.magic.spell.builtin." + className;
        }
        Class<?> spellClass = null;
        try {
            spellClass = Class.forName(className);
        }
        catch (Throwable ex) {
            controller.getLogger().warning("Error loading spell: " + className);
            ex.printStackTrace();
            return null;
        }
        try {
            newObject = spellClass.newInstance();
        }
        catch (Throwable ex) {
            controller.getLogger().warning("Error loading spell: " + className);
            ex.printStackTrace();
            return null;
        }
        if (newObject == null || !(newObject instanceof Spell)) {
            controller.getLogger().warning("Error loading spell: " + className + ", does it extend Spell?");
            return null;
        }
        Spell newSpell = (Spell)newObject;
        newSpell.initialize(controller);
        newSpell.loadTemplate(name, node);
        return newSpell;
    }

    public void checkActiveCosts() {
        if (this.activeCosts == null) {
            return;
        }
        for (CastingCost cost : this.activeCosts) {
            if (!cost.has(this)) {
                this.deactivate();
                return;
            }
            cost.use(this);
        }
    }

    public void checkActiveDuration() {
        if (this.duration > 0 && this.lastCast < System.currentTimeMillis() - (long)this.duration) {
            this.deactivate();
        }
    }

    protected void activate() {
        this.onActivate();
        this.mage.activateSpell(this);
        this.isActive = true;
    }

    public void deactivate() {
        this.onDeactivate();
        this.mage.deactivateSpell(this);
        this.isActive = false;
    }

    protected List<CastingCost> parseCosts(ConfigurationSection node) {
        if (node == null) {
            return null;
        }
        ArrayList<CastingCost> castingCosts = new ArrayList<CastingCost>();
        Set costKeys = node.getKeys(false);
        for (String key : costKeys) {
            castingCosts.add(new CastingCost(key, node.getDouble(key, 1.0)));
        }
        return castingCosts;
    }

    public void configure(ConfigurationSection node) {
    }

    public void loadTemplate(String key, ConfigurationSection node) {
        this.key = key;
        this.loadTemplate(node);
    }

    protected void loadTemplate(ConfigurationSection node) {
        this.name = this.key;
        this.name = node.getString("name", this.name);
        this.name = Messages.get("spells." + this.key + ".name", this.name);
        this.description = node.getString("description", "");
        this.description = Messages.get("spells." + this.key + ".description", this.description);
        this.usage = Messages.get("spells." + this.key + ".usage", this.usage);
        this.icon = ConfigurationUtils.getMaterialAndData(node, "icon", this.icon);
        this.category = node.getString("category", this.category);
        this.parameters = node.getConfigurationSection("parameters");
        this.costs = this.parseCosts(node.getConfigurationSection("costs"));
        this.activeCosts = this.parseCosts(node.getConfigurationSection("active_costs"));
        this.effects.clear();
        if (node.contains("effects")) {
            ConfigurationSection effectsNode = node.getConfigurationSection("effects");
            for (SpellResult resultType : SpellResult.values()) {
                Collection<ConfigurationSection> effectNodes;
                String typeName = resultType.name().toLowerCase();
                if (!effectsNode.contains(typeName) || (effectNodes = ConfigurationUtils.getNodeList(effectsNode, typeName)) == null) continue;
                ArrayList<EffectPlayer> players = new ArrayList<EffectPlayer>();
                for (ConfigurationSection effectValues : effectNodes) {
                    if (!effectValues.contains("class")) continue;
                    String effectClass = effectValues.getString("class");
                    try {
                        Class<?> genericClass = Class.forName("com.elmakers.mine.bukkit.effects." + effectClass);
                        if (!EffectPlayer.class.isAssignableFrom(genericClass)) {
                            throw new Exception("Must extend EffectPlayer");
                        }
                        Class<?> playerClass = genericClass;
                        EffectPlayer player = (EffectPlayer)playerClass.newInstance();
                        player.load((Plugin)this.controller.getPlugin(), effectValues);
                        players.add(player);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.controller.getLogger().info("Error creating effect class: " + effectClass + " " + ex.getMessage());
                    }
                }
                this.effects.put(resultType, players);
            }
        }
        this.initializeDefaultSound(SpellResult.FAIL, Sound.NOTE_BASS_DRUM, 0.9f, 1.2f);
        this.initializeDefaultSound(SpellResult.INSUFFICIENT_RESOURCES, Sound.NOTE_BASS, 1.0f, 1.2f);
        this.initializeDefaultSound(SpellResult.INSUFFICIENT_PERMISSION, Sound.NOTE_BASS, 1.1f, 1.5f);
        this.initializeDefaultSound(SpellResult.COOLDOWN, Sound.NOTE_SNARE_DRUM, 1.1f, 0.9f);
        this.initializeDefaultSound(SpellResult.NO_TARGET, Sound.NOTE_STICKS, 1.1f, 0.9f);
        if (!this.effects.containsKey((Object)SpellResult.TARGET_SELECTED)) {
            ArrayList<EffectPlayer> effectList = new ArrayList<EffectPlayer>();
            EffectSingle targetHighlight = new EffectSingle((Plugin)this.controller.getPlugin());
            targetHighlight.setSound(Sound.ANVIL_USE);
            targetHighlight.setParticleType(ParticleType.HAPPY_VILLAGER);
            targetHighlight.setLocationType("target");
            targetHighlight.setOffset(0.5f, 0.5f, 0.5f);
            effectList.add(targetHighlight);
            EffectTrail trail = new EffectTrail((Plugin)this.controller.getPlugin());
            trail.setParticleType(ParticleType.WATER_DRIPPING);
            effectList.add(trail);
            this.effects.put(SpellResult.TARGET_SELECTED, effectList);
        }
        if (!this.effects.containsKey((Object)SpellResult.COST_FREE) && this.effects.containsKey((Object)SpellResult.CAST)) {
            this.effects.put(SpellResult.COST_FREE, this.effects.get((Object)SpellResult.CAST));
        }
    }

    protected void initializeDefaultSound(SpellResult result, Sound sound, float volume, float pitch) {
        if (this.effects.containsKey((Object)result)) {
            return;
        }
        EffectSingle defaultEffect = new EffectSingle((Plugin)this.controller.getPlugin());
        defaultEffect.setSound(sound, volume, pitch);
        ArrayList<EffectSingle> effectList = new ArrayList<EffectSingle>();
        effectList.add(defaultEffect);
        this.effects.put(result, effectList);
    }

    public void setMage(Mage mage) {
        this.mage = mage;
    }

    public boolean isMatch(String spell, String[] params) {
        if (params == null) {
            params = new String[]{};
        }
        return this.key.equalsIgnoreCase(spell) && this.parameters.equals(params);
    }

    @Override
    public int compareTo(SpellTemplate other) {
        return this.name.compareTo(other.getName());
    }

    public static void addParameters(String[] extraParameters, ConfigurationSection parameters) {
        if (extraParameters != null) {
            for (int i = 0; i < extraParameters.length - 1; i += 2) {
                ConfigurationUtils.set(parameters, extraParameters[i], extraParameters[i + 1]);
            }
        }
    }

    protected void preCast() {
    }

    protected void reset() {
        Location mageLocation;
        Location location = mageLocation = this.mage != null ? this.mage.getLocation() : null;
        if (this.location != null && mageLocation != null) {
            this.location.setPitch(mageLocation.getPitch());
            this.location.setYaw(mageLocation.getYaw());
        }
    }

    public boolean cast(String[] extraParameters, Location defaultLocation) {
        this.location = defaultLocation;
        this.reset();
        if (this.parameters == null) {
            this.parameters = new MemoryConfiguration();
        }
        MemoryConfiguration parameters = new MemoryConfiguration();
        ConfigurationUtils.addConfigurations((ConfigurationSection)parameters, this.parameters);
        Spell.addParameters(extraParameters, (ConfigurationSection)parameters);
        this.processParameters((ConfigurationSection)parameters);
        this.preCast();
        this.cooldown = parameters.getInt("cooldown", this.cooldown);
        this.cooldown = parameters.getInt("cool", this.cooldown);
        long currentTime = System.currentTimeMillis();
        double cooldownReduction = this.mage.getCooldownReduction() + this.cooldownReduction;
        if (cooldownReduction < 1.0 && !this.isActive && this.cooldown > 0) {
            int reducedCooldown = (int)Math.ceil((1.0 - cooldownReduction) * (double)this.cooldown);
            if (this.lastCast != 0L && this.lastCast > currentTime - (long)reducedCooldown) {
                long seconds = (this.lastCast - (currentTime - (long)reducedCooldown)) / 1000L;
                if (seconds > 3600L) {
                    long hours = seconds / 3600L;
                    this.sendMessage(Messages.get("cooldown.wait_hours").replace("$hours", Long.valueOf(hours).toString()));
                } else if (seconds > 60L) {
                    long minutes = seconds / 60L;
                    this.sendMessage(Messages.get("cooldown.wait_minutes").replace("$minutes", Long.valueOf(minutes).toString()));
                } else if (seconds > 1L) {
                    this.sendMessage(Messages.get("cooldown.wait_seconds").replace("$seconds", Long.valueOf(seconds).toString()));
                } else {
                    this.sendMessage(Messages.get("cooldown.wait_moment"));
                }
                this.processResult(SpellResult.COOLDOWN);
                return false;
            }
        }
        if (this.costs != null && !this.isActive) {
            for (CastingCost cost : this.costs) {
                if (cost.has(this)) continue;
                String baseMessage = Messages.get("costs.insufficient_resources");
                String costDescription = cost.getDescription(this.mage);
                this.sendMessage(baseMessage.replace("$cost", costDescription));
                this.processResult(SpellResult.INSUFFICIENT_RESOURCES);
                return false;
            }
        }
        if (!this.canCast()) {
            this.processResult(SpellResult.INSUFFICIENT_PERMISSION);
            return false;
        }
        return this.finalizeCast((ConfigurationSection)parameters);
    }

    protected boolean canCast() {
        return true;
    }

    protected void onBackfire() {
    }

    protected boolean finalizeCast(ConfigurationSection parameters) {
        SpellResult result = null;
        if (!this.mage.isSuperPowered()) {
            if (this.backfireChance > 0.0f && Math.random() < (double)this.backfireChance) {
                this.onBackfire();
                this.onCast(parameters);
                result = SpellResult.BACKFIRE;
            } else if (this.fizzleChance > 0.0f && Math.random() < (double)this.fizzleChance) {
                result = SpellResult.FIZZLE;
            }
        }
        if (result == null) {
            result = this.onCast(parameters);
        }
        this.processResult(result);
        if (result.isSuccess()) {
            this.lastCast = System.currentTimeMillis();
            if (this.costs != null) {
                for (CastingCost cost : this.costs) {
                    cost.use(this);
                }
            }
            ++this.castCount;
        }
        return result.isSuccess();
    }

    public String getMessage(String messageKey) {
        return this.getMessage(messageKey, "");
    }

    public String getMessage(String messageKey, String def) {
        String message = Messages.get("spells.default." + messageKey, def);
        message = Messages.get("spells." + this.key + "." + messageKey, message);
        if (message == null) {
            message = "";
        }
        String playerName = this.mage.getName();
        message = message.replace("$player", playerName);
        String materialName = this.getDisplayMaterialName();
        message = message.replace("$material", materialName);
        return message;
    }

    protected String getDisplayMaterialName() {
        return "None";
    }

    protected void processResult(SpellResult result) {
        if (this.mage != null) {
            this.mage.processResult(result);
        }
        if (result.isSuccess()) {
            this.controller.onCast(this.mage, this, result);
        }
        if (result == SpellResult.CAST) {
            String message = this.getMessage(result.name().toLowerCase());
            Player player = this.mage.getPlayer();
            Entity targetEntity = this.getTargetEntity();
            if (targetEntity == player) {
                message = this.getMessage("cast_self", message);
            } else if (targetEntity instanceof Player) {
                message = this.getMessage("cast_player", message);
                String playerMessage = this.getMessage("cast_player_message");
                if (playerMessage.length() > 0) {
                    playerMessage = playerMessage.replace("$spell", this.getName());
                    Player targetPlayer = (Player)targetEntity;
                    Mage targetMage = this.controller.getMage(targetPlayer);
                    targetMage.sendMessage(playerMessage);
                }
            } else if (targetEntity instanceof LivingEntity) {
                message = this.getMessage("cast_livingentity", message);
            } else if (targetEntity instanceof Entity) {
                message = this.getMessage("cast_entity", message);
            }
            this.castMessage(message);
        } else {
            this.sendMessage(this.getMessage(result.name().toLowerCase()));
        }
        Location mageLocation = this.getEffectLocation();
        if (this.effects.containsKey((Object)result) && mageLocation != null) {
            Location targetLocation = this.getTargetLocation();
            List<EffectPlayer> resultEffects = this.effects.get((Object)result);
            for (EffectPlayer player : resultEffects) {
                player.setMaterial(this.getEffectMaterial());
                player.setColor(this.mage.getEffectColor());
                player.start(mageLocation, targetLocation);
            }
        }
    }

    @Override
    public Location getTargetLocation() {
        return null;
    }

    @Override
    public Entity getTargetEntity() {
        return null;
    }

    public MaterialAndData getEffectMaterial() {
        return new MaterialAndData(DEFAULT_EFFECT_MATERIAL);
    }

    protected void processParameters(ConfigurationSection parameters) {
        this.duration = parameters.getInt("duration", this.duration);
        this.fizzleChance = (float)parameters.getDouble("fizzle_chance", (double)this.fizzleChance);
        this.backfireChance = (float)parameters.getDouble("backfire_chance", (double)this.backfireChance);
        Location defaultLocation = this.location == null ? this.mage.getLocation() : this.location;
        Location locationOverride = ConfigurationUtils.getLocationOverride(parameters, "p", defaultLocation);
        if (locationOverride != null) {
            this.location = locationOverride;
        }
        this.costReduction = (float)parameters.getDouble("cost_reduction", 0.0);
        this.cooldownReduction = (float)parameters.getDouble("cooldown_reduction", 0.0);
    }

    public String getPermissionNode() {
        return "Magic.cast." + this.key;
    }

    @Override
    public boolean hasSpellPermission(CommandSender sender) {
        if (sender == null) {
            return true;
        }
        return this.controller.hasPermission(sender, this.getPermissionNode(), true);
    }

    public boolean onCancel() {
        return false;
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
    }

    public void onPlayerDeath(EntityDeathEvent event) {
    }

    public void onPlayerDamage(EntityDamageEvent event) {
    }

    public void initialize(MagicController instance) {
        this.controller = instance;
    }

    public boolean cancel() {
        boolean cancelled = this.onCancel();
        if (cancelled) {
            this.sendMessage(this.getMessage("cancel"));
        }
        return cancelled;
    }

    @Override
    public long getCastCount() {
        return this.castCount;
    }

    public void onActivate() {
    }

    public void onDeactivate() {
    }

    public Mage getMage() {
        return this.mage;
    }

    public void load(ConfigurationSection node) {
        try {
            this.castCount = node.getLong("cast_count", 0L);
            this.lastCast = node.getLong("last_cast", 0L);
            this.onLoad(node);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to load data for spell " + this.name + ": " + ex.getMessage());
        }
    }

    public void save(ConfigurationSection node) {
        try {
            node.set("cast_count", (Object)this.castCount);
            node.set("last_cast", (Object)this.lastCast);
            this.onSave(node);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to save data for spell " + this.name);
            ex.printStackTrace();
        }
    }

    public void onLoad(ConfigurationSection node) {
    }

    public void onSave(ConfigurationSection node) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public float getCostReduction() {
        return this.costReduction + this.mage.getCostReduction();
    }

    @Override
    public boolean usesMana() {
        return this.mage.usesMana();
    }

    @Override
    public boolean cast() {
        return this.cast(new String[0], null);
    }

    @Override
    public boolean cast(String[] extraParameters) {
        return this.cast(extraParameters, null);
    }

    @Override
    public final String getKey() {
        return this.key;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final MaterialAndData getIcon() {
        return this.icon;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final String getUsage() {
        return this.usage;
    }

    @Override
    public final String getCategory() {
        return this.category;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.CastingCost> getCosts() {
        if (this.costs == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> copy = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        copy.addAll(this.costs);
        return copy;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.CastingCost> getActiveCosts() {
        if (this.activeCosts == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> copy = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        copy.addAll(this.activeCosts);
        return copy;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        parameters.addAll(Arrays.asList(COMMON_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("duration")) {
            examples.addAll(Arrays.asList(EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("range")) {
            examples.addAll(Arrays.asList(EXAMPLE_SIZES));
        } else if (parameterKey.equals("transparent")) {
            examples.addAll(this.controller.getMaterialSets());
        } else if (parameterKey.equals("player")) {
            examples.addAll(this.controller.getPlugin().getPlayerNames());
        } else if (parameterKey.equals("target")) {
            TargetType[] targetTypes;
            for (TargetType targetType : targetTypes = TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("target")) {
            TargetType[] targetTypes;
            for (TargetType targetType : targetTypes = TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("target_type")) {
            EntityType[] entityTypes;
            for (EntityType entityType : entityTypes = EntityType.values()) {
                examples.add(entityType.name().toLowerCase());
            }
        } else if (booleanParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        } else if (vectorParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_VECTOR_COMPONENTS));
        } else if (worldParameterMap.contains(parameterKey)) {
            List worlds = Bukkit.getWorlds();
            for (World world : worlds) {
                examples.add(world.getName());
            }
        } else if (percentageParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_PERCENTAGES));
        }
    }

    public abstract SpellResult onCast(ConfigurationSection var1);

    protected abstract Location getEffectLocation();

    public abstract void sendMessage(String var1);

    public abstract void castMessage(String var1);
}

