/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.spell.TargetingSpell;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public abstract class BlockSpell
extends TargetingSpell {
    private boolean bypassBuildRestriction = false;
    private Set<Material> indestructible;
    private Set<Material> destructible;
    private boolean checkDestructible = true;
    private boolean bypassUndo = false;
    private int modifiedBlocks = 0;
    public static final String[] BLOCK_PARAMETERS = new String[]{"indestructible", "destructible", "check_destructible", "bypass_undo"};

    private boolean isIndestructible(Block block) {
        if (this.indestructible == null) {
            return this.mage.isIndestructible(block);
        }
        return this.indestructible.contains(block.getType()) || this.mage.isIndestructible(block);
    }

    public boolean isDestructible(Block block) {
        if (this.isIndestructible(block)) {
            return false;
        }
        if (!this.checkDestructible) {
            return true;
        }
        if (this.destructible == null) {
            return this.mage.isDestructible(block);
        }
        return this.destructible.contains(block.getType());
    }

    protected void setDestructible(Set<Material> materials) {
        this.checkDestructible = true;
        this.destructible = materials;
    }

    @Override
    protected void processParameters(ConfigurationSection parameters) {
        super.processParameters(parameters);
        this.indestructible = null;
        if (parameters.contains("indestructible")) {
            this.indestructible = this.controller.getMaterialSet(parameters.getString("indestructible"));
        }
        if (parameters.contains("id")) {
            this.indestructible = this.controller.getMaterialSet(parameters.getString("id"));
        }
        this.destructible = null;
        if (parameters.contains("destructible")) {
            this.destructible = this.controller.getMaterialSet(parameters.getString("destructible"));
        }
        this.checkDestructible = parameters.getBoolean("check_destructible", true);
        this.checkDestructible = parameters.getBoolean("cd", this.checkDestructible);
        this.bypassUndo = parameters.getBoolean("bypass_undo", false);
        this.bypassUndo = parameters.getBoolean("bu", this.bypassUndo);
        this.bypassBuildRestriction = parameters.getBoolean("bypass_build", false);
        this.bypassBuildRestriction = parameters.getBoolean("bb", this.bypassBuildRestriction);
    }

    public void registerForUndo(BlockList list) {
        this.modifiedBlocks += list.size();
        if (!this.bypassUndo) {
            this.mage.registerForUndo(list);
        }
    }

    @Override
    protected void preCast() {
        super.preCast();
        this.modifiedBlocks = 0;
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        return message.replace("$count", Integer.toString(this.modifiedBlocks));
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(BLOCK_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("indestructible") || parameterKey.equals("destructible")) {
            examples.addAll(this.controller.getMaterialSets());
        } else if (parameterKey.equals("check_destructible") || parameterKey.equals("bypass_undo")) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        }
    }

    public boolean hasBuildPermission(Block block) {
        if (this.bypassBuildRestriction) {
            return true;
        }
        return this.mage.hasBuildPermission(block);
    }

    public static BlockFace goLeft(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    public static BlockFace goRight(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }
}

