/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.Automaton;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.block.Schematic;
import com.elmakers.mine.bukkit.block.UndoQueue;
import com.elmakers.mine.bukkit.dynmap.DynmapController;
import com.elmakers.mine.bukkit.effects.EffectPlayer;
import com.elmakers.mine.bukkit.essentials.MagicItemDb;
import com.elmakers.mine.bukkit.essentials.Mailer;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MagicPlugin;
import com.elmakers.mine.bukkit.plugins.magic.PhysicsHandler;
import com.elmakers.mine.bukkit.plugins.magic.commands.MagicTabExecutor;
import com.elmakers.mine.bukkit.plugins.magic.spell.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.spell.Spell;
import com.elmakers.mine.bukkit.plugins.magic.spell.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.wand.LostWand;
import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import com.elmakers.mine.bukkit.plugins.magic.wand.WandLevel;
import com.elmakers.mine.bukkit.plugins.magic.wand.WandMode;
import com.elmakers.mine.bukkit.protection.FactionsManager;
import com.elmakers.mine.bukkit.protection.WorldGuardManager;
import com.elmakers.mine.bukkit.traders.TradersController;
import com.elmakers.mine.bukkit.utilities.ConfigurationUtils;
import com.elmakers.mine.bukkit.utilities.DataStore;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.Messages;
import com.elmakers.mine.bukkit.utilities.URLMap;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.warp.WarpController;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MagicController
implements Listener {
    private final String SPELLS_FILE = "spells";
    private final String CONFIG_FILE = "config";
    private final String WANDS_FILE = "wands";
    private final String MESSAGES_FILE = "messages";
    private final String MATERIALS_FILE = "materials";
    private final String LOST_WANDS_FILE = "lostwands";
    private final String AUTOMATA_FILE = "automata";
    private final String URL_MAPS_FILE = "imagemaps";
    private boolean loadDefaultSpells = true;
    private boolean loadDefaultWands = true;
    static final String STICKY_MATERIALS = "37,38,39,50,51,55,59,63,64,65,66,68,70,71,72,75,76,77,78,83";
    static final String STICKY_MATERIALS_DOUBLE_HEIGHT = "64,71,";
    private Set<Material> buildingMaterials = new HashSet<Material>();
    private Set<Material> indestructibleMaterials = new HashSet<Material>();
    private Set<Material> restrictedMaterials = new HashSet<Material>();
    private Set<Material> destructibleMaterials = new HashSet<Material>();
    private Map<String, Set<Material>> materialSets = new HashMap<String, Set<Material>>();
    private int maxTNTPerChunk = 0;
    private int undoQueueDepth = 256;
    private int pendingQueueDepth = 16;
    private int undoMaxPersistSize = 0;
    private boolean commitOnQuit = false;
    private long playerDataThreshold = 0L;
    private WandMode defaultWandMode = WandMode.INVENTORY;
    private boolean showMessages = true;
    private boolean showCastMessages = false;
    private String messagePrefix = "";
    private String castMessagePrefix = "";
    private boolean soundsEnabled = true;
    private boolean indestructibleWands = true;
    private boolean keepWandsOnDeath = true;
    private String welcomeWand = "";
    private int messageThrottle = 0;
    private int clickCooldown = 150;
    private boolean craftingEnabled = false;
    private boolean enchantingEnabled = false;
    private boolean combiningEnabled = false;
    private boolean bindingEnabled = false;
    private boolean keepingEnabled = false;
    private boolean organizingEnabled = false;
    private boolean fillingEnabled = false;
    private boolean essentialsSignsEnabled = false;
    private boolean dynmapUpdate = true;
    private boolean dynmapShowWands = true;
    private boolean dynmapShowSpells = true;
    private float maxDamagePowerMultiplier = 2.0f;
    private float maxConstructionPowerMultiplier = 5.0f;
    private float maxRadiusPowerMultiplier = 2.5f;
    private float maxRadiusPowerMultiplierMax = 4.0f;
    private float maxRangePowerMultiplier = 3.0f;
    private float maxRangePowerMultiplierMax = 5.0f;
    private float maxPower = 1.0f;
    private float castCommandCostReduction = 1.0f;
    private float castCommandCooldownReduction = 1.0f;
    private float castCommandPowerMultiplier = 0.0f;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private int maxBlockUpdates = 100;
    private int ageDroppedItems = 0;
    private int autoUndo = 0;
    private int autoSaveTaskId = 0;
    private WarpController warpController = null;
    private final HashMap<String, Spell> spells = new HashMap();
    private final HashMap<String, Mage> mages = new HashMap();
    private final HashSet<String> forgetMages = new HashSet();
    private final HashMap<String, Mage> pendingConstruction = new HashMap();
    private final Map<String, WeakReference<Schematic>> schematics = new HashMap<String, WeakReference<Schematic>>();
    private Recipe wandRecipe = null;
    private Material wandRecipeUpperMaterial = Material.DIAMOND;
    private Material wandRecipeLowerMaterial = Material.BLAZE_ROD;
    private String recipeOutputTemplate = "random(1)";
    private MagicPlugin plugin = null;
    private final File configFolder;
    private final File dataFolder;
    private final File schematicFolder;
    private final File defaultsFolder;
    private final File playerDataFolder;
    private int toggleCooldown = 1000;
    private int toggleMessageRange = 1024;
    private boolean bypassBuildPermissions = false;
    private boolean bypassPvpPermissions = false;
    private FactionsManager factionsManager = new FactionsManager();
    private WorldGuardManager worldGuardManager = new WorldGuardManager();
    private TradersController tradersController = null;
    private String extraSchematicFilePath = null;
    private Class<?> cuboidClipboardClass = null;
    private DynmapController dynmap = null;
    private Mailer mailer = null;
    private Material defaultMaterial = Material.DIRT;
    private PhysicsHandler physicsHandler = null;
    private Map<String, Map<Long, Automaton>> automata = new HashMap<String, Map<Long, Automaton>>();
    private Map<String, LostWand> lostWands = new HashMap<String, LostWand>();
    private Map<String, Set<String>> lostWandChunks = new HashMap<String, Set<String>>();

    public MagicController(MagicPlugin plugin) {
        this.plugin = plugin;
        this.configFolder = plugin.getDataFolder();
        this.configFolder.mkdirs();
        this.dataFolder = new File(this.configFolder, "data");
        this.dataFolder.mkdirs();
        this.schematicFolder = new File(this.configFolder, "schematics");
        this.schematicFolder.mkdirs();
        this.playerDataFolder = new File(this.dataFolder, "players");
        this.playerDataFolder.mkdirs();
        this.defaultsFolder = new File(this.configFolder, "defaults");
        this.defaultsFolder.mkdirs();
    }

    public Collection<Mage> getMages() {
        return this.mages.values();
    }

    public Mage getMage(Player player) {
        if (player == null) {
            return null;
        }
        String id = player.getUniqueId().toString();
        if (player.hasMetadata("NPC")) {
            id = "NPC-" + player.getName();
        }
        return this.getMage(id, (CommandSender)player);
    }

    public Mage getMage(String mageId, CommandSender commandSender) {
        Mage mage = null;
        if (!this.mages.containsKey(mageId)) {
            mage = new Mage(mageId, this);
            File playerFile = new File(this.playerDataFolder, mageId + ".dat");
            if (playerFile.exists()) {
                this.getLogger().info("Loading player data from file " + playerFile.getName());
                try {
                    YamlConfiguration playerData = YamlConfiguration.loadConfiguration((File)playerFile);
                    mage.load((ConfigurationSection)playerData);
                }
                catch (Exception ex) {
                    this.getLogger().warning("Failed to load player data from file " + playerFile.getName());
                    ex.printStackTrace();
                }
            }
            this.mages.put(mageId, mage);
        } else {
            mage = this.mages.get(mageId);
        }
        mage.setCommandSender(commandSender);
        if (commandSender instanceof Player) {
            mage.setPlayer((Player)commandSender);
        }
        return mage;
    }

    public Mage getMage(CommandSender commandSender) {
        BlockCommandSender commandBlock;
        String commandName;
        String mageId = "COMMAND";
        if (commandSender instanceof ConsoleCommandSender) {
            mageId = "CONSOLE";
        } else if (commandSender instanceof Player) {
            mageId = ((Player)commandSender).getUniqueId().toString();
        } else if (commandSender instanceof BlockCommandSender && (commandName = (commandBlock = (BlockCommandSender)commandSender).getName()) != null && commandName.length() > 0) {
            mageId = "COMMAND-" + commandBlock.getName();
        }
        return this.getMage(mageId, commandSender);
    }

    protected void loadMage(String playerId, ConfigurationSection node) {
        Mage mage = this.getMage(playerId);
        try {
            mage.load(node);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected Mage getMage(String mageId) {
        return this.getMage(mageId, null);
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString) {
        this.createSpell(template, name, icon, description, category, parameterString, null, null);
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString, String propertiesString) {
        this.createSpell(template, name, icon, description, category, parameterString, propertiesString, null);
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString, String propertiesString, String costsString) {
        MemoryConfiguration spellNode = new MemoryConfiguration();
        ConfigurationSection parameterNode = spellNode.createSection("parameters");
        ConfigurationSection propertiesNode = spellNode.createSection("properties");
        if (parameterString != null && parameterString.length() > 0) {
            String[] parameters = parameterString.split(" ");
            Spell.addParameters(parameters, parameterNode);
        }
        if (propertiesString != null && propertiesString.length() > 0) {
            String[] properties = propertiesString.split(" ");
            Spell.addParameters(properties, propertiesNode);
        }
        if (costsString != null && costsString.length() > 0) {
            ArrayList costs = new ArrayList();
            String[] costPairs = costsString.split(" ");
            for (int i = 0; i < costPairs.length - 1; i += 2) {
                try {
                    int amount = Integer.parseInt(costPairs[i + 1]);
                    HashMap<String, Object> cost = new HashMap<String, Object>();
                    cost.put("material", costPairs[i]);
                    cost.put("amount", amount);
                    costs.add(cost);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            spellNode.set("costs", costs);
        }
        spellNode.set("description", (Object)description);
        spellNode.set("icon", (Object)icon);
        spellNode.set("category", (Object)category);
        template.initialize(this);
        template.loadTemplate(name, (ConfigurationSection)spellNode);
        this.addSpell(template);
    }

    public void addSpell(Spell variant) {
        Spell conflict = this.spells.get(variant.getKey());
        if (conflict != null) {
            this.getLogger().log(Level.WARNING, "Duplicate spell name: '" + conflict.getKey() + "'");
        } else {
            this.spells.put(variant.getKey(), variant);
        }
    }

    public Set<Material> getBuildingMaterials() {
        return this.buildingMaterials;
    }

    public Set<Material> getDestructibleMaterials() {
        return this.destructibleMaterials;
    }

    protected Set<Material> getRestrictedMaterials() {
        return this.restrictedMaterials;
    }

    public Set<Material> getMaterialSet(String name) {
        if (name.contains(",")) {
            return ConfigurationUtils.parseMaterials(name);
        }
        if (!this.materialSets.containsKey(name)) {
            return ConfigurationUtils.parseMaterials(name);
        }
        return this.materialSets.get(name);
    }

    public Collection<String> getMaterialSets() {
        return this.materialSets.keySet();
    }

    public float getMaxDamagePowerMultiplier() {
        return this.maxDamagePowerMultiplier;
    }

    public float getMaxConstructionPowerMultiplier() {
        return this.maxConstructionPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplier() {
        return this.maxRadiusPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplierMax() {
        return this.maxRadiusPowerMultiplierMax;
    }

    public float getMaxRangePowerMultiplier() {
        return this.maxRangePowerMultiplier;
    }

    public float getMaxRangePowerMultiplierMax() {
        return this.maxRangePowerMultiplierMax;
    }

    public int getAutoUndoInterval() {
        return this.autoUndo;
    }

    public float getMaxPower() {
        return this.maxPower;
    }

    public int getUndoQueueDepth() {
        return this.undoQueueDepth;
    }

    public int getPendingQueueDepth() {
        return this.pendingQueueDepth;
    }

    public int getMaxUndoPersistSize() {
        return this.undoMaxPersistSize;
    }

    public Mage undoAny(Block target) {
        for (Mage mage : this.mages.values()) {
            if (!mage.undo(target)) continue;
            return mage;
        }
        return null;
    }

    public boolean commitAll() {
        boolean undid = false;
        for (Mage mage : this.mages.values()) {
            undid = mage.commit() || undid;
        }
        return undid;
    }

    public void registerEvent(SpellEventType type, Spell spell) {
        Mage mage = this.getMage(spell.getPlayer());
        mage.registerEvent(type, spell);
    }

    public void unregisterEvent(SpellEventType type, Spell spell) {
        Mage mage = this.getMage(spell.getPlayer());
        mage.unregisterEvent(type, spell);
    }

    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public String getCastMessagePrefix() {
        return this.castMessagePrefix;
    }

    public boolean showCastMessages() {
        return this.showCastMessages;
    }

    public boolean showMessages() {
        return this.showMessages;
    }

    public int getMessageThrottle() {
        return this.messageThrottle;
    }

    public boolean soundsEnabled() {
        return this.soundsEnabled;
    }

    public boolean fillWands() {
        return this.fillingEnabled;
    }

    public boolean bindWands() {
        return this.bindingEnabled;
    }

    public boolean keepWands() {
        return this.keepingEnabled;
    }

    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    public MagicPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isIndestructible(Location location) {
        return this.isIndestructible(location.getBlock());
    }

    public boolean isIndestructible(Block block) {
        return this.indestructibleMaterials.contains(block.getType());
    }

    public boolean isDestructible(Block block) {
        return this.destructibleMaterials.contains(block.getType());
    }

    protected boolean isRestricted(Material material) {
        return this.restrictedMaterials.contains(material);
    }

    public boolean hasBuildPermission(Player player, Location location) {
        return this.hasBuildPermission(player, location.getBlock());
    }

    public boolean hasBuildPermission(Player player, Block block) {
        boolean allowed = true;
        if (this.bypassBuildPermissions) {
            return true;
        }
        allowed = allowed && this.worldGuardManager.hasBuildPermission(player, block);
        allowed = allowed && this.factionsManager.hasBuildPermission(player, block);
        return allowed;
    }

    public boolean isPVPAllowed(Location location) {
        if (this.bypassPvpPermissions) {
            return true;
        }
        return this.worldGuardManager.isPVPAllowed(location);
    }

    public boolean schematicsEnabled() {
        return this.cuboidClipboardClass != null;
    }

    public void clearCache() {
        String[] schematicFiles;
        for (String schematicFilename : schematicFiles = this.schematicFolder.list()) {
            InputStream builtin;
            if (!schematicFilename.endsWith(".schematic") || (builtin = this.plugin.getResource("schematics/" + schematicFilename)) == null) continue;
            File schematicFile = new File(this.schematicFolder, schematicFilename);
            schematicFile.delete();
            this.plugin.getLogger().info("Deleted file " + schematicFile.getAbsolutePath());
        }
        this.schematics.clear();
        for (Mage mage : this.mages.values()) {
            mage.clearCache();
        }
    }

    public Schematic loadSchematic(String schematicName) {
        Schematic cached;
        WeakReference<Schematic> schematic;
        if (schematicName == null || schematicName.length() == 0 || !this.schematicsEnabled()) {
            return null;
        }
        if (this.schematics.containsKey(schematicName) && (schematic = this.schematics.get(schematicName)) != null && (cached = (Schematic)schematic.get()) != null) {
            return cached;
        }
        String fileName = schematicName + ".schematic";
        File schematicFile = new File(this.schematicFolder, fileName);
        if (!schematicFile.exists()) {
            try {
                File extraSchematicFile = null;
                if (this.extraSchematicFilePath != null && this.extraSchematicFilePath.length() > 0) {
                    File schematicFolder = new File(this.configFolder, "../" + this.extraSchematicFilePath);
                    extraSchematicFile = new File(schematicFolder, schematicName + ".schematic");
                    this.getLogger().info("Checking for external schematic: " + extraSchematicFile.getAbsolutePath());
                }
                if (extraSchematicFile != null && extraSchematicFile.exists()) {
                    schematicFile = extraSchematicFile;
                    this.getLogger().info("Loading file: " + extraSchematicFile.getAbsolutePath());
                } else {
                    this.plugin.saveResource("schematics/" + fileName, true);
                    this.getLogger().info("Adding builtin schematic: schematics/" + fileName);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!schematicFile.exists()) {
            this.getLogger().warning("Could not load file: " + schematicFile.getAbsolutePath());
            return null;
        }
        try {
            Method loadSchematicMethod = this.cuboidClipboardClass.getMethod("loadSchematic", File.class);
            this.getLogger().info("Loading schematic file: " + schematicFile.getAbsolutePath());
            Schematic schematic2 = new Schematic(loadSchematicMethod.invoke(null, schematicFile));
            this.schematics.put(schematicName, new WeakReference<Schematic>(schematic2));
            return schematic2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Collection<String> getMaterials() {
        Material[] materials;
        ArrayList<String> names = new ArrayList<String>();
        for (Material material : materials = Material.values()) {
            if (!material.isBlock()) continue;
            names.add(material.name().toLowerCase());
        }
        for (String string : MaterialBrush.SPECIAL_MATERIAL_KEYS) {
            names.add(string.toLowerCase());
        }
        Collection<String> collection = this.getSchematicNames();
        for (String schematic : collection) {
            names.add("schematic:" + schematic);
        }
        return names;
    }

    public Collection<String> getSchematicNames() {
        String schematicName;
        ArrayList<String> schematicNames = new ArrayList<String>();
        if (!MaterialBrush.SchematicsEnabled) {
            return schematicNames;
        }
        try {
            CodeSource codeSource = MagicTabExecutor.class.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL jar = codeSource.getLocation();
                ZipInputStream zip = new ZipInputStream(jar.openStream());
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (name.startsWith("schematics/") && name.endsWith(".schematic")) {
                        schematicName = name.replace(".schematic", "").replace("schematics/", "");
                        schematicNames.add(schematicName);
                    }
                    entry = zip.getNextEntry();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (this.extraSchematicFilePath != null && this.extraSchematicFilePath.length() > 0) {
                File schematicFolder = new File(this.configFolder, "../" + this.extraSchematicFilePath);
                for (File schematicFile : schematicFolder.listFiles()) {
                    if (!schematicFile.getName().endsWith(".schematic")) continue;
                    schematicName = schematicFile.getName().replace(".schematic", "");
                    schematicNames.add(schematicName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return schematicNames;
    }

    public void initialize() {
        Plugin essentials;
        this.load();
        if (this.craftingEnabled) {
            Wand wand = new Wand(this);
            ShapedRecipe recipe = new ShapedRecipe(wand.getItem());
            recipe.shape(new String[]{"o", "i"}).setIngredient('o', this.wandRecipeUpperMaterial).setIngredient('i', this.wandRecipeLowerMaterial);
            this.wandRecipe = recipe;
            this.getLogger().info("Wand crafting is enabled");
        }
        if ((essentials = this.plugin.getServer().getPluginManager().getPlugin("Essentials")) != null) {
            try {
                this.mailer = new Mailer(essentials);
            }
            catch (Exception ex) {
                this.getLogger().warning("Essentials found, but failed to hook up to Mailer");
                this.mailer = null;
            }
        }
        if (this.essentialsSignsEnabled) {
            final MagicController me = this;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    try {
                        Plugin essentials = me.plugin.getServer().getPluginManager().getPlugin("Essentials");
                        if (essentials != null) {
                            Class<?> essentialsClass = essentials.getClass();
                            Field itemDbField = essentialsClass.getDeclaredField("itemDb");
                            itemDbField.setAccessible(true);
                            Object oldEntry = itemDbField.get(essentials);
                            if (oldEntry instanceof MagicItemDb) {
                                MagicController.this.getLogger().info("Essentials integration already set up, skipping");
                                return;
                            }
                            if (!oldEntry.getClass().getName().equals("com.earth2me.essentials.ItemDb")) {
                                MagicController.this.getLogger().info("Essentials Item DB class unexepcted: " + oldEntry.getClass().getName() + ", skipping integration");
                                return;
                            }
                            MagicItemDb newEntry = new MagicItemDb(me, essentials);
                            itemDbField.set(essentials, (Object)newEntry);
                            Field confListField = essentialsClass.getDeclaredField("confList");
                            confListField.setAccessible(true);
                            List confList = (List)confListField.get(essentials);
                            confList.remove(oldEntry);
                            confList.add(newEntry);
                            MagicController.this.getLogger().info("Essentials found, hooked up custom item handler");
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }, 5L);
        }
        this.tradersController = null;
        try {
            Plugin tradersPlugin = this.plugin.getServer().getPluginManager().getPlugin("dtlTraders");
            if (tradersPlugin != null) {
                this.tradersController = new TradersController();
                this.tradersController.initialize(this, tradersPlugin);
                this.getLogger().info("dtlTraders found, integrating for selling Wands, Spells, Brushes and Upgrades");
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.tradersController = null;
        }
        if (this.tradersController == null) {
            this.getLogger().info("dtlTraders not found, will not integrate.");
        }
        try {
            this.cuboidClipboardClass = Class.forName("com.sk89q.worldedit.CuboidClipboard");
            Method loadSchematicMethod = this.cuboidClipboardClass.getMethod("loadSchematic", File.class);
            if (loadSchematicMethod != null) {
                this.getLogger().info("WorldEdit found, schematic brushes enabled.");
                MaterialBrush.SchematicsEnabled = true;
            } else {
                this.cuboidClipboardClass = null;
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        try {
            Plugin commandBookPlugin = this.plugin.getServer().getPluginManager().getPlugin("CommandBook");
            if (commandBookPlugin != null) {
                this.warpController = new WarpController();
                if (this.warpController.setCommandBook(commandBookPlugin)) {
                    this.getLogger().info("CommandBook found, integrating for Recall warps");
                } else {
                    this.getLogger().warning("CommandBook integration failed");
                }
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (this.cuboidClipboardClass == null) {
            this.getLogger().info("WorldEdit not found, schematic brushes will not work.");
            MaterialBrush.SchematicsEnabled = false;
        }
        this.factionsManager.initialize((Plugin)this.plugin);
        this.worldGuardManager.initialize((Plugin)this.plugin);
        try {
            Plugin dynmapPlugin = this.plugin.getServer().getPluginManager().getPlugin("dynmap");
            this.dynmap = dynmapPlugin != null ? new DynmapController((Plugin)this.plugin, dynmapPlugin) : null;
        }
        catch (Throwable ex) {
            this.plugin.getLogger().warning(ex.getMessage());
        }
        if (this.dynmap == null) {
            this.getLogger().info("dynmap not found, not integrating.");
        } else {
            this.getLogger().info("dynmap found, integrating.");
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (Mage mage : MagicController.this.mages.values()) {
                    mage.tick();
                }
            }
        }, 0L, 20L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (String id : MagicController.this.forgetMages) {
                    MagicController.this.mages.remove(id);
                }
                MagicController.this.forgetMages.clear();
                ArrayList pending = new ArrayList();
                pending.addAll(MagicController.this.pendingConstruction.values());
                for (Mage mage : pending) {
                    mage.processPendingBatches(MagicController.this.maxBlockUpdates);
                }
            }
        }, 0L, 1L);
    }

    public Collection<Mage> getPending() {
        return this.pendingConstruction.values();
    }

    protected void addPending(Mage mage) {
        this.pendingConstruction.put(mage.getName(), mage);
    }

    protected void removePending(Mage mage) {
        this.pendingConstruction.remove(mage.getName());
    }

    public void updateBlock(Block block) {
        this.updateBlock(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    public void updateBlock(String worldName, int x, int y, int z) {
        if (this.dynmap != null && this.dynmapUpdate) {
            this.dynmap.triggerRenderOfBlock(worldName, x, y, z);
        }
    }

    public void updateVolume(String worldName, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        if (this.dynmap != null && this.dynmapUpdate) {
            this.dynmap.triggerRenderOfVolume(worldName, minx, miny, minz, maxx, maxy, maxz);
        }
    }

    public boolean removeMarker(String id, String group) {
        boolean removed = false;
        if (this.dynmap != null && this.dynmapShowWands) {
            return this.dynmap.removeMarker(id, group);
        }
        return removed;
    }

    public boolean addMarker(String id, String group, String title, String world, int x, int y, int z, String description) {
        boolean created = false;
        if (this.dynmap != null && this.dynmapShowWands) {
            created = this.dynmap.addMarker(id, group, title, world, x, y, z, description);
        }
        return created;
    }

    protected File getDataFile(String fileName) {
        File dataFile = new File(this.dataFolder, fileName + ".yml");
        File legacyFile = new File(this.configFolder, fileName + ".yml");
        if (fileName.equals("imagemaps")) {
            legacyFile = new File(this.configFolder, "urlmaps.yml");
        }
        if (legacyFile.exists() && !dataFile.exists()) {
            this.getLogger().info("MIGRATING " + legacyFile.getName() + ", you should only see this once.");
            legacyFile.renameTo(dataFile);
        }
        return dataFile;
    }

    protected ConfigurationSection loadDataFile(String fileName) {
        File dataFile = this.getDataFile(fileName);
        if (!dataFile.exists()) {
            return null;
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)dataFile);
        return configuration;
    }

    protected DataStore createDataFile(String fileName) {
        File dataFile = new File(this.dataFolder, fileName + ".yml");
        DataStore configuration = new DataStore(this.getLogger(), dataFile);
        return configuration;
    }

    protected ConfigurationSection loadConfigFile(String fileName, boolean loadDefaults) {
        String configFileName = fileName + ".yml";
        File configFile = new File(this.configFolder, configFileName);
        if (!configFile.exists()) {
            this.getLogger().info("Saving template " + configFileName + ", edit to customize configuration.");
            this.plugin.saveResource(configFileName, false);
        }
        String defaultsFileName = "defaults/" + fileName + ".defaults.yml";
        this.plugin.saveResource(defaultsFileName, true);
        this.getLogger().info("Loading " + configFile.getName());
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        if (!loadDefaults) {
            return config;
        }
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((InputStream)this.plugin.getResource(defaultsFileName));
        ConfigurationUtils.addConfigurations((ConfigurationSection)defaultConfig, (ConfigurationSection)config);
        return defaultConfig;
    }

    public void loadConfiguration() {
        this.schematics.clear();
        try {
            this.loadProperties(this.loadConfigFile("config", true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            Messages.reset();
            Messages.load(this.loadConfigFile("messages", true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.loadMaterials(this.loadConfigFile("materials", true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.loadSpells(this.loadConfigFile("spells", this.loadDefaultSpells));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            Wand.loadTemplates(this.loadConfigFile("wands", this.loadDefaultWands));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Magic: Loaded " + this.spells.size() + " spells and " + Wand.getWandTemplates().size() + " wands");
    }

    public void load() {
        File[] playerFiles;
        this.loadConfiguration();
        for (File playerFile : playerFiles = this.playerDataFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".dat");
            }
        })) {
            YamlConfiguration playerData;
            if (this.playerDataThreshold > 0L && playerFile.lastModified() < System.currentTimeMillis() - this.playerDataThreshold || !(playerData = YamlConfiguration.loadConfiguration((File)playerFile)).contains("scheduled") || playerData.getList("scheduled").size() <= 0) continue;
            String playerId = playerFile.getName().replaceFirst("[.][^.]+$", "");
            this.loadMage(playerId, (ConfigurationSection)playerData);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                MagicController.this.getLogger().info("Loading lost wand data");
                MagicController.this.loadLostWands();
                MagicController.this.getLogger().info("Loading autonoma data");
                MagicController.this.loadAutomata();
                try {
                    URLMap.resetAll();
                    File urlMapFile = MagicController.this.getDataFile("imagemaps");
                    File imageCache = new File(MagicController.this.dataFolder, "imagemapcache");
                    imageCache.mkdirs();
                    URLMap.load((Plugin)MagicController.this.plugin, urlMapFile, imageCache);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                MagicController.this.getLogger().info("Finished loading data.");
            }
        }, 10L);
    }

    protected void loadLostWands() {
        try {
            ConfigurationSection lostWandConfiguration = this.loadDataFile("lostwands");
            if (lostWandConfiguration != null) {
                Set wandIds = lostWandConfiguration.getKeys(false);
                for (String wandId : wandIds) {
                    LostWand lostWand = new LostWand(wandId, lostWandConfiguration.getConfigurationSection(wandId));
                    if (!lostWand.isValid()) {
                        this.getLogger().info("Skipped invalid entry in lostwands.yml file, entry will be deleted. The wand is really lost now!");
                        continue;
                    }
                    this.addLostWand(lostWand);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Loaded " + this.lostWands.size() + " lost wands");
    }

    protected void saveLostWandData() {
        String lastKey = "";
        try {
            DataStore lostWandsConfiguration = this.createDataFile("lostwands");
            for (Map.Entry<String, LostWand> wandEntry : this.lostWands.entrySet()) {
                lastKey = wandEntry.getKey();
                ConfigurationSection wandNode = lostWandsConfiguration.createSection(lastKey);
                if (wandNode == null) {
                    this.getLogger().warning("Error saving lost wand data for " + lastKey + " " + lostWandsConfiguration.get(lastKey));
                    continue;
                }
                if (!wandEntry.getValue().isValid()) {
                    this.getLogger().warning("Invalid lost and data for " + lastKey + " " + lostWandsConfiguration.get(lastKey));
                    continue;
                }
                wandEntry.getValue().save(wandNode);
            }
            lostWandsConfiguration.save();
        }
        catch (Throwable ex) {
            this.getLogger().warning("Error saving lost wand data for " + lastKey);
            ex.printStackTrace();
        }
    }

    protected void loadAutomata() {
        int automataCount = 0;
        try {
            ConfigurationSection toggleBlockData = this.loadDataFile("automata");
            if (toggleBlockData != null) {
                Set chunkIds = toggleBlockData.getKeys(false);
                for (String chunkId : chunkIds) {
                    ConfigurationSection chunkNode = toggleBlockData.getConfigurationSection(chunkId);
                    HashMap<Long, Automaton> restoreChunk = new HashMap<Long, Automaton>();
                    this.automata.put(chunkId, restoreChunk);
                    Set blockIds = chunkNode.getKeys(false);
                    for (String blockId : blockIds) {
                        ConfigurationSection toggleConfig = chunkNode.getConfigurationSection(blockId);
                        Automaton toggle = new Automaton(toggleConfig);
                        restoreChunk.put(toggle.getId(), toggle);
                        ++automataCount;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Loaded " + automataCount + " automata");
    }

    protected void saveAutomata() {
        try {
            DataStore automataData = this.createDataFile("automata");
            for (Map.Entry<String, Map<Long, Automaton>> toggleEntry : this.automata.entrySet()) {
                Collection<Automaton> blocks = toggleEntry.getValue().values();
                if (blocks.size() <= 0) continue;
                ConfigurationSection chunkNode = automataData.createSection(toggleEntry.getKey());
                for (Automaton block : blocks) {
                    ConfigurationSection node = chunkNode.createSection(Long.toString(block.getId()));
                    block.save(node);
                }
            }
            automataData.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected String getChunkKey(Chunk chunk) {
        return chunk.getWorld().getName() + "|" + chunk.getX() + "," + chunk.getZ();
    }

    protected boolean addLostWand(LostWand lostWand) {
        if (this.lostWands.containsKey(lostWand.getId())) {
            this.updateLostWand(lostWand);
            return false;
        }
        this.lostWands.put(lostWand.getId(), lostWand);
        String chunkKey = this.getChunkKey(lostWand.getLocation().getChunk());
        Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
        if (chunkWands == null) {
            chunkWands = new HashSet<String>();
            this.lostWandChunks.put(chunkKey, chunkWands);
        }
        chunkWands.add(lostWand.getId());
        if (this.dynmapShowWands) {
            this.addLostWandMarker(lostWand);
        }
        return true;
    }

    protected void updateLostWand(Wand wand, Location dropLocation) {
        LostWand lostWand = this.lostWands.get(wand.getId());
        lostWand.update(wand, dropLocation);
        this.addLostWandMarker(lostWand);
    }

    protected void updateLostWand(LostWand newLost) {
        LostWand currentLostWand = this.lostWands.get(newLost.getId());
        currentLostWand.update(newLost);
        if (this.dynmapShowWands) {
            this.addLostWandMarker(currentLostWand);
        }
    }

    public boolean addLostWand(Wand wand, Location dropLocation) {
        if (!wand.hasId()) {
            return false;
        }
        if (this.lostWands.containsKey(wand.getId())) {
            this.updateLostWand(wand, dropLocation);
            return false;
        }
        LostWand lostWand = new LostWand(wand, dropLocation);
        this.addLostWand(lostWand);
        return true;
    }

    public boolean removeLostWand(String wandId) {
        if (!this.lostWands.containsKey(wandId)) {
            return false;
        }
        LostWand lostWand = this.lostWands.get(wandId);
        this.lostWands.remove(wandId);
        String chunkKey = this.getChunkKey(lostWand.getLocation().getChunk());
        Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
        if (chunkWands != null) {
            chunkWands.remove(wandId);
            if (chunkWands.size() == 0) {
                this.lostWandChunks.remove(chunkKey);
            }
        }
        if (this.dynmapShowWands && this.removeMarker("wand-" + wandId, "Wands")) {
            this.getLogger().info("Wand removed from map");
        }
        return true;
    }

    public boolean removeLostWand(Wand wand) {
        return this.removeLostWand(wand.getId());
    }

    public WandMode getDefaultWandMode() {
        return this.defaultWandMode;
    }

    protected void savePlayerData() {
        ArrayList<String> forgetIds = new ArrayList<String>();
        try {
            for (Map.Entry<String, Mage> mageEntry : this.mages.entrySet()) {
                UndoQueue undoQueue;
                File playerData = new File(this.playerDataFolder, mageEntry.getKey() + ".dat");
                DataStore playerConfig = new DataStore(this.getLogger(), playerData);
                Mage mage = mageEntry.getValue();
                mage.save((ConfigurationSection)playerConfig);
                playerConfig.save();
                Player player = mage.getPlayer();
                if (player == null || player.isOnline() || player.hasMetadata("NPC") || (undoQueue = mage.getUndoQueue()) != null && !undoQueue.isEmpty()) continue;
                this.getLogger().info("Offline player " + player.getName() + " has no pending undo actions, forgetting");
                forgetIds.add(mageEntry.getKey());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (String forgetId : forgetIds) {
            this.mages.remove(forgetId);
        }
    }

    public void save() {
        this.getLogger().info("Saving player data");
        this.savePlayerData();
        this.getLogger().info("Saving lost wands data");
        this.saveLostWandData();
        this.getLogger().info("Saving image map data");
        URLMap.save();
        this.getLogger().info("Saving autonoma data");
        this.saveAutomata();
    }

    protected void loadSpells(ConfigurationSection config) {
        if (config == null) {
            return;
        }
        this.spells.clear();
        Set spellKeys = config.getKeys(false);
        for (String key : spellKeys) {
            ConfigurationSection spellNode = config.getConfigurationSection(key);
            if (!spellNode.getBoolean("enabled", true)) continue;
            Spell newSpell = Spell.loadSpell(key, spellNode, this);
            if (newSpell == null) {
                this.getLogger().warning("Magic: Error loading spell " + key);
                continue;
            }
            this.addSpell(newSpell);
        }
        for (Mage mage : this.mages.values()) {
            mage.loadSpells(config);
        }
    }

    protected void loadMaterials(ConfigurationSection materialNode) {
        if (materialNode == null) {
            return;
        }
        Set keys = materialNode.getKeys(false);
        for (String key : keys) {
            this.materialSets.put(key, ConfigurationUtils.getMaterials(materialNode, key));
        }
        if (this.materialSets.containsKey("building")) {
            this.buildingMaterials = this.materialSets.get("building");
        }
        if (this.materialSets.containsKey("indestructible")) {
            this.indestructibleMaterials = this.materialSets.get("indestructible");
        }
        if (this.materialSets.containsKey("restricted")) {
            this.restrictedMaterials = this.materialSets.get("restricted");
        }
        if (this.materialSets.containsKey("destructible")) {
            this.destructibleMaterials = this.materialSets.get("destructible");
        }
    }

    protected void loadProperties(ConfigurationSection properties) {
        if (properties == null) {
            return;
        }
        if (this.autoSaveTaskId > 0) {
            Bukkit.getScheduler().cancelTask(this.autoSaveTaskId);
            this.autoSaveTaskId = 0;
        }
        this.loadDefaultSpells = properties.getBoolean("load_default_spells", this.loadDefaultSpells);
        this.loadDefaultWands = properties.getBoolean("load_default_wands", this.loadDefaultWands);
        this.maxTNTPerChunk = properties.getInt("max_tnt_per_chunk", this.maxTNTPerChunk);
        this.undoQueueDepth = properties.getInt("undo_depth", this.undoQueueDepth);
        this.pendingQueueDepth = properties.getInt("pending_depth", this.pendingQueueDepth);
        this.undoMaxPersistSize = properties.getInt("undo_max_persist_size", this.undoMaxPersistSize);
        this.commitOnQuit = properties.getBoolean("commit_on_quit", this.commitOnQuit);
        this.playerDataThreshold = (long)(properties.getDouble("undo_max_persist_size", 0.0) * 1000.0 * 24.0 * 3600.0);
        this.defaultWandMode = Wand.parseWandMode(properties.getString("default_wand_mode", ""), this.defaultWandMode);
        this.showMessages = properties.getBoolean("show_messages", this.showMessages);
        this.showCastMessages = properties.getBoolean("show_cast_messages", this.showCastMessages);
        this.clickCooldown = properties.getInt("click_cooldown", this.clickCooldown);
        this.messageThrottle = properties.getInt("message_throttle", 0);
        this.maxBlockUpdates = properties.getInt("max_block_updates", this.maxBlockUpdates);
        this.ageDroppedItems = properties.getInt("age_dropped_items", this.ageDroppedItems);
        this.soundsEnabled = properties.getBoolean("sounds", this.soundsEnabled);
        this.fillingEnabled = properties.getBoolean("fill_wands", this.fillingEnabled);
        this.indestructibleWands = properties.getBoolean("indestructible_wands", this.indestructibleWands);
        this.keepWandsOnDeath = properties.getBoolean("keep_wands_on_death", this.keepWandsOnDeath);
        this.welcomeWand = properties.getString("welcome_wand", "");
        this.maxDamagePowerMultiplier = (float)properties.getDouble("max_power_damage_multiplier", (double)this.maxDamagePowerMultiplier);
        this.maxConstructionPowerMultiplier = (float)properties.getDouble("max_power_construction_multiplier", (double)this.maxConstructionPowerMultiplier);
        this.maxRangePowerMultiplier = (float)properties.getDouble("max_power_range_multiplier", (double)this.maxRangePowerMultiplier);
        this.maxRangePowerMultiplierMax = (float)properties.getDouble("max_power_range_multiplier_max", (double)this.maxRangePowerMultiplierMax);
        this.maxRadiusPowerMultiplier = (float)properties.getDouble("max_power_radius_multiplier", (double)this.maxRadiusPowerMultiplier);
        this.maxRadiusPowerMultiplierMax = (float)properties.getDouble("max_power_radius_multiplier_max", (double)this.maxRadiusPowerMultiplierMax);
        this.maxPower = (float)properties.getDouble("max_power", (double)this.maxPower);
        this.costReduction = (float)properties.getDouble("cost_reduction", (double)this.costReduction);
        this.cooldownReduction = (float)properties.getDouble("cooldown_reduction", (double)this.cooldownReduction);
        this.castCommandCostReduction = (float)properties.getDouble("cast_command_cost_reduction", (double)this.castCommandCostReduction);
        this.castCommandCooldownReduction = (float)properties.getDouble("cast_command_cooldown_reduction", (double)this.castCommandCooldownReduction);
        this.castCommandPowerMultiplier = (float)properties.getDouble("cast_command_power_multiplier", (double)this.castCommandPowerMultiplier);
        this.autoUndo = properties.getInt("auto_undo", this.autoUndo);
        this.enchantingEnabled = properties.getBoolean("enable_enchanting", this.enchantingEnabled);
        this.combiningEnabled = properties.getBoolean("enable_combining", this.combiningEnabled);
        this.bindingEnabled = properties.getBoolean("enable_binding", this.bindingEnabled);
        this.keepingEnabled = properties.getBoolean("enable_keeping", this.keepingEnabled);
        this.organizingEnabled = properties.getBoolean("enable_organizing", this.organizingEnabled);
        this.essentialsSignsEnabled = properties.getBoolean("enable_essentials_signs", this.essentialsSignsEnabled);
        this.dynmapShowWands = properties.getBoolean("dynmap_show_wands", this.dynmapShowWands);
        this.dynmapShowSpells = properties.getBoolean("dynmap_show_spells", this.dynmapShowSpells);
        this.dynmapUpdate = properties.getBoolean("dynmap_update", this.dynmapUpdate);
        this.bypassBuildPermissions = properties.getBoolean("bypass_build", this.bypassBuildPermissions);
        this.bypassPvpPermissions = properties.getBoolean("bypass_pvp", this.bypassPvpPermissions);
        this.extraSchematicFilePath = properties.getString("schematic_files", this.extraSchematicFilePath);
        this.messagePrefix = properties.getString("message_prefix", this.messagePrefix);
        this.castMessagePrefix = properties.getString("cast_message_prefix", this.castMessagePrefix);
        this.messagePrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.messagePrefix);
        this.castMessagePrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.castMessagePrefix);
        this.worldGuardManager.setEnabled(properties.getBoolean("region_manager_enabled", this.factionsManager.isEnabled()));
        this.factionsManager.setEnabled(properties.getBoolean("factions_enabled", this.factionsManager.isEnabled()));
        if (properties.contains("mana_display")) {
            Wand.displayManaAsBar = !properties.getString("mana_display").equals("number");
        }
        Wand.DefaultUpgradeMaterial = ConfigurationUtils.getMaterial(properties, "wand_upgrade_item", Wand.DefaultUpgradeMaterial);
        Wand.DefaultWandMaterial = ConfigurationUtils.getMaterial(properties, "wand_item", Wand.DefaultWandMaterial);
        Wand.EnableGlow = properties.getBoolean("enable_glow", Wand.EnableGlow);
        MaterialBrush.CopyMaterial = ConfigurationUtils.getMaterial(properties, "copy_item", MaterialBrush.CopyMaterial);
        MaterialBrush.EraseMaterial = ConfigurationUtils.getMaterial(properties, "erase_item", MaterialBrush.EraseMaterial);
        MaterialBrush.CloneMaterial = ConfigurationUtils.getMaterial(properties, "clone_item", MaterialBrush.CloneMaterial);
        MaterialBrush.ReplicateMaterial = ConfigurationUtils.getMaterial(properties, "replicate_item", MaterialBrush.ReplicateMaterial);
        MaterialBrush.SchematicMaterial = ConfigurationUtils.getMaterial(properties, "schematic_item", MaterialBrush.SchematicMaterial);
        MaterialBrush.MapMaterial = ConfigurationUtils.getMaterial(properties, "map_item", MaterialBrush.MapMaterial);
        Wand.EnchantableWandMaterial = ConfigurationUtils.getMaterial(properties, "wand_item_enchantable", Wand.EnchantableWandMaterial);
        this.craftingEnabled = properties.getBoolean("enable_crafting", this.craftingEnabled);
        if (this.craftingEnabled) {
            this.recipeOutputTemplate = properties.getString("crafting_output", this.recipeOutputTemplate);
            this.wandRecipeUpperMaterial = ConfigurationUtils.getMaterial(properties, "crafting_material_upper", this.wandRecipeUpperMaterial);
            this.wandRecipeLowerMaterial = ConfigurationUtils.getMaterial(properties, "crafting_material_lower", this.wandRecipeLowerMaterial);
        }
        EffectPlayer.SOUNDS_ENABLED = this.soundsEnabled;
        final MagicController saveController = this;
        int autoSaveIntervalTicks = properties.getInt("auto_save", 0) * 20 / 1000;
        if (autoSaveIntervalTicks > 1) {
            this.autoSaveTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    saveController.getLogger().info("Auto-saving Magic data");
                    saveController.save();
                    saveController.getLogger().info("... Done auto-saving.");
                }
            }, (long)autoSaveIntervalTicks, (long)autoSaveIntervalTicks);
        }
    }

    protected void clear() {
        this.mages.clear();
        this.pendingConstruction.clear();
        this.spells.clear();
    }

    public List<Spell> getAllSpells() {
        ArrayList<Spell> allSpells = new ArrayList<Spell>();
        allSpells.addAll(this.spells.values());
        return allSpells;
    }

    public void disablePhysics(int interval) {
        if (this.physicsHandler == null) {
            this.physicsHandler = new PhysicsHandler(this, interval);
            Bukkit.getPluginManager().registerEvents((Listener)this.physicsHandler, (Plugin)this.plugin);
        }
    }

    protected void unregisterPhysicsHandler(Listener listener) {
        BlockPhysicsEvent.getHandlerList().unregister(listener);
        this.physicsHandler = null;
    }

    public boolean hasWandPermission(Player player) {
        return this.hasPermission(player, "Magic.wand.use", true);
    }

    public boolean hasPermission(Player player, String pNode, boolean defaultValue) {
        String parentNode;
        boolean isParentSet;
        if (player == null) {
            return true;
        }
        if (pNode.contains(".") && (isParentSet = player.isPermissionSet(parentNode = pNode.substring(0, pNode.lastIndexOf(46) + 1) + "*"))) {
            defaultValue = player.hasPermission(parentNode);
        }
        boolean isSet = player.isPermissionSet(pNode);
        if (defaultValue) {
            return isSet ? player.hasPermission(pNode) : defaultValue;
        }
        return player.hasPermission(pNode);
    }

    public boolean hasPermission(Player player, String pNode) {
        return this.hasPermission(player, pNode, false);
    }

    public boolean hasPermission(CommandSender sender, String pNode) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode, false);
    }

    public boolean hasPermission(CommandSender sender, String pNode, boolean defaultValue) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode, defaultValue);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        ItemStack oldStack = event.getOldCursor();
        if (oldStack != null && oldStack.hasItemMeta()) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity expodingEntity = event.getEntity();
        if (this.maxTNTPerChunk > 0 && expodingEntity != null && expodingEntity.getType() == EntityType.PRIMED_TNT) {
            Entity[] entities;
            Chunk chunk = expodingEntity.getLocation().getChunk();
            if (chunk == null || !chunk.isLoaded()) {
                return;
            }
            int tntCount = 0;
            for (Entity entity : entities = chunk.getEntities()) {
                if (entity == null || entity.getType() != EntityType.PRIMED_TNT) continue;
                ++tntCount;
            }
            if (tntCount > this.maxTNTPerChunk) {
                event.setCancelled(true);
            }
        }
    }

    protected void onPlayerActivateIcon(Mage mage, Wand activeWand, ItemStack icon) {
        if (icon != null && icon.getType() != Material.AIR) {
            com.elmakers.mine.bukkit.api.spell.Spell spell = mage.getSpell(Wand.getSpell(icon));
            if (spell != null) {
                activeWand.saveInventory();
                activeWand.setActiveSpell(spell.getKey());
                mage.getPlayer().setItemInHand(activeWand.getItem());
            } else if (Wand.isBrush(icon)) {
                activeWand.saveInventory();
                activeWand.activateBrush(icon);
                mage.getPlayer().setItemInHand(activeWand.getItem());
            }
        } else {
            activeWand.setActiveSpell("");
        }
    }

    @EventHandler
    public void onPlayerEquip(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack next = inventory.getItem(event.getNewSlot());
        ItemStack previous = inventory.getItem(event.getPreviousSlot());
        Mage mage = this.getMage(player);
        Wand activeWand = mage.getActiveWand();
        if (activeWand != null && Wand.isWand(previous)) {
            if (activeWand.isInventoryOpen()) {
                this.onPlayerActivateIcon(mage, activeWand, next);
                event.setCancelled(true);
                return;
            }
            activeWand.deactivate();
        }
        if (next != null && Wand.isWand(next)) {
            Wand newWand = new Wand(this, next);
            newWand.activate(mage, next);
        }
        if ((activeWand = mage.getActiveWand()) == null && next != null && next.getType() == Material.MAP) {
            mage.setLastHeldMapId(next.getDurability());
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.getMage(player);
        final Wand activeWand = mage.getActiveWand();
        if (activeWand != null) {
            ItemStack inHand = event.getPlayer().getInventory().getItemInHand();
            if (Wand.isWand(event.getItemDrop().getItemStack()) && (inHand == null || inHand.getType() == Material.AIR)) {
                activeWand.deactivate();
                if (Wand.hasActiveWand(player)) {
                    player.setItemInHand(new ItemStack(Material.AIR, 1));
                }
            } else if (activeWand.isInventoryOpen()) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        activeWand.closeInventory();
                    }
                }, 1L);
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntityType() == EntityType.PLAYER && event.getEntity() instanceof Player) {
            this.onPlayerDeath((Player)event.getEntity(), event);
        }
    }

    protected void onPlayerDeath(final Player player, EntityDeathEvent event) {
        String rule = player.getWorld().getGameRuleValue("keepInventory");
        if (rule.equals("true")) {
            return;
        }
        Mage mage = this.getMage(player);
        List drops = event.getDrops();
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            if (mage.hasStoredInventory()) {
                ItemStack[] armor;
                drops.clear();
                ItemStack[] stored = mage.getStoredInventory().getContents();
                wand.deactivate();
                for (ItemStack stack : stored) {
                    if (stack == null) continue;
                    drops.add(stack);
                }
                for (ItemStack stack : armor = player.getInventory().getArmorContents()) {
                    if (stack == null) continue;
                    drops.add(stack);
                }
            } else {
                wand.deactivate();
            }
        }
        ArrayList oldDrops = new ArrayList(drops);
        final ArrayList<ItemStack> keepWands = new ArrayList<ItemStack>();
        drops.clear();
        for (ItemStack itemStack : oldDrops) {
            boolean keepItem = false;
            if (Wand.isWand(itemStack) && !(keepItem = this.keepWandsOnDeath)) {
                Wand testWand = new Wand(this, itemStack);
                keepItem = testWand.keepOnDeath();
            }
            if (keepItem) {
                keepWands.add(itemStack);
                continue;
            }
            drops.add(itemStack);
        }
        if (keepWands.size() > 0) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    for (ItemStack itemStack : keepWands) {
                        player.getInventory().addItem(new ItemStack[]{itemStack});
                    }
                }
            }, 5L);
        }
        mage.onPlayerDeath(event);
    }

    public void onPlayerDamage(Player player, EntityDamageEvent event) {
        Mage mage = this.getMage(player);
        mage.onPlayerDamage(event);
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Mage mage = this.getMage((Player)event.getEntity());
        mage.onPlayerCombust(event);
    }

    @EventHandler
    public void onItemDespawn(ItemDespawnEvent event) {
        if (Wand.isWand(event.getEntity().getItemStack())) {
            Wand wand = new Wand(this, event.getEntity().getItemStack());
            if (wand.isIndestructible()) {
                event.getEntity().setTicksLived(1);
                event.setCancelled(true);
            } else if (this.dynmapShowWands) {
                this.removeLostWand(wand);
            }
        }
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent event) {
        if (Wand.isWand(event.getEntity().getItemStack())) {
            Wand wand = new Wand(this, event.getEntity().getItemStack());
            if (wand != null && wand.isIndestructible()) {
                InventoryUtils.setInvulnerable((Entity)event.getEntity());
                this.addLostWand(wand, event.getEntity().getLocation());
                Location dropLocation = event.getLocation();
                this.getLogger().info("Wand " + wand.getName() + ", id " + wand.getId() + " spawned at " + dropLocation.getBlockX() + " " + dropLocation.getBlockY() + " " + dropLocation.getBlockZ());
            }
        } else if (this.ageDroppedItems > 0) {
            try {
                Class<?> itemClass = NMSUtils.getBukkitClass("net.minecraft.server.EntityItem");
                Item item = event.getEntity();
                Object handle = NMSUtils.getHandle((Entity)item);
                Field ageField = itemClass.getDeclaredField("age");
                ageField.setAccessible(true);
                int ticks = this.ageDroppedItems * 20 / 1000;
                ageField.set(handle, ticks);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        try {
            Item item;
            ItemStack itemStack;
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)event.getEntity();
                this.onPlayerDamage(player, event);
            }
            if (entity instanceof Item && Wand.isWand(itemStack = (item = (Item)entity).getItemStack())) {
                Wand wand = new Wand(this, item.getItemStack());
                if (wand.isIndestructible()) {
                    event.setCancelled(true);
                } else if (event.getDamage() >= (double)itemStack.getDurability() && this.removeLostWand(wand)) {
                    this.plugin.getLogger().info("Wand " + wand.getName() + ", id " + wand.getId() + " destroyed");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player;
        Mage mage;
        Wand wand;
        if (event.isCancelled()) {
            return;
        }
        if (event.getRightClicked().hasMetadata("NPC") && (wand = (mage = this.getMage(player = event.getPlayer())).getActiveWand()) != null) {
            wand.closeInventory();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean toggleInventory;
        Player player = event.getPlayer();
        Mage mage = this.getMage(player);
        if (!mage.checkLastClick(this.clickCooldown)) {
            return;
        }
        Wand wand = mage.getActiveWand();
        if (wand == null && Wand.hasActiveWand(player)) {
            if (mage.hasStoredInventory()) {
                mage.restoreInventory();
            }
            wand = Wand.getActiveWand(this, player);
            wand.activate(mage);
            this.getLogger().warning("Player was holding an inactive wand on interact- activating.");
        }
        if (wand == null && mage.hasStoredInventory()) {
            this.getLogger().warning("Player had no active wand, but a stored inventory- restoring.");
            mage.restoreInventory();
            return;
        }
        if (wand == null) {
            return;
        }
        if (!this.hasWandPermission(player)) {
            if (this.hasPermission(player, "Magic.wand.destruct", false)) {
                wand.deactivate();
                PlayerInventory inventory = player.getInventory();
                ItemStack[] items = inventory.getContents();
                for (int i = 0; i < items.length; ++i) {
                    ItemStack item = items[i];
                    if (!Wand.isWand(item) && !Wand.isSpell(item) && !Wand.isBrush(item)) continue;
                    items[i] = null;
                }
                inventory.setContents(items);
                mage.sendMessage(Messages.get("wand.self_destruct"));
            }
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK && !wand.isUpgrade()) {
            wand.cast();
            return;
        }
        boolean bl = toggleInventory = event.getAction() == Action.RIGHT_CLICK_AIR;
        if (!toggleInventory && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Material material = event.getClickedBlock().getType();
            boolean bl2 = toggleInventory = material != Material.CHEST && material != Material.WOODEN_DOOR && material != Material.IRON_DOOR_BLOCK && material != Material.ENDER_CHEST && material != Material.ANVIL && material != Material.BREWING_STAND && material != Material.ENCHANTMENT_TABLE && material != Material.STONE_BUTTON && material != Material.LEVER && material != Material.FURNACE && material != Material.BED && material != Material.SIGN_POST && material != Material.COMMAND && material != Material.WALL_SIGN;
            if (material == Material.SIGN_POST || material == Material.WALL_SIGN) {
                wand.closeInventory();
            }
        }
        if (toggleInventory) {
            if (!mage.cancel()) {
                if (wand.getMode() == WandMode.CYCLE) {
                    if (player.isSneaking()) {
                        com.elmakers.mine.bukkit.api.spell.Spell activeSpell = wand.getActiveSpell();
                        boolean cycleMaterials = false;
                        if (activeSpell != null && activeSpell instanceof BrushSpell) {
                            BrushSpell brushSpell = (BrushSpell)activeSpell;
                            boolean bl3 = cycleMaterials = brushSpell.hasBrushOverride() && wand.getBrushes().size() > 0;
                        }
                        if (cycleMaterials) {
                            wand.cycleMaterials(player.getItemInHand());
                        } else {
                            wand.cycleSpells(player.getItemInHand());
                        }
                    } else {
                        wand.cycleSpells(player.getItemInHand());
                    }
                } else {
                    wand.toggleInventory();
                }
            } else {
                mage.playSound(Sound.NOTE_BASS, 1.0f, 0.7f);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.getMage(player);
        Wand wand = Wand.getActiveWand(this, player);
        if (wand != null) {
            wand.activate(mage);
        } else if (mage.isNewPlayer() && this.welcomeWand.length() > 0) {
            wand = Wand.createWand(this, this.welcomeWand);
            if (wand != null) {
                this.plugin.giveItemToPlayer(player, wand.getItem());
                this.getLogger().info("Gave welcome wand " + wand.getName() + " to " + player.getName());
            } else {
                this.getLogger().warning("Unable to give welcome wand '" + this.welcomeWand + "' to " + player.getName());
            }
        }
    }

    @EventHandler
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        if (event.getAmount() <= 0) {
            return;
        }
        Player player = event.getPlayer();
        Mage mage = this.getMage(player);
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            wand.onPlayerExpChange(event);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        URLMap.resend(player.getName());
        Mage mage = this.getMage(player);
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            wand.deactivate();
        }
        mage.restoreInventory();
        mage.onPlayerQuit(event);
        UndoQueue undoQueue = mage.getUndoQueue();
        if (this.commitOnQuit && undoQueue != null && !undoQueue.isEmpty()) {
            this.getLogger().info("Player logged out, committing constructions: " + mage.getName());
            undoQueue.commit();
            undoQueue.undoScheduled(mage);
        }
        try {
            File playerData = new File(this.playerDataFolder, player.getUniqueId().toString() + ".dat");
            this.getLogger().info("Player logged out, saving data to " + playerData.getName());
            DataStore playerConfig = new DataStore(this.getLogger(), playerData);
            mage.save((ConfigurationSection)playerConfig);
            playerConfig.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (undoQueue == null || undoQueue.isEmpty()) {
            this.getLogger().info("Player has no pending undo actions, forgetting: " + mage.getName());
            this.mages.remove(player.getUniqueId().toString());
        }
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        for (Mage mage : this.mages.values()) {
            Player player = mage.getPlayer();
            if (player == null) continue;
            Wand wand = mage.getActiveWand();
            if (wand != null) {
                wand.deactivate();
            }
            mage.restoreInventory();
            player.updateInventory();
        }
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        Player[] players;
        for (Player player : players = this.plugin.getServer().getOnlinePlayers()) {
            Wand wand = Wand.getActiveWand(this, player);
            if (wand == null) continue;
            Mage mage = this.getMage(player);
            wand.activate(mage);
            player.updateInventory();
        }
        if (this.wandRecipe != null) {
            this.plugin.getServer().addRecipe(this.wandRecipe);
        }
    }

    @EventHandler
    public void onPrepareCraftItem(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (this.craftingEnabled && this.wandRecipe != null && recipe.getResult().getType() == Wand.DefaultWandMaterial) {
            Wand defaultWand;
            CraftingInventory inventory = event.getInventory();
            if (!inventory.contains(this.wandRecipeLowerMaterial) || !inventory.contains(this.wandRecipeUpperMaterial)) {
                return;
            }
            Wand wand = defaultWand = Wand.createWand(this, null);
            if (this.recipeOutputTemplate != null && this.recipeOutputTemplate.length() > 0) {
                Wand templateWand = Wand.createWand(this, this.recipeOutputTemplate);
                templateWand.add(defaultWand);
                wand = templateWand;
            }
            event.getInventory().setResult(wand.getItem());
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Mage mage = this.getMage(player);
        if (mage.hasStoredInventory()) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Mage mage = this.getMage(player);
        Wand wand = mage.getActiveWand();
        if (!(wand == null || event.getView().getType() == InventoryType.CRAFTING || wand.getMode() != WandMode.INVENTORY && wand.isInventoryOpen())) {
            wand.deactivate();
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Mage mage = this.getMage(player);
        Wand activeWand = mage.getActiveWand();
        InventoryType inventoryType = event.getInventory().getType();
        InventoryType.SlotType slotType = event.getSlotType();
        if (slotType == InventoryType.SlotType.CRAFTING && (inventoryType == InventoryType.CRAFTING || inventoryType == InventoryType.WORKBENCH) && Wand.isWand(event.getCursor())) {
            event.setCancelled(true);
            return;
        }
        if (event.getAction() == InventoryAction.DROP_ONE_SLOT && activeWand != null && activeWand.isInventoryOpen()) {
            event.setCancelled(true);
            return;
        }
        if (this.enchantingEnabled && inventoryType == InventoryType.ENCHANTING && slotType == InventoryType.SlotType.CRAFTING) {
            Wand wand;
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            if (Wand.isWand(cursor) && (wand = new Wand(this, cursor)).isModifiable()) {
                wand.makeEnchantable(true);
            }
            if (Wand.isWand(current) && (wand = new Wand(this, current)).isModifiable()) {
                wand.makeEnchantable(false);
            }
            return;
        }
        if (inventoryType == InventoryType.ANVIL) {
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            Inventory anvilInventory = event.getInventory();
            if (slotType == InventoryType.SlotType.CRAFTING) {
                Wand wand;
                if (Wand.isWand(cursor)) {
                    wand = new Wand(this, cursor);
                    wand.updateName(false);
                }
                if (Wand.isWand(current)) {
                    wand = new Wand(this, current);
                    wand.setDescription("");
                    wand.updateName(true);
                    if (event.getWhoClicked() instanceof Player) {
                        wand.tryToOwn((Player)event.getWhoClicked());
                    }
                }
                return;
            }
            if (slotType == InventoryType.SlotType.RESULT && Wand.isWand(current)) {
                ItemMeta meta = current.getItemMeta();
                String newName = meta.getDisplayName();
                Wand wand = new Wand(this, current);
                if (!wand.canUse(player)) {
                    event.setCancelled(true);
                    mage.sendMessage(Messages.get("wand.bound").replace("$name", wand.getOwner()));
                    return;
                }
                wand.setName(newName);
                if (this.organizingEnabled) {
                    wand.organizeInventory(this.getMage(player));
                }
                wand.tryToOwn(player);
                return;
            }
            if (this.combiningEnabled && slotType == InventoryType.SlotType.RESULT) {
                ItemStack firstItem = anvilInventory.getItem(0);
                ItemStack secondItem = anvilInventory.getItem(1);
                if (Wand.isWand(firstItem) && Wand.isWand(secondItem)) {
                    Wand firstWand = new Wand(this, firstItem);
                    Wand secondWand = new Wand(this, secondItem);
                    if (!firstWand.isModifiable() || !secondWand.isModifiable()) {
                        mage.sendMessage("One of your wands can not be combined");
                        return;
                    }
                    if (!firstWand.canUse(player) || !secondWand.canUse(player)) {
                        mage.sendMessage("One of those wands is not bound to you");
                        return;
                    }
                    firstWand.add(secondWand);
                    anvilInventory.setItem(0, null);
                    anvilInventory.setItem(1, null);
                    cursor.setType(Material.AIR);
                    if (this.organizingEnabled) {
                        firstWand.organizeInventory(mage);
                    }
                    firstWand.tryToOwn(player);
                    player.getInventory().addItem(new ItemStack[]{firstWand.getItem()});
                    mage.sendMessage("Your wands have been combined!");
                } else if (this.organizingEnabled && Wand.isWand(firstItem)) {
                    Wand firstWand = new Wand(this, firstItem);
                    anvilInventory.setItem(0, null);
                    anvilInventory.setItem(1, null);
                    cursor.setType(Material.AIR);
                    firstWand.organizeInventory(mage);
                    firstWand.tryToOwn(player);
                    player.getInventory().addItem(new ItemStack[]{firstWand.getItem()});
                    mage.sendMessage("Your wand has been organized!");
                }
                return;
            }
        }
        if (activeWand != null) {
            WandMode wandMode = activeWand.getMode();
            if ((wandMode == WandMode.INVENTORY && inventoryType == InventoryType.CRAFTING || wandMode == WandMode.CHEST && inventoryType == InventoryType.CHEST) && activeWand != null && activeWand.isInventoryOpen()) {
                if (event.getAction() == InventoryAction.PICKUP_HALF || event.getAction() == InventoryAction.NOTHING) {
                    activeWand.cycleInventory();
                    event.setCancelled(true);
                    return;
                }
                if (event.getSlotType() == InventoryType.SlotType.ARMOR) {
                    event.setCancelled(true);
                    return;
                }
                if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY || wandMode == WandMode.CHEST) {
                    ItemStack clickedItem = event.getCurrentItem();
                    this.onPlayerActivateIcon(mage, activeWand, clickedItem);
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                if (Wand.isWand(event.getCursor()) || Wand.isWand(event.getCurrentItem())) {
                    event.setCancelled(true);
                }
            }
            return;
        }
    }

    @EventHandler
    public void onInventoryClosed(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Mage mage = this.getMage(player);
        Wand previousWand = mage.getActiveWand();
        if (previousWand != null && previousWand.isInventoryOpen()) {
            if (previousWand.getMode() == WandMode.INVENTORY) {
                previousWand.saveInventory();
            } else if (previousWand.getMode() == WandMode.CHEST) {
                previousWand.closeInventory();
                return;
            }
        }
        Wand wand = Wand.getActiveWand(this, player);
        boolean changedWands = false;
        if (previousWand != null && wand == null) {
            changedWands = true;
        }
        if (previousWand == null && wand != null) {
            changedWands = true;
        }
        if (previousWand != null && wand != null && !previousWand.equals(wand)) {
            changedWands = true;
        }
        if (changedWands) {
            if (previousWand != null) {
                previousWand.deactivate();
            }
            if (wand != null) {
                wand.activate(mage);
            }
        }
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        if (event.getNewGameMode() == GameMode.CREATIVE) {
            boolean ejected = false;
            Player player = event.getPlayer();
            Mage mage = this.getMage(player);
            Wand activeWand = mage.getActiveWand();
            if (activeWand != null) {
                activeWand.deactivate();
            }
            PlayerInventory inventory = player.getInventory();
            ItemStack[] contents = inventory.getContents();
            for (int i = 0; i < contents.length; ++i) {
                ItemStack item = contents[i];
                if (!Wand.isWand(item)) continue;
                ejected = true;
                inventory.setItem(i, null);
                player.getWorld().dropItemNaturally(player.getLocation(), item);
            }
            if (ejected) {
                mage.sendMessage("Ejecting wands, creative mode will destroy them!");
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Wand activeWand;
        if (event.isCancelled()) {
            return;
        }
        Mage mage = this.getMage(event.getPlayer());
        ItemStack pickup = event.getItem().getItemStack();
        boolean isWand = Wand.isWand(pickup);
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE && isWand) {
            event.setCancelled(true);
            return;
        }
        if (this.dynmapShowWands && isWand) {
            Wand wand = new Wand(this, pickup);
            this.plugin.getLogger().info("Player " + mage.getName() + " picked up wand " + wand.getName() + ", id " + wand.getId());
            this.removeLostWand(wand);
        }
        if ((activeWand = mage.getActiveWand()) != null && !Wand.isWand(pickup) && activeWand.isModifiable() && activeWand.addItem(pickup)) {
            event.getItem().remove();
            event.setCancelled(true);
            return;
        }
        if (mage.hasStoredInventory()) {
            event.setCancelled(true);
            if (mage.addToStoredInventory(event.getItem().getItemStack())) {
                event.getItem().remove();
            }
        } else {
            PlayerInventory inventory = event.getPlayer().getInventory();
            ItemStack inHand = inventory.getItemInHand();
            if (Wand.isWand(pickup) && (inHand == null || inHand.getType() == Material.AIR)) {
                Wand wand = new Wand(this, pickup);
                event.setCancelled(true);
                event.getItem().remove();
                inventory.setItem(inventory.getHeldItemSlot(), pickup);
                wand.activate(mage);
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.getMage(player);
        if (mage.hasStoredInventory() || mage.getBlockPlaceTimeout() > System.currentTimeMillis()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        if (this.enchantingEnabled && Wand.isWand(event.getItem())) {
            event.getEnchantsToAdd().clear();
            int level = event.getExpLevelCost();
            Wand wand = new Wand(this, event.getItem());
            if (!WandLevel.randomizeWand(wand, true, level)) {
                event.getEnchanter().sendMessage("This wand is fully enchanted (for now)");
            }
            wand.makeEnchantable(true);
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onPrepareEnchantItem(PrepareItemEnchantEvent event) {
        if (this.enchantingEnabled && Wand.isWand(event.getItem())) {
            Wand wandItem = new Wand(this, event.getItem());
            Player player = event.getEnchanter();
            if (!wandItem.isModifiable()) {
                event.setCancelled(true);
                return;
            }
            if (!wandItem.canUse(player)) {
                event.setCancelled(true);
                return;
            }
            wandItem.makeEnchantable(true);
            Set<Integer> levelSet = WandLevel.getLevels();
            ArrayList<Integer> levels = new ArrayList<Integer>();
            levels.addAll(levelSet);
            int[] offered = event.getExpLevelCostsOffered();
            int bonusLevels = event.getEnchantmentBonus();
            int maxLevel = (Integer)levels.get(levels.size() - 1) - 20 + bonusLevels;
            for (int i = 0; i < offered.length - 1; ++i) {
                int levelIndex = (int)((float)i * (float)levels.size() / (float)offered.length);
                levelIndex = (int)((float)levelIndex + (float)bonusLevels * (float)((i + 1) / offered.length));
                levelIndex = Math.min(levelIndex, levels.size() - 1);
                offered[i] = (Integer)levels.get(levelIndex);
            }
            offered[offered.length - 1] = maxLevel;
            event.setCancelled(false);
        }
    }

    protected boolean addLostWandMarker(LostWand lostWand) {
        Location location = lostWand.getLocation();
        return this.addMarker("wand-" + lostWand.getId(), "Wands", lostWand.getName(), location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), lostWand.getDescription());
    }

    protected void checkForWands(final Chunk chunk, final int retries) {
        if (this.dynmapShowWands && this.dynmap != null) {
            if (!this.dynmap.isReady()) {
                if (retries > 0) {
                    final MagicController me = this;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            me.checkForWands(chunk, retries + 1);
                        }
                    }, 10L);
                }
                return;
            }
            Entity[] entities = chunk.getEntities();
            HashSet<String> presentWandIds = new HashSet<String>();
            for (Entity entity : entities) {
                Item item;
                ItemStack itemStack;
                if (!(entity instanceof Item) || !Wand.isWand(itemStack = (item = (Item)entity).getItemStack())) continue;
                Wand wand = new Wand(this, itemStack);
                this.addLostWand(wand, item.getLocation());
                presentWandIds.add(wand.getId());
            }
            String chunkKey = this.getChunkKey(chunk);
            Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
            if (chunkWands != null) {
                ArrayList<String> iterateWands = new ArrayList<String>(chunkWands);
                for (String wandId : iterateWands) {
                    if (presentWandIds.contains(wandId)) continue;
                    LostWand lostWand = this.lostWands.get(wandId);
                    String name = null;
                    String owner = null;
                    if (lostWand != null) {
                        name = lostWand.getName();
                        owner = lostWand.getOwner();
                    }
                    name = name == null ? "(Unknown)" : name;
                    owner = owner == null ? "(Unknown)" : owner;
                    this.plugin.getLogger().info("Wand " + wandId + ": " + name + "@" + owner + ", not found in chunk, presumed lost");
                    this.removeLostWand(wandId);
                }
            }
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent e) {
        final MagicController me = this;
        final ChunkLoadEvent event = e;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                me.checkForWands(event.getChunk(), 10);
            }
        }, 5L);
        this.triggerBlockToggle(e.getChunk());
    }

    public Spell getSpell(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        return this.spells.get(name);
    }

    public void toggleCastCommandOverrides(Mage mage, boolean override) {
        mage.setCostReduction(override ? this.castCommandCostReduction : 0.0f);
        mage.setCooldownReduction(override ? this.castCommandCooldownReduction : 0.0f);
        mage.setPowerMultiplier(override ? this.castCommandPowerMultiplier : 1.0f);
    }

    public float getCooldownReduction() {
        return this.cooldownReduction;
    }

    public float getCostReduction() {
        return this.costReduction;
    }

    public boolean sendMail(CommandSender sender, String fromPlayer, String toPlayer, String message) {
        if (this.mailer != null) {
            return this.mailer.sendMail(sender, fromPlayer, toPlayer, message);
        }
        return false;
    }

    public Material getDefaultMaterial() {
        return this.defaultMaterial;
    }

    public Collection<LostWand> getLostWands() {
        return this.lostWands.values();
    }

    public Collection<Automaton> getAutomata() {
        ArrayList<Automaton> all = new ArrayList<Automaton>();
        for (Map<Long, Automaton> chunkList : this.automata.values()) {
            all.addAll(chunkList.values());
        }
        return all;
    }

    public boolean cast(Mage mage, String spellName, String[] parameters, CommandSender sender, Player player) {
        Spell spell;
        Player usePermissions = sender == player ? player : (sender instanceof Player ? (Player)sender : null);
        Location targetLocation = null;
        if (mage == null) {
            CommandSender mageController;
            Object object = mageController = player == null ? sender : player;
            if (sender instanceof BlockCommandSender) {
                targetLocation = ((BlockCommandSender)sender).getBlock().getLocation();
            }
            if (sender instanceof Player) {
                targetLocation = player.getLocation();
            }
            mage = this.getMage(mageController);
        }
        if ((spell = mage.getSpell(spellName, usePermissions)) == null) {
            if (sender != null) {
                sender.sendMessage("Spell " + spellName + " unknown");
            }
            return false;
        }
        this.toggleCastCommandOverrides(mage, true);
        spell.cast(parameters, targetLocation);
        this.toggleCastCommandOverrides(mage, false);
        if (sender != player && sender != null) {
            String castMessage = "Cast " + spellName;
            if (player != null) {
                castMessage = castMessage + " on " + player.getName();
            }
            sender.sendMessage(castMessage);
        }
        return true;
    }

    public void onCast(Mage mage, Spell spell, SpellResult result) {
        if (this.dynmapShowSpells && this.dynmap != null) {
            this.dynmap.showCastMarker(mage, spell, result);
        }
    }

    public void registerBlockForReloadToggle(Block block, String name, String message) {
        String chunkId = this.getChunkKey(block.getChunk());
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload == null) {
            toReload = new HashMap<Long, Automaton>();
            this.automata.put(chunkId, toReload);
        }
        Automaton data = new Automaton(block, name, message);
        toReload.put(data.getId(), data);
    }

    public void unregisterBlockForReloadToggle(Block block) {
        String chunkId = this.getChunkKey(block.getChunk());
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload != null) {
            toReload.remove(BlockData.getBlockId(block));
        }
    }

    protected void triggerBlockToggle(Chunk chunk) {
        String chunkKey = this.getChunkKey(chunk);
        Map<Long, Automaton> chunkData = this.automata.get(chunkKey);
        if (chunkData != null) {
            final ArrayList<Automaton> restored = new ArrayList<Automaton>();
            ArrayList<Long> blockKeys = new ArrayList<Long>(chunkData.keySet());
            long timeThreshold = System.currentTimeMillis() - (long)this.toggleCooldown;
            for (Long blockKey : blockKeys) {
                Automaton toggleBlock = chunkData.get(blockKey);
                if (toggleBlock.getCreatedTime() >= timeThreshold) continue;
                Block current = toggleBlock.getBlock();
                if (current.getType() == toggleBlock.getMaterial()) {
                    current.setType(Material.AIR);
                    restored.add(toggleBlock);
                }
                chunkData.remove(blockKey);
            }
            if (restored.size() > 0) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        for (Automaton restoreBlock : restored) {
                            MagicController.this.getLogger().info("Resuming block at " + restoreBlock.getLocation() + ": " + restoreBlock.getName());
                            restoreBlock.restore();
                            MagicController.this.sendToMages(restoreBlock.getMessage(), restoreBlock.getLocation().toLocation(restoreBlock.getWorld()));
                        }
                    }
                }, 5L);
            }
            if (chunkData.size() == 0) {
                this.automata.remove(chunkKey);
            }
        }
    }

    public void sendToMages(String message, Location location) {
        this.sendToMages(message, location, this.toggleMessageRange);
    }

    public void sendToMages(String message, Location location, int range) {
        int rangeSquared = range * range;
        if (message != null && message.length() > 0) {
            for (Mage mage : this.mages.values()) {
                if (!mage.isPlayer() || mage.isDead() || !mage.isOnline() || !mage.hasLocation() || !mage.getLocation().getWorld().equals(location.getWorld()) || !(mage.getLocation().toVector().distanceSquared(location.toVector()) < (double)rangeSquared)) continue;
                mage.sendMessage(message);
            }
        }
    }

    public boolean getIndestructibleWands() {
        return this.indestructibleWands;
    }

    public Location getWarp(String warpName) {
        if (this.warpController == null) {
            return null;
        }
        return this.warpController.getWarp(warpName);
    }

    public void forgetMage(Mage mage) {
        this.forgetMages.add(mage.getId());
    }
}

