/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effects;

import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class EffectUtils
extends NMSUtils {
    public static void spawnFireworkEffect(Location location, FireworkEffect effect, int power) {
        World world = location.getWorld();
        try {
            Firework firework = (Firework)world.spawn(location, Firework.class);
            FireworkMeta meta = firework.getFireworkMeta();
            meta.addEffect(effect);
            meta.setPower(power);
            firework.setFireworkMeta(meta);
            Object worldHandle = EffectUtils.getHandle(world);
            Object fireworkHandle = EffectUtils.getHandle((Entity)firework);
            Method broadcastMethod = class_World.getMethod("broadcastEntityEffect", class_Entity, Byte.TYPE);
            broadcastMethod.invoke(worldHandle, fireworkHandle, (byte)17);
            firework.remove();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void playEffect(Location location, ParticleType particleType, float xOffset, float yOffset, float zOffset, float effectSpeed, int particleCount) {
        EffectUtils.playEffect(location, particleType, "", xOffset, yOffset, zOffset, effectSpeed, particleCount);
    }

    public static void playEffect(Location location, ParticleType particleType, float effectSpeed, int particleCount) {
        EffectUtils.playEffect(location, particleType, "", 0.0f, 0.0f, 0.0f, effectSpeed, particleCount);
    }

    public static void playEffect(Location location, ParticleType particleType, String subtype, float xOffset, float yOffset, float zOffset, float effectSpeed, int particleCount) {
        try {
            Constructor packetConstructor;
            Object packet = null;
            if (class_PacketPlayOutWorldParticles != null) {
                packetConstructor = class_PacketPlayOutWorldParticles.getConstructor(new Class[0]);
                packet = packetConstructor.newInstance(new Object[0]);
            } else {
                packetConstructor = class_Packet63WorldParticles.getConstructor(new Class[0]);
                packet = packetConstructor.newInstance(new Object[0]);
            }
            for (Field field : packet.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                if (fieldName.equals("a")) {
                    field.set(packet, particleType.getParticleName(subtype));
                    continue;
                }
                if (fieldName.equals("b")) {
                    field.setFloat(packet, (float)location.getX());
                    continue;
                }
                if (fieldName.equals("c")) {
                    field.setFloat(packet, (float)location.getY());
                    continue;
                }
                if (fieldName.equals("d")) {
                    field.setFloat(packet, (float)location.getZ());
                    continue;
                }
                if (fieldName.equals("e")) {
                    field.setFloat(packet, xOffset);
                    continue;
                }
                if (fieldName.equals("f")) {
                    field.setFloat(packet, yOffset);
                    continue;
                }
                if (fieldName.equals("g")) {
                    field.setFloat(packet, zOffset);
                    continue;
                }
                if (fieldName.equals("h")) {
                    field.setFloat(packet, effectSpeed);
                    continue;
                }
                if (!fieldName.equals("i")) continue;
                field.setInt(packet, particleCount);
            }
            EffectUtils.sendPacket(location, null, packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

