/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.VolumeBatch;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.spell.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import com.elmakers.mine.bukkit.utilities.Messages;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SimulateBatch
extends VolumeBatch {
    private static BlockFace[] NEIGHBOR_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private static BlockFace[] DIAGONAL_FACES = new BlockFace[]{BlockFace.SOUTH_EAST, BlockFace.NORTH_EAST, BlockFace.SOUTH_WEST, BlockFace.NORTH_WEST};
    private static BlockFace[] MAIN_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST};
    private static BlockFace[] POWER_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH, BlockFace.DOWN, BlockFace.UP};
    public static Material POWER_MATERIAL = Material.REDSTONE_BLOCK;
    public static int POWER_DELAY_TICKS = 0;
    public static boolean DEBUG = false;
    private Mage mage;
    private BlockSpell spell;
    private Block castCommandBlock;
    private Block commandTargetBlock;
    private TargetMode targetMode = TargetMode.STABILIZE;
    private TargetType targetType = TargetType.PLAYER;
    private Location targetLocation;
    private String castCommand;
    private String commandName;
    private String tickSpell;
    private String deathSpell;
    private float castProbability;
    private String dropItem;
    private int dropXp;
    private boolean reverseTargetDistanceScore = false;
    private boolean concurrent = false;
    private int commandMoveRangeSquared = 9;
    private int huntMaxRange = 128;
    private int huntMinRange = 4;
    private int birthRangeSquared = 0;
    private int liveRangeSquared = 0;
    private float huntFov = 3.0f;
    private boolean commandReload;
    private boolean commandPowered;
    private World world;
    private MaterialAndData birthMaterial;
    private Material deathMaterial;
    private MaterialAndData powerSimMaterialBackup;
    private MaterialAndData powerSimMaterial;
    private boolean includeCommands;
    private int radius;
    private int x;
    private int y;
    private int z;
    private int r;
    private int yRadius;
    private int updatingIndex;
    private int powerDelayTicks;
    private ArrayList<Boolean> liveCounts = new ArrayList();
    private ArrayList<Boolean> birthCounts = new ArrayList();
    private ArrayList<Boolean> diagonalLiveCounts = new ArrayList();
    private ArrayList<Boolean> diagonalBirthCounts = new ArrayList();
    private SimulationState state;
    private Location center;
    private List<Block> deadBlocks = new ArrayList<Block>();
    private List<Block> bornBlocks = new ArrayList<Block>();
    private List<Target> potentialCommandBlocks = new LinkedList<Target>();
    private BlockList modifiedBlocks = new BlockList();

    public SimulateBatch(BlockSpell spell, Location center, int radius, int yRadius, MaterialAndData birth, Material death, Set<Integer> liveCounts, Set<Integer> birthCounts) {
        super(spell.getMage().getController(), center.getWorld().getName());
        this.spell = spell;
        this.mage = spell.getMage();
        this.yRadius = yRadius;
        this.radius = radius;
        this.center = center.clone();
        this.targetLocation = center.clone();
        this.birthMaterial = birth;
        this.deathMaterial = death;
        this.powerSimMaterial = this.birthMaterial;
        this.powerSimMaterialBackup = new MaterialAndData(this.deathMaterial);
        this.mapIntegers(liveCounts, this.liveCounts);
        this.mapIntegers(birthCounts, this.birthCounts);
        this.world = center.getWorld();
        this.includeCommands = false;
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.r = 0;
        this.state = SimulationState.SCANNING_COMMAND;
        this.updatingIndex = 0;
    }

    @Override
    public int size() {
        return this.modifiedBlocks.size();
    }

    @Override
    public int remaining() {
        return (this.radius - this.x) * (this.radius - this.z) * (this.radius - this.y) * 8;
    }

    protected void checkForPotentialCommand(Block block, int distanceSquared) {
        if (this.includeCommands && distanceSquared <= this.commandMoveRangeSquared) {
            this.potentialCommandBlocks.add(new Target(this.targetLocation, block, this.huntMinRange, this.huntMaxRange, (double)this.huntFov, this.reverseTargetDistanceScore));
        }
    }

    protected void die() {
        Entity entity;
        Wand magicItem;
        String message = this.spell.getMessage("death_broadcast").replace("$name", this.commandName);
        if (message.length() > 0) {
            this.controller.sendToMages(message, this.center);
        }
        if (this.castCommandBlock == null) {
            this.castCommandBlock = this.center.getBlock();
        }
        for (BlockFace powerFace : POWER_FACES) {
            Block checkForPower = this.castCommandBlock.getRelative(powerFace);
            if (checkForPower.getType() != POWER_MATERIAL) continue;
            if (this.commandReload) {
                this.controller.unregisterBlockForReloadToggle(checkForPower);
            }
            this.powerSimMaterial.modify(checkForPower);
        }
        if (this.dropItem != null && this.dropItem.length() > 0 && (magicItem = Wand.createWand(this.controller, this.dropItem)) != null) {
            this.center.getWorld().dropItemNaturally(this.center, magicItem.getItem());
        }
        if (this.dropXp > 0 && (entity = this.center.getWorld().spawnEntity(this.center, EntityType.EXPERIENCE_ORB)) != null && entity instanceof ExperienceOrb) {
            ExperienceOrb orb = (ExperienceOrb)entity;
            orb.setExperience(this.dropXp);
        }
        if (this.deathSpell.length() > 0) {
            Spell spell;
            String[] defaultParameters;
            String spellName = this.deathSpell;
            String[] parameters = defaultParameters = new String[]{"cost_reduction", "1", "destructible", "air," + this.birthMaterial.getMaterial().name().toLowerCase(), "target", "self"};
            String[] pieces = StringUtils.split((String)this.deathSpell, (String)" ");
            if (pieces != null && pieces.length > 1) {
                int i;
                spellName = pieces[0];
                parameters = new String[defaultParameters.length + pieces.length - 1];
                for (i = 0; i < defaultParameters.length; ++i) {
                    parameters[i] = defaultParameters[i];
                }
                for (i = 1; i < pieces.length; ++i) {
                    parameters[i + defaultParameters.length - 1] = pieces[i];
                }
            }
            if ((spell = this.mage.getSpell(spellName)) != null) {
                if (DEBUG) {
                    this.controller.getLogger().info(this.commandName + " casting " + this.tickSpell + " on death");
                }
                spell.cast(parameters);
            }
        }
        if (this.includeCommands && this.castCommandBlock != null && this.castCommandBlock.getType() == Material.COMMAND) {
            this.castCommandBlock.setType(Material.AIR);
        }
        if (!this.mage.isPlayer()) {
            this.controller.forgetMage(this.mage);
        }
    }

    protected void killBlock(Block block) {
        if (this.concurrent) {
            this.modifiedBlocks.add(block);
            block.setType(this.deathMaterial);
            this.controller.updateBlock(block);
        } else {
            this.deadBlocks.add(block);
        }
    }

    protected void birthBlock(Block block) {
        if (this.concurrent) {
            this.modifiedBlocks.add(block);
            this.birthMaterial.modify(block);
            this.controller.updateBlock(block);
        } else {
            this.bornBlocks.add(block);
        }
    }

    protected boolean simulateBlock(int dx, int dy, int dz) {
        CommandBlock commandBlock;
        BlockState commandData;
        int z;
        int y;
        int x = this.center.getBlockX() + dx;
        Block block = this.world.getBlockAt(x, y = this.center.getBlockY() + dy, z = this.center.getBlockZ() + dz);
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load();
            return false;
        }
        Material blockMaterial = block.getType();
        if (this.birthMaterial.is(block)) {
            int distanceSquared;
            int n = distanceSquared = this.liveRangeSquared > 0 || this.includeCommands ? (int)Math.ceil(block.getLocation().distanceSquared(this.castCommandBlock.getLocation())) : 0;
            if (this.liveRangeSquared <= 0 || distanceSquared <= this.liveRangeSquared) {
                if (this.diagonalLiveCounts.size() > 0) {
                    int faceNeighborCount = this.getNeighborCount(block, this.birthMaterial, this.includeCommands, MAIN_FACES, true, true);
                    int diagonalNeighborCount = this.getNeighborCount(block, this.birthMaterial, this.includeCommands, DIAGONAL_FACES, false, false);
                    if (faceNeighborCount >= this.liveCounts.size() || !this.liveCounts.get(faceNeighborCount).booleanValue() || diagonalNeighborCount >= this.diagonalLiveCounts.size() || !this.diagonalLiveCounts.get(diagonalNeighborCount).booleanValue()) {
                        this.killBlock(block);
                    } else {
                        this.checkForPotentialCommand(block, distanceSquared);
                    }
                } else {
                    int neighborCount = this.getNeighborCount(block, this.birthMaterial, this.includeCommands);
                    if (neighborCount >= this.liveCounts.size() || !this.liveCounts.get(neighborCount).booleanValue()) {
                        this.killBlock(block);
                    } else {
                        this.checkForPotentialCommand(block, distanceSquared);
                    }
                }
            } else {
                this.killBlock(block);
            }
        } else if (blockMaterial == this.deathMaterial) {
            int distanceSquared;
            int n = distanceSquared = this.birthRangeSquared > 0 || this.includeCommands ? (int)Math.ceil(block.getLocation().distanceSquared(this.castCommandBlock.getLocation())) : 0;
            if (this.birthRangeSquared <= 0 || distanceSquared <= this.birthRangeSquared) {
                if (this.diagonalBirthCounts.size() > 0) {
                    int faceNeighborCount = this.getNeighborCount(block, this.birthMaterial, this.includeCommands, MAIN_FACES, true, true);
                    int diagonalNeighborCount = this.getNeighborCount(block, this.birthMaterial, this.includeCommands, DIAGONAL_FACES, false, false);
                    if (faceNeighborCount < this.birthCounts.size() && this.birthCounts.get(faceNeighborCount).booleanValue() && diagonalNeighborCount < this.diagonalBirthCounts.size() && this.diagonalBirthCounts.get(diagonalNeighborCount).booleanValue()) {
                        this.birthBlock(block);
                        this.checkForPotentialCommand(block, distanceSquared);
                    }
                } else {
                    int neighborCount = this.getNeighborCount(block, this.birthMaterial, this.includeCommands);
                    if (neighborCount < this.birthCounts.size() && this.birthCounts.get(neighborCount).booleanValue()) {
                        this.birthBlock(block);
                        this.checkForPotentialCommand(block, distanceSquared);
                    }
                }
            }
        } else if (this.includeCommands && blockMaterial == Material.COMMAND && this.commandName != null && this.commandName.length() > 1 && (commandData = block.getState()) != null && commandData instanceof CommandBlock && (commandBlock = (CommandBlock)commandData).getName().equals(this.commandName)) {
            block.setType(this.deathMaterial);
            if (DEBUG) {
                this.controller.getLogger().info("CONSUMED clone at " + block.getLocation().toVector());
            }
        }
        return true;
    }

    protected boolean simulateBlocks(int x, int y, int z) {
        boolean success = true;
        if (y != 0) {
            boolean bl = success = success && this.simulateBlock(x, -y, z);
            if (x != 0) {
                boolean bl2 = success = success && this.simulateBlock(-x, -y, z);
            }
            if (z != 0) {
                boolean bl3 = success = success && this.simulateBlock(x, -y, -z);
            }
            if (x != 0 && z != 0) {
                success = success && this.simulateBlock(-x, -y, -z);
            }
        }
        boolean bl = success = success && this.simulateBlock(x, y, z);
        if (x != 0) {
            boolean bl4 = success = success && this.simulateBlock(-x, y, z);
        }
        if (z != 0) {
            boolean bl5 = success = success && this.simulateBlock(x, y, -z);
        }
        if (z != 0 && x != 0) {
            success = success && this.simulateBlock(-x, y, -z);
        }
        return success;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks = 0;
        if (this.state == SimulationState.SCANNING_COMMAND) {
            if (this.includeCommands && this.castCommandBlock != null) {
                if (!this.castCommandBlock.getChunk().isLoaded()) {
                    this.finish();
                    return processedBlocks;
                }
                if (this.castCommandBlock.getType() != Material.COMMAND) {
                    this.die();
                    this.finish();
                    return processedBlocks;
                }
                for (BlockFace powerFace : POWER_FACES) {
                    Block checkForPower = this.castCommandBlock.getRelative(powerFace);
                    if (checkForPower.getType() != POWER_MATERIAL) continue;
                    if (this.commandReload) {
                        this.controller.unregisterBlockForReloadToggle(checkForPower);
                    }
                    this.powerSimMaterial.modify(checkForPower);
                    this.commandPowered = true;
                }
                if (!this.commandPowered) {
                    this.die();
                    this.finish();
                    return processedBlocks;
                }
                this.birthMaterial.modify(this.castCommandBlock);
            }
            ++processedBlocks;
            this.state = SimulationState.SCANNING;
        }
        while (this.state == SimulationState.SCANNING && processedBlocks <= maxBlocks) {
            if (!this.simulateBlocks(this.x, this.y, this.z)) {
                return processedBlocks;
            }
            ++this.y;
            if (this.y > this.radius) {
                this.y = 0;
                if (this.x < this.radius) {
                    ++this.x;
                } else {
                    --this.z;
                    if (this.z < 0) {
                        this.z = ++this.r;
                        this.x = 0;
                    }
                }
            }
            if (this.r <= this.radius) continue;
            this.state = SimulationState.UPDATING;
        }
        while (this.state == SimulationState.UPDATING && processedBlocks <= maxBlocks) {
            int bornIndex;
            int deadIndex = this.updatingIndex;
            if (deadIndex >= 0 && deadIndex < this.deadBlocks.size()) {
                Block killBlock = this.deadBlocks.get(deadIndex);
                if (!killBlock.getChunk().isLoaded()) {
                    killBlock.getChunk().load();
                    return processedBlocks;
                }
                this.modifiedBlocks.add(killBlock);
                killBlock.setType(this.deathMaterial);
                this.controller.updateBlock(killBlock);
                ++processedBlocks;
            }
            if ((bornIndex = this.updatingIndex - this.deadBlocks.size()) >= 0 && bornIndex < this.bornBlocks.size()) {
                Block birthBlock = this.bornBlocks.get(bornIndex);
                if (!birthBlock.getChunk().isLoaded()) {
                    birthBlock.getChunk().load();
                    return processedBlocks;
                }
                this.modifiedBlocks.add(birthBlock);
                this.birthMaterial.modify(birthBlock);
                this.controller.updateBlock(birthBlock);
            }
            ++this.updatingIndex;
            if (this.updatingIndex < this.deadBlocks.size() + this.bornBlocks.size()) continue;
            this.state = SimulationState.COMMAND_SEARCH;
            return maxBlocks;
        }
        if (this.state == SimulationState.COMMAND_SEARCH) {
            if (this.includeCommands && this.potentialCommandBlocks.size() > 0) {
                switch (this.targetMode) {
                    case HUNT: {
                        Collections.sort(this.potentialCommandBlocks);
                        break;
                    }
                    case FLEE: {
                        Collections.sort(this.potentialCommandBlocks);
                        break;
                    }
                    default: {
                        Collections.shuffle(this.potentialCommandBlocks);
                    }
                }
                this.commandTargetBlock = null;
                Block backupBlock = null;
                while (this.commandTargetBlock == null && this.potentialCommandBlocks.size() > 0) {
                    Block block = this.potentialCommandBlocks.remove(0).getBlock();
                    if (block == null || !this.birthMaterial.is(block)) continue;
                    if (!this.commandPowered) {
                        this.commandTargetBlock = block;
                        continue;
                    }
                    backupBlock = block;
                    BlockFace powerFace = SimulateBatch.findPowerLocation(block, this.powerSimMaterial);
                    if (powerFace == null) continue;
                    this.commandTargetBlock = block;
                }
                if (this.commandTargetBlock == null) {
                    this.commandTargetBlock = backupBlock;
                }
            }
            if (DEBUG && this.commandTargetBlock != null) {
                this.controller.getLogger().info("MOVED: " + this.commandTargetBlock.getLocation().toVector().subtract(this.center.toVector()));
            }
            this.state = SimulationState.COMMAND_UPDATE;
            return processedBlocks;
        }
        if (this.state == SimulationState.COMMAND_UPDATE) {
            if (this.includeCommands) {
                if (this.commandTargetBlock != null) {
                    if (!this.commandTargetBlock.getChunk().isLoaded()) {
                        this.commandTargetBlock.getChunk().load();
                        return processedBlocks;
                    }
                    this.commandTargetBlock.setType(Material.COMMAND);
                    BlockState commandData = this.commandTargetBlock.getState();
                    if (this.castCommand != null && commandData != null && commandData instanceof CommandBlock) {
                        CommandBlock copyCommand = (CommandBlock)commandData;
                        copyCommand.setCommand(this.castCommand);
                        copyCommand.setName(this.commandName);
                        copyCommand.update();
                        Location newLocation = this.commandTargetBlock.getLocation();
                        newLocation.setPitch(this.center.getPitch());
                        newLocation.setYaw(this.center.getYaw());
                        this.mage.setLocation(newLocation);
                    } else {
                        this.commandTargetBlock = null;
                    }
                } else {
                    this.die();
                }
            }
            this.powerDelayTicks = POWER_DELAY_TICKS;
            this.state = SimulationState.COMMAND_POWER;
            return processedBlocks;
        }
        if (this.state == SimulationState.COMMAND_POWER) {
            if (this.commandPowered && this.commandTargetBlock != null && this.includeCommands) {
                if (this.powerDelayTicks > 0) {
                    --this.powerDelayTicks;
                    return processedBlocks;
                }
                BlockFace powerDirection = SimulateBatch.findPowerLocation(this.commandTargetBlock, this.powerSimMaterial);
                if (powerDirection == null) {
                    if (DEBUG) {
                        this.controller.getLogger().info("Had to fall back to backup location, pattern may diverge");
                    }
                    powerDirection = SimulateBatch.findPowerLocation(this.commandTargetBlock, this.powerSimMaterialBackup);
                }
                if (powerDirection == null) {
                    for (BlockFace face : POWER_FACES) {
                        if (!this.spell.isDestructible(this.commandTargetBlock.getRelative(face))) continue;
                        if (DEBUG) {
                            this.controller.getLogger().info("Had to fall back to destructible location, pattern may diverge and may destroy blocks");
                        }
                        powerDirection = face;
                        break;
                    }
                }
                if (powerDirection != null) {
                    Block powerBlock = this.commandTargetBlock.getRelative(powerDirection);
                    powerBlock.setType(POWER_MATERIAL);
                    if (this.commandReload) {
                        String automataName = this.commandName;
                        if (automataName == null || automataName.length() <= 1) {
                            automataName = Messages.get("automata.default_name");
                        }
                        this.controller.registerBlockForReloadToggle(powerBlock, automataName, "automata.awaken");
                    }
                }
            }
            this.state = SimulationState.FINISHED;
            return processedBlocks;
        }
        if (this.state == SimulationState.FINISHED) {
            this.finish();
        }
        return processedBlocks;
    }

    public void setCommandBlock(Block block) {
        this.castCommandBlock = block;
        if (this.castCommandBlock.getType() == Material.COMMAND) {
            BlockState commandData = this.castCommandBlock.getState();
            if (commandData != null && commandData instanceof CommandBlock) {
                CommandBlock commandBlock = (CommandBlock)commandData;
                this.castCommand = commandBlock.getCommand();
                this.commandName = commandBlock.getName();
            }
            this.includeCommands = this.castCommand != null && this.castCommand.length() > 0;
        }
    }

    public void setDrop(String dropName, int dropXp) {
        this.dropItem = dropName;
        this.dropXp = dropXp;
    }

    public void setTickCast(String cast, float probability) {
        this.tickSpell = cast;
        this.castProbability = probability;
    }

    public void setDeathCast(String cast) {
        this.deathSpell = cast;
    }

    public void setBirthRange(int range) {
        this.birthRangeSquared = range * range;
    }

    public void setLiveRange(int range) {
        this.liveRangeSquared = range * range;
    }

    public void setMaxHuntRange(int range) {
        this.huntMaxRange = range;
    }

    public void setMinHuntRange(int range) {
        this.huntMinRange = range;
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
    }

    public void target(TargetMode mode) {
        this.targetMode = mode == null ? TargetMode.STABILIZE : mode;
        switch (this.targetMode) {
            case HUNT: 
            case FLEE: 
            case DIRECTED: {
                Spell spell;
                Vector direction;
                String targetDescription;
                int score;
                Target newScore;
                this.targetLocation = this.center.clone();
                this.reverseTargetDistanceScore = this.targetMode == TargetMode.FLEE;
                Target bestTarget = null;
                if (this.targetType == TargetType.ANY || this.targetType == TargetType.MOB) {
                    List entities = this.targetLocation.getWorld().getEntities();
                    for (Entity entity : entities) {
                        if (entity instanceof Player || !(entity instanceof LivingEntity) || entity.isDead()) continue;
                        newScore = new Target(this.center, entity, this.huntMinRange, this.huntMaxRange, (double)this.huntFov, false);
                        score = newScore.getScore();
                        if (bestTarget != null && score <= bestTarget.getScore()) continue;
                        bestTarget = newScore;
                    }
                }
                if (this.targetType == TargetType.MAGE || this.targetType == TargetType.AUTOMATON || this.targetType == TargetType.ANY || this.targetType == TargetType.PLAYER) {
                    Collection<Mage> mages = this.controller.getMages();
                    for (Mage mage : mages) {
                        if (mage == this.mage || this.targetType == TargetType.AUTOMATON && mage.getPlayer() != null || this.targetType == TargetType.PLAYER && mage.getPlayer() == null || mage.isDead() || !mage.isOnline() || !mage.hasLocation() || !mage.getLocation().getWorld().equals(this.center.getWorld())) continue;
                        newScore = new Target(this.center, mage, this.huntMinRange, this.huntMaxRange, (double)this.huntFov, false);
                        score = newScore.getScore();
                        if (bestTarget != null && score <= bestTarget.getScore()) continue;
                        bestTarget = newScore;
                    }
                }
                if (bestTarget == null) break;
                String string = bestTarget.getEntity() == null ? "NONE" : (targetDescription = bestTarget instanceof Player ? ((Player)bestTarget.getEntity()).getName() : bestTarget.getEntity().getType().name());
                if (DEBUG) {
                    this.controller.getLogger().info(" *Tracking " + targetDescription + " score: " + bestTarget.getScore() + " location: " + this.center + " -> " + bestTarget.getLocation() + " min " + this.huntMinRange);
                }
                if (this.targetMode == TargetMode.DIRECTED) {
                    direction = bestTarget.getLocation().getDirection();
                    this.center = CompatibilityUtils.setDirection(this.center, direction);
                    this.targetLocation = this.center.clone().add(direction.normalize().multiply(this.huntMaxRange));
                    if (DEBUG) {
                        this.controller.getLogger().info(" *Directed " + direction + " to " + this.targetLocation.toVector());
                    }
                } else {
                    this.targetLocation = bestTarget.getLocation();
                    direction = this.targetMode == TargetMode.FLEE ? this.center.toVector().subtract(this.targetLocation.toVector()) : this.targetLocation.toVector().subtract(this.center.toVector());
                    this.center = CompatibilityUtils.setDirection(this.center, direction);
                }
                if (this.tickSpell.length() <= 0 || !(Math.random() < (double)this.castProbability) || (spell = this.mage.getSpell(this.tickSpell)) == null) break;
                if (DEBUG) {
                    this.controller.getLogger().info(this.commandName + " casting " + this.tickSpell + " at " + targetDescription);
                }
                String[] parameters = new String[]{"cost_reduction", "1", "transparent", "air," + this.birthMaterial.getMaterial().name().toLowerCase() + "," + Material.COMMAND.name().toLowerCase() + "," + POWER_MATERIAL.name().toLowerCase()};
                spell.cast(parameters);
                break;
            }
            case GLIDE: {
                this.targetLocation = this.center.clone();
                this.reverseTargetDistanceScore = true;
                break;
            }
            default: {
                this.targetLocation = this.center.clone();
                this.reverseTargetDistanceScore = true;
            }
        }
    }

    public void setCommandMoveRange(int commandRadius, boolean reload) {
        this.commandReload = reload;
        this.commandMoveRangeSquared = commandRadius * commandRadius;
    }

    protected boolean isAlive(Block block, MaterialAndData liveMaterial, boolean includeCommands) {
        Material neighborType = block.getType();
        return liveMaterial.is(block) || includeCommands && (neighborType == Material.COMMAND || neighborType == POWER_MATERIAL);
    }

    public static BlockFace findPowerLocation(Block block, MaterialAndData targetMaterial) {
        for (BlockFace face : POWER_FACES) {
            if (!targetMaterial.is(block.getRelative(face))) continue;
            return face;
        }
        return null;
    }

    protected int getNeighborCount(Block block, MaterialAndData liveMaterial, boolean includeCommands) {
        return this.getNeighborCount(block, liveMaterial, includeCommands, NEIGHBOR_FACES, true, true);
    }

    protected int getNeighborCount(Block block, MaterialAndData liveMaterial, boolean includeCommands, BlockFace[] faces, boolean includeUp, boolean includeDown) {
        int liveCount = 0;
        for (BlockFace face : faces) {
            if (!this.isAlive(block.getRelative(face), liveMaterial, includeCommands)) continue;
            ++liveCount;
        }
        if (this.yRadius > 0) {
            Block upBlock = block.getRelative(BlockFace.UP);
            if (this.isAlive(upBlock, liveMaterial, includeCommands)) {
                ++liveCount;
            }
            for (BlockFace face : faces) {
                if (!this.isAlive(upBlock.getRelative(face), liveMaterial, includeCommands)) continue;
                ++liveCount;
            }
            Block downBlock = block.getRelative(BlockFace.DOWN);
            if (this.isAlive(downBlock, liveMaterial, includeCommands)) {
                ++liveCount;
            }
            for (BlockFace face : faces) {
                if (!this.isAlive(downBlock.getRelative(face), liveMaterial, includeCommands)) continue;
                ++liveCount;
            }
        }
        return liveCount;
    }

    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    @Override
    public void finish() {
        this.state = SimulationState.FINISHED;
        if (!this.finished) {
            super.finish();
            this.spell.registerForUndo(this.modifiedBlocks);
        }
    }

    protected void mapIntegers(Collection<Integer> flags, List<Boolean> flagMap) {
        for (Integer flag : flags) {
            while (flagMap.size() <= flag) {
                flagMap.add(false);
            }
            flagMap.set(flag, true);
        }
    }

    public void setDiagonalLiveRules(Collection<Integer> rules) {
        this.mapIntegers(rules, this.diagonalLiveCounts);
    }

    public void setDiagonalBirthRules(Collection<Integer> rules) {
        this.mapIntegers(rules, this.diagonalBirthCounts);
    }

    public static enum TargetType {
        PLAYER,
        MAGE,
        MOB,
        AUTOMATON,
        ANY;

    }

    public static enum TargetMode {
        STABILIZE,
        WANDER,
        GLIDE,
        HUNT,
        FLEE,
        DIRECTED;

    }

    private static enum SimulationState {
        SCANNING_COMMAND,
        SCANNING,
        UPDATING,
        COMMAND_SEARCH,
        COMMAND_UPDATE,
        COMMAND_POWER,
        FINISHED;

    }
}

