/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.block.SimpleBlockAction;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class ReplaceMaterialAction
extends SimpleBlockAction {
    protected Mage mage;
    protected MaterialBrush brush;
    protected Set<MaterialAndData> replaceable = new HashSet<MaterialAndData>();
    private boolean spawnFallingBlocks = false;
    private Vector fallingBlockVelocity = null;

    public ReplaceMaterialAction(Mage mage, Block targetBlock, MaterialBrush brush) {
        this.mage = mage;
        this.replaceable.add(new MaterialAndData(targetBlock));
        this.brush = brush;
    }

    public ReplaceMaterialAction(Mage playerSpells, MaterialBrush brush) {
        this.mage = playerSpells;
        this.brush = brush;
    }

    public void addReplaceable(Material material) {
        this.replaceable.add(new MaterialAndData(material));
    }

    public void addReplaceable(Material material, byte data) {
        this.replaceable.add(new MaterialAndData(material, data));
    }

    @Override
    public SpellResult perform(Block block) {
        if (this.brush == null) {
            return SpellResult.FAIL;
        }
        if (!this.mage.hasBuildPermission(block)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.mage.isIndestructible(block)) {
            return SpellResult.FAIL;
        }
        if (this.replaceable == null || this.replaceable.contains(new MaterialAndData(block))) {
            Material previousMaterial = block.getType();
            byte previousData = block.getData();
            if (this.brush.isDifferent(block)) {
                this.brush.update(this.mage, block.getLocation());
                this.brush.modify(block);
                this.mage.getController().updateBlock(block);
                if (this.spawnFallingBlocks) {
                    FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation(), previousMaterial, previousData);
                    falling.setDropItem(false);
                    if (this.fallingBlockVelocity != null) {
                        falling.setVelocity(this.fallingBlockVelocity);
                    }
                }
            }
            super.perform(block);
            return SpellResult.CAST;
        }
        return SpellResult.FAIL;
    }
}

