/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities.borrowed;

import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utilities.RandomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class ConfigurationNode {
    protected Map<String, Object> root;

    public ConfigurationNode createChild(String name) {
        HashMap newChild = new HashMap();
        this.setProperty(name, newChild);
        Object raw = this.getProperty(name);
        if (raw instanceof Map) {
            return new ConfigurationNode((Map)raw);
        }
        return null;
    }

    public ConfigurationNode() {
        this.root = new HashMap<String, Object>();
    }

    public ConfigurationNode(ConfigurationNode copy) {
        HashMap<String, Object> newRoot = new HashMap<String, Object>();
        if (copy != null) {
            newRoot.putAll(copy.root);
        }
        this.root = newRoot;
    }

    public ConfigurationNode(Map<String, Object> root) {
        this.root = root;
    }

    public Map<String, Object> getAll() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Set<String> keys = this.root.keySet();
        for (String k : keys) {
            Object tmp = this.root.get(k);
            if (tmp instanceof Map) {
                Map<String, Object> rec = this.recursiveBuilder((Map)tmp);
                Set<String> subkeys = rec.keySet();
                for (String sk : subkeys) {
                    map.put(String.valueOf(k) + "." + sk, rec.get(sk));
                }
                continue;
            }
            map.put(k, tmp);
        }
        return map;
    }

    protected Map<String, Object> recursiveBuilder(Map<String, Object> node) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Set<String> keys = node.keySet();
        for (String k : keys) {
            Object tmp = node.get(k);
            if (tmp instanceof Map) {
                Map<String, Object> rec = this.recursiveBuilder((Map)tmp);
                Set<String> subkeys = rec.keySet();
                for (String sk : subkeys) {
                    map.put(String.valueOf(k) + "." + sk, rec.get(sk));
                }
                continue;
            }
            map.put(k, tmp);
        }
        return map;
    }

    public Object getProperty(String path) {
        boolean isFloat = false;
        try {
            Double.parseDouble(path);
            isFloat = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isFloat || !path.contains(".")) {
            Object val = this.root.get(path);
            if (val == null) {
                try {
                    return this.root.get(Integer.parseInt(path));
                }
                catch (Exception ex) {
                    try {
                        return this.root.get(Double.parseDouble(path));
                    }
                    catch (Exception ex2) {
                        try {
                            return this.root.get(Float.valueOf(Float.parseFloat(path)));
                        }
                        catch (Exception ex3) {
                            return null;
                        }
                    }
                }
            }
            return val;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        int i = 0;
        while (i < parts.length) {
            Object o = node.get(parts[i]);
            if (o == null) {
                return null;
            }
            if (i == parts.length - 1) {
                return o;
            }
            try {
                node = (Map)o;
            }
            catch (ClassCastException e) {
                return null;
            }
            ++i;
        }
        return null;
    }

    public static String fromLocation(Location location) {
        return String.valueOf(location.getX()) + "," + location.getY() + "," + location.getZ() + "," + location.getWorld().getName() + "," + location.getYaw() + "," + location.getPitch();
    }

    public void setProperty(String path, Object value) {
        BlockData blockValue;
        if (path == null || path.length() == 0) {
            return;
        }
        if (value == null) {
            this.removeProperty(path);
            return;
        }
        if (value instanceof Material) {
            Material matValue = (Material)value;
            value = matValue.name().toLowerCase();
        }
        if (value instanceof Location) {
            value = ConfigurationNode.fromLocation((Location)value);
        }
        if (value instanceof Color) {
            Color color = (Color)value;
            value = Integer.toString(color.asRGB(), 16);
        }
        if (value instanceof BlockData) {
            blockValue = (BlockData)value;
            value = blockValue.toString();
        }
        if (value instanceof Block) {
            blockValue = (Block)value;
            value = String.valueOf(ConfigurationNode.fromLocation(blockValue.getLocation())) + "|" + blockValue.getTypeId() + ":" + blockValue.getData();
        }
        if (!path.contains(".")) {
            this.root.put(path, value);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        int i = 0;
        while (i < parts.length) {
            HashMap o = node.get(parts[i]);
            if (i == parts.length - 1) {
                node.put((String)parts[i], (Object)value);
                return;
            }
            if (o == null || !(o instanceof Map)) {
                o = new HashMap();
                node.put(parts[i], o);
            }
            node = o;
            ++i;
        }
    }

    public String getString(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public Material getMaterial(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        return ConfigurationNode.toMaterial(o);
    }

    public MaterialAndData getMaterialAndData(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        return ConfigurationNode.toMaterialAndData(o);
    }

    public Location getLocation(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        return ConfigurationNode.toLocation(o);
    }

    protected double overrideDouble(double value, String nodeName) {
        String override = this.getString(nodeName);
        if (override == null || override.length() == 0) {
            return value;
        }
        try {
            if (override.startsWith("~")) {
                override = override.substring(1);
                value += Double.parseDouble(override);
            } else {
                value = Double.parseDouble(override);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public Location getLocationOverride(String basePath, Location location) {
        boolean hasWorld;
        String worldName = String.valueOf(basePath) + "world";
        String xName = String.valueOf(basePath) + "x";
        String yName = String.valueOf(basePath) + "y";
        String zName = String.valueOf(basePath) + "z";
        String dxName = String.valueOf(basePath) + "dx";
        String dyName = String.valueOf(basePath) + "dy";
        String dzName = String.valueOf(basePath) + "dz";
        boolean hasPosition = this.containsKey(xName) || this.containsKey(yName) || this.containsKey(zName);
        boolean hasDirection = this.containsKey(dxName) || this.containsKey(dyName) || this.containsKey(dzName);
        String worldOverride = this.getString(worldName);
        boolean bl = hasWorld = worldOverride != null && worldOverride.length() > 0;
        if (!(hasPosition || hasDirection || hasWorld)) {
            return null;
        }
        if (location == null) {
            if (!hasWorld || !hasPosition) {
                return null;
            }
            location = new Location(Bukkit.getWorld((String)worldOverride), 0.0, 0.0, 0.0);
        } else {
            location = location.clone();
            if (hasWorld) {
                location.setWorld(Bukkit.getWorld((String)worldOverride));
            }
        }
        if (hasPosition) {
            location.setX(this.overrideDouble(location.getX(), xName));
            location.setY(this.overrideDouble(location.getY(), yName));
            location.setZ(this.overrideDouble(location.getZ(), zName));
        }
        if (hasDirection) {
            Vector direction = location.getDirection();
            direction.setX(this.overrideDouble(direction.getX(), dxName));
            direction.setY(this.overrideDouble(direction.getY(), dyName));
            direction.setZ(this.overrideDouble(direction.getZ(), dzName));
            RandomUtils.setDirection(location, direction);
        }
        return location;
    }

    public static Location toLocation(Object o) {
        if (o instanceof Location) {
            return (Location)o;
        }
        if (o instanceof String) {
            try {
                float pitch = 0.0f;
                float yaw = 0.0f;
                String[] pieces = StringUtils.split((String)((String)o), (char)',');
                double x = Double.parseDouble(pieces[0]);
                double y = Double.parseDouble(pieces[1]);
                double z = Double.parseDouble(pieces[2]);
                World world = null;
                world = pieces.length > 3 ? Bukkit.getWorld((String)pieces[3]) : (World)Bukkit.getWorlds().get(0);
                if (pieces.length > 5) {
                    yaw = Float.parseFloat(pieces[4]);
                    pitch = Float.parseFloat(pieces[5]);
                }
                return new Location(world, x, y, z, yaw, pitch);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static Material toMaterial(Object o) {
        if (o instanceof Material) {
            return (Material)o;
        }
        if (o instanceof Integer) {
            return Material.values()[(Integer)o];
        }
        if (o instanceof String) {
            String matName = (String)o;
            try {
                Integer value = Integer.parseInt(matName);
                if (value != null) {
                    return Material.getMaterial((int)value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Material.getMaterial((String)matName.toUpperCase());
        }
        return null;
    }

    public static MaterialAndData toMaterialAndData(Object o) {
        if (o instanceof MaterialAndData) {
            return (MaterialAndData)o;
        }
        if (o instanceof String) {
            String matName = (String)o;
            Material material = null;
            byte data = 0;
            String[] pieces = StringUtils.split((String)matName, (char)':');
            if (pieces.length > 0) {
                if (pieces.length > 1) {
                    try {
                        data = Byte.parseByte(pieces[1]);
                    }
                    catch (NumberFormatException ex) {
                        data = 0;
                    }
                }
                try {
                    Integer value = Integer.parseInt(pieces[0]);
                    if (value != null) {
                        material = Material.getMaterial((int)value);
                    }
                }
                catch (NumberFormatException ex) {
                    material = Material.getMaterial((String)pieces[0].toUpperCase());
                }
            }
            if (material == null) {
                return null;
            }
            return new MaterialAndData(material, data);
        }
        return null;
    }

    public MaterialAndData getMaterialAndData(String path, Material def) {
        return this.getMaterialAndData(path, def, (byte)0);
    }

    public MaterialAndData getMaterialAndData(String path, Material def, byte defData) {
        MaterialAndData o = this.getMaterialAndData(path);
        return o == null ? new MaterialAndData(def, defData) : o;
    }

    public MaterialAndData getMaterialAndData(String path, MaterialAndData def) {
        MaterialAndData o = this.getMaterialAndData(path);
        return o == null ? def : o;
    }

    public Material getMaterial(String path, Material def) {
        Material o = this.getMaterial(path);
        return o == null ? def : o;
    }

    public String getString(String path, String def) {
        String o = this.getString(path);
        return o == null ? def : o;
    }

    public int getInt(String path, int def) {
        Integer o = ConfigurationNode.castInt(this.getProperty(path));
        return o == null ? def : o;
    }

    public Integer getInteger(String path, Integer def) {
        Integer o = ConfigurationNode.castInt(this.getProperty(path));
        return o == null ? def : o;
    }

    public int getInteger(String path, int def) {
        return this.getInt(path, def);
    }

    public long getLong(String path, long def) {
        Long o = ConfigurationNode.castLong(this.getProperty(path));
        return o == null ? def : o;
    }

    public Color getColor(String path, Color def) {
        Color o = ConfigurationNode.castColor(this.getProperty(path));
        return o == null ? def : o;
    }

    public static Set<Material> parseMaterials(String csv) {
        String[] nameList = StringUtils.split((String)csv, (char)',');
        HashSet<Material> materials = new HashSet<Material>();
        String[] stringArray = nameList;
        int n = nameList.length;
        int n2 = 0;
        while (n2 < n) {
            String matName = stringArray[n2];
            Material material = ConfigurationNode.toMaterial(matName);
            if (material != null) {
                materials.add(material);
            }
            ++n2;
        }
        return materials;
    }

    public Set<Material> getMaterials(String key, String csvList) {
        ArrayList<String> defaultMatNames = new ArrayList<String>(Arrays.asList(StringUtils.split((String)csvList, (char)',')));
        List<String> materialData = this.getStringList(key, defaultMatNames);
        HashSet<Material> materials = new HashSet<Material>();
        for (String matName : materialData) {
            Material material = ConfigurationNode.toMaterial(matName);
            if (material == null) continue;
            materials.add(material);
        }
        return materials;
    }

    public Set<Material> getMaterials(String key) {
        List<String> materialData = this.getStringList(key);
        if (materialData == null) {
            return null;
        }
        HashSet<Material> materials = new HashSet<Material>();
        for (String matName : materialData) {
            Material material = ConfigurationNode.toMaterial(matName);
            if (material == null) continue;
            materials.add(material);
        }
        return materials;
    }

    public double getDouble(String path, double def) {
        Double o = ConfigurationNode.castDouble(this.getProperty(path));
        return o == null ? def : o;
    }

    public Double getDouble(String path, Double def) {
        Double o = ConfigurationNode.castDouble(this.getProperty(path));
        return o == null ? def : o;
    }

    public float getFloat(String path, float def) {
        Float o = ConfigurationNode.castFloat(this.getProperty(path));
        return o == null ? def : o.floatValue();
    }

    public Float getFloat(String path, Float def) {
        Float o = ConfigurationNode.castFloat(this.getProperty(path));
        return o == null ? def : o;
    }

    public boolean getBoolean(String path, boolean def) {
        Boolean o = ConfigurationNode.castBoolean(this.getProperty(path));
        return o == null ? def : o;
    }

    public Boolean getBoolean(String path, Boolean def) {
        Boolean o = ConfigurationNode.castBoolean(this.getProperty(path));
        return o == null ? def : o;
    }

    public BlockData getBlockData(String path) {
        return BlockData.fromString(this.getString(path));
    }

    public List<String> getKeys(String path) {
        if (path == null) {
            return this.getKeys();
        }
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            return new ArrayList<String>(((Map)o).keySet());
        }
        return null;
    }

    public List<String> getKeys() {
        Set<String> keys = this.root.keySet();
        ArrayList<String> stringKeys = new ArrayList<String>();
        for (String key : keys) {
            stringKeys.add(key.toString());
        }
        return stringKeys;
    }

    public List<Object> getList(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            return new ArrayList<Object>(Arrays.asList(StringUtils.split((String)((String)o), (char)',')));
        }
        ArrayList<Object> single = new ArrayList<Object>();
        single.add(o);
        return single;
    }

    public List<String> getStringList(String path, List<String> def) {
        ArrayList list = this.getStringList(path);
        return list == null ? (def == null ? new ArrayList() : def) : list;
    }

    public List<String> getStringList(String path) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : raw) {
            if (o == null) continue;
            list.add(o.toString());
        }
        return list;
    }

    public List<Integer> getIntList(String path, List<Integer> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object o : raw) {
            Integer i = ConfigurationNode.castInt(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    public static List<Integer> parseIntegers(String csvList) {
        String[] intStrings;
        ArrayList<Integer> ints = new ArrayList<Integer>();
        String[] stringArray = intStrings = csvList.split(",");
        int n = intStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            try {
                int thisInt = Integer.parseInt(s.trim());
                ints.add(thisInt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
        return ints;
    }

    public List<Double> getDoubleList(String path, List<Double> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (Object o : raw) {
            Double i = ConfigurationNode.castDouble(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    public List<Boolean> getBooleanList(String path, List<Boolean> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (Object o : raw) {
            Boolean tetsu = ConfigurationNode.castBoolean(o);
            if (tetsu == null) continue;
            list.add(tetsu);
        }
        return list;
    }

    public List<ConfigurationNode> getNodeList(String path, List<ConfigurationNode> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<ConfigurationNode> list = new ArrayList<ConfigurationNode>();
        for (Object o : raw) {
            if (!(o instanceof Map)) continue;
            list.add(new ConfigurationNode((Map)o));
        }
        return list;
    }

    public List<ConfigurationNode> getNodeList(String path) {
        return this.getNodeList(path, null);
    }

    public ConfigurationNode getNode(String path) {
        Object raw = this.getProperty(path);
        if (raw instanceof Map) {
            return new ConfigurationNode((Map)raw);
        }
        return null;
    }

    public boolean containsKey(String path) {
        Object test = this.getProperty(path);
        return test != null;
    }

    public ConfigurationNode getNode(String path, ConfigurationNode def) {
        Object raw = this.getProperty(path);
        if (raw instanceof Map) {
            return new ConfigurationNode((Map)raw);
        }
        this.setProperty(path, def.getAll());
        return def;
    }

    public Map<String, ConfigurationNode> getNodes(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            HashMap<String, ConfigurationNode> nodes = new HashMap<String, ConfigurationNode>();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                if (!(entry.getValue() instanceof Map)) continue;
                nodes.put((String)entry.getKey(), new ConfigurationNode((Map)entry.getValue()));
            }
            return nodes;
        }
        return null;
    }

    private static Integer castInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (int)((Byte)o);
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return (int)((Double)o).doubleValue();
        }
        if (o instanceof Float) {
            return (int)((Float)o).floatValue();
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    private static Long castLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (long)((Byte)o);
        }
        if (o instanceof Integer) {
            return (long)((Integer)o);
        }
        if (o instanceof Double) {
            return (long)((Double)o).doubleValue();
        }
        if (o instanceof Float) {
            return (long)((Float)o).floatValue();
        }
        if (o instanceof Long) {
            return (long)((Long)o);
        }
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    private static Color castColor(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return Color.fromRGB((int)((Byte)o).byteValue());
        }
        if (o instanceof Integer) {
            return Color.fromRGB((int)((Integer)o));
        }
        if (o instanceof Double) {
            return Color.fromRGB((int)((int)((Double)o).doubleValue()));
        }
        if (o instanceof Float) {
            return Color.fromRGB((int)((int)((Float)o).floatValue()));
        }
        if (o instanceof Long) {
            return Color.fromRGB((int)((int)((Long)o).longValue()));
        }
        if (o instanceof String) {
            try {
                Integer rgb = Integer.parseInt((String)o, 16);
                return Color.fromRGB((int)rgb);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    private static Double castDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Byte) {
            return (double)((Byte)o);
        }
        if (o instanceof Integer) {
            return (double)((Integer)o);
        }
        if (o instanceof Long) {
            return (double)((Long)o);
        }
        if (o instanceof String) {
            try {
                return Double.parseDouble((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    private static Float castFloat(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Double) {
            return Float.valueOf((float)((Double)o).doubleValue());
        }
        if (o instanceof Byte) {
            return Float.valueOf(((Byte)o).byteValue());
        }
        if (o instanceof Integer) {
            return Float.valueOf(((Integer)o).intValue());
        }
        if (o instanceof Long) {
            return Float.valueOf(((Long)o).longValue());
        }
        if (o instanceof String) {
            try {
                return Float.valueOf(Float.parseFloat((String)o));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    private static Boolean castBoolean(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            try {
                return Boolean.parseBoolean((String)o);
            }
            catch (NumberFormatException ex) {
                try {
                    if (Integer.parseInt((String)o) != 0) {
                        return true;
                    }
                    return false;
                }
                catch (NumberFormatException ex2) {
                    return null;
                }
            }
        }
        return null;
    }

    public void removeProperty(String path) {
        if (!path.contains(".")) {
            this.root.remove(path);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        int i = 0;
        while (i < parts.length) {
            Object o = node.get(parts[i]);
            if (i == parts.length - 1) {
                node.remove(parts[i]);
                return;
            }
            node = (Map)o;
            ++i;
        }
    }

    protected void combine(Map<String, Object> to, Map<? extends Object, Object> from) {
        for (Map.Entry<? extends Object, Object> entry : from.entrySet()) {
            Object toValue;
            Object value = entry.getValue();
            String key = entry.getKey().toString();
            if (value instanceof Map && to.containsKey(key) && (toValue = to.get(key)) instanceof Map) {
                this.combine((Map)toValue, (Map)value);
                continue;
            }
            to.put(key, value);
        }
    }

    public void add(ConfigurationNode other) {
        this.combine(this.root, other.root);
    }
}

