/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.wand;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.effects.EffectRing;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.CastingCost;
import com.elmakers.mine.bukkit.plugins.magic.CostReducer;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.wand.WandLevel;
import com.elmakers.mine.bukkit.plugins.magic.wand.WandMode;
import com.elmakers.mine.bukkit.plugins.magic.wand.WandOrganizer;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.Messages;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Wand
implements CostReducer {
    public static final int INVENTORY_SIZE = 27;
    public static final int HOTBAR_SIZE = 9;
    public static final String[] PROPERTY_KEYS = new String[]{"active_spell", "active_material", "xp", "xp_regeneration", "xp_max", "bound", "uses", "upgrade", "indestructible", "cost_reduction", "cooldown_reduction", "effect_bubbles", "effect_color", "effect_particle", "effect_particle_count", "effect_particle_data", "effect_particle_interval", "effect_sound", "effect_sound_interval", "effect_sound_pitch", "effect_sound_volume", "haste", "health_regeneration", "hunger_regeneration", "icon", "mode", "keep", "locked", "quiet", "power", "protection", "protection_physical", "protection_projectiles", "protection_falling", "protection_fire", "protection_explosions", "materials", "spells"};
    public static final String[] HIDDEN_PROPERTY_KEYS = new String[]{"id", "owner", "name", "description", "template", "organize", "fill"};
    public static final String[] ALL_PROPERTY_KEYS = (String[])ArrayUtils.addAll((Object[])PROPERTY_KEYS, (Object[])HIDDEN_PROPERTY_KEYS);
    protected ItemStack item;
    protected MagicController controller;
    protected Mage mage;
    private String id = "";
    private Inventory hotbar;
    private List<Inventory> inventories;
    private String activeSpell = "";
    private String activeMaterial = "";
    protected String wandName = "";
    protected String description = "";
    private String owner = "";
    private String template = "";
    private boolean bound = false;
    private boolean indestructible = false;
    private boolean keep = false;
    private boolean autoOrganize = false;
    private boolean autoFill = false;
    private boolean isUpgrade = false;
    private MaterialAndData icon = null;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private float damageReduction = 0.0f;
    private float damageReductionPhysical = 0.0f;
    private float damageReductionProjectiles = 0.0f;
    private float damageReductionFalling = 0.0f;
    private float damageReductionFire = 0.0f;
    private float damageReductionExplosions = 0.0f;
    private float power = 0.0f;
    private boolean hasInventory = false;
    private boolean locked = false;
    private int uses = 0;
    private int xp = 0;
    private int xpRegeneration = 0;
    private int xpMax = 0;
    private int healthRegeneration = 0;
    private int hungerRegeneration = 0;
    private int effectColor = 0;
    private ParticleType effectParticle = null;
    private float effectParticleData = 0.0f;
    private int effectParticleCount = 0;
    private int effectParticleInterval = 0;
    private int effectParticleCounter = 0;
    private boolean effectBubbles = false;
    private EffectRing effectPlayer = null;
    private Sound effectSound = null;
    private int effectSoundInterval = 0;
    private int effectSoundCounter = 0;
    private float effectSoundVolume = 0.0f;
    private float effectSoundPitch = 0.0f;
    private float defaultWalkSpeed = 0.2f;
    private float defaultFlySpeed = 0.1f;
    private float speedIncrease = 0.0f;
    private int storedXpLevel = 0;
    private int storedXp = 0;
    private float storedXpProgress = 0.0f;
    private int quietLevel = 0;
    private WandMode mode = null;
    private int openInventoryPage = 0;
    private boolean inventoryIsOpen = false;
    private Inventory displayInventory = null;
    private boolean suspendSave = false;
    protected static Map<String, ConfigurationNode> wandTemplates = new HashMap<String, ConfigurationNode>();
    public static boolean displayManaAsBar = true;
    public static Material DefaultUpgradeMaterial = Material.NETHER_STAR;
    public static Material DefaultWandMaterial = Material.BLAZE_ROD;
    public static Material EnchantableWandMaterial = Material.WOOD_SWORD;
    public static boolean EnableGlow = true;

    public Wand(MagicController controller, ItemStack itemStack) {
        this.controller = controller;
        this.hotbar = InventoryUtils.createInventory(null, 9, "Wand");
        this.icon = new MaterialAndData(itemStack.getType(), (byte)itemStack.getDurability());
        this.inventories = new ArrayList<Inventory>();
        this.item = itemStack;
        this.indestructible = controller.getIndestructibleWands();
        this.loadState();
    }

    public Wand(MagicController controller) {
        this(controller, DefaultWandMaterial, 0);
    }

    protected Wand(MagicController controller, String templateName) throws IllegalArgumentException {
        this(controller);
        this.suspendSave = true;
        String wandName = Messages.get("wand.default_name");
        String wandDescription = "";
        if ((templateName == null || templateName.length() == 0) && wandTemplates.containsKey("default")) {
            templateName = "default";
        }
        if (templateName != null && templateName.length() > 0) {
            if ((templateName.equals("random") || templateName.startsWith("random(")) && wandTemplates.containsKey("random")) {
                int level = 1;
                if (!templateName.equals("random")) {
                    String randomLevel = templateName.substring(templateName.indexOf(40) + 1, templateName.length() - 1);
                    level = Integer.parseInt(randomLevel);
                }
                ConfigurationNode randomTemplate = wandTemplates.get("random");
                this.randomize(level, false);
                this.locked = randomTemplate.getBoolean("locked", false);
                this.setEffectColor(randomTemplate.getString("effect_color"));
                this.suspendSave = false;
                this.saveState();
                return;
            }
            if (!wandTemplates.containsKey(templateName)) {
                throw new IllegalArgumentException("No template named " + templateName);
            }
            ConfigurationNode wandConfig = wandTemplates.get(templateName);
            wandName = Messages.get("wands." + templateName + ".name", wandName);
            wandDescription = Messages.get("wands." + templateName + ".description", wandDescription);
            this.loadProperties(wandConfig);
        }
        this.setDescription(wandDescription);
        this.setName(wandName);
        this.suspendSave = false;
        this.saveState();
    }

    public Wand(MagicController controller, Material icon, short iconData) {
        this(controller, InventoryUtils.getCopy(new ItemStack(icon, 1, iconData)));
        if (EnableGlow) {
            InventoryUtils.addGlow(this.item);
        }
        this.wandName = Messages.get("wand.default_name");
        this.updateName();
    }

    public void checkId() {
        if (this.id.length() == 0) {
            this.generateId();
        }
    }

    public void generateId() {
        this.id = UUID.randomUUID().toString();
        this.saveState();
    }

    public void unenchant() {
        this.item = new ItemStack(this.item.getType(), 1, this.item.getDurability());
    }

    public void setIcon(Material material, byte data) {
        this.setIcon(material == null ? null : new MaterialAndData(material, data));
    }

    public void setIcon(MaterialAndData materialData) {
        this.icon = materialData;
        if (this.icon != null) {
            this.item.setType(this.icon.getMaterial());
            this.item.setDurability((short)this.icon.getData());
        }
    }

    public void makeUpgrade() {
        this.isUpgrade = true;
        this.wandName = Messages.get("wand.upgrade_name");
        this.description = Messages.get("wand.upgrade_default_description");
        this.setIcon(DefaultUpgradeMaterial, (byte)0);
        this.saveState();
        this.updateName(true);
        this.updateLore();
    }

    public void setActiveSpell(String activeSpell) {
        this.activeSpell = activeSpell;
        this.updateName();
        this.updateInventory();
        this.saveState();
    }

    protected void activateBrush(String materialKey) {
        this.setActiveMaterial(materialKey);
        if (materialKey != null) {
            MaterialBrush brush = this.mage.getBrush();
            brush.activate(this.mage.getLocation(), materialKey);
        }
    }

    public void activateBrush(ItemStack itemStack) {
        if (!Wand.isBrush(itemStack)) {
            return;
        }
        this.activateBrush(Wand.getMaterialKey(itemStack));
    }

    protected void setActiveMaterial(String materialKey) {
        this.activeMaterial = materialKey;
        this.updateName();
        this.updateActiveMaterial();
        this.updateInventory();
        this.saveState();
    }

    public int getXpRegeneration() {
        return this.xpRegeneration;
    }

    public int getXpMax() {
        return this.xpMax;
    }

    public int getExperience() {
        return this.xp;
    }

    public void removeExperience(int amount) {
        this.xp = Math.max(0, this.xp - amount);
        this.updateMana();
    }

    public int getHealthRegeneration() {
        return this.healthRegeneration;
    }

    public int getHungerRegeneration() {
        return this.hungerRegeneration;
    }

    public boolean isModifiable() {
        return !this.locked;
    }

    public boolean isIndestructible() {
        return this.indestructible;
    }

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    @Override
    public boolean usesMana() {
        return this.xpMax > 0 && this.xpRegeneration > 0 && this.getCostReduction() < 1.0f;
    }

    public float getCooldownReduction() {
        return this.controller.getCooldownReduction() + this.cooldownReduction;
    }

    @Override
    public float getCostReduction() {
        if (this.isCostFree()) {
            return 1.0f;
        }
        return this.controller.getCostReduction() + this.costReduction * 0.5f;
    }

    public void setCooldownReduction(float reduction) {
        this.cooldownReduction = reduction;
    }

    public boolean getHasInventory() {
        return this.hasInventory;
    }

    public float getPower() {
        return this.power;
    }

    public boolean isSuperProtected() {
        return this.damageReduction > 1.0f;
    }

    public boolean isSuperPowered() {
        return this.power > 1.0f;
    }

    public boolean isCostFree() {
        return this.costReduction > 1.0f;
    }

    public float getDamageReduction() {
        return this.damageReduction * 0.2f;
    }

    public float getDamageReductionPhysical() {
        return this.damageReductionPhysical * 0.2f;
    }

    public float getDamageReductionProjectiles() {
        return this.damageReductionProjectiles * 0.2f;
    }

    public float getDamageReductionFalling() {
        return this.damageReductionFalling * 0.2f;
    }

    public float getDamageReductionFire() {
        return this.damageReductionFire * 0.2f;
    }

    public float getDamageReductionExplosions() {
        return this.damageReductionExplosions * 0.2f;
    }

    public int getUses() {
        return this.uses;
    }

    public String getName() {
        return this.wandName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setName(String name) {
        this.wandName = ChatColor.stripColor((String)name);
        this.updateName();
    }

    public void setTemplate(String templateName) {
        this.template = templateName;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setDescription(String description) {
        this.description = description;
        this.updateLore();
    }

    public void tryToOwn(Player player) {
        if (this.owner == null || this.owner.length() == 0) {
            this.takeOwnership(player);
        }
    }

    protected void takeOwnership(Player player) {
        this.owner = player.getName();
        if (this.controller != null && this.controller.bindWands()) {
            this.bound = true;
        }
        if (this.controller != null && this.controller.keepWands()) {
            this.keep = true;
        }
        this.updateLore();
    }

    public ItemStack getItem() {
        return this.item;
    }

    protected List<Inventory> getAllInventories() {
        ArrayList<Inventory> allInventories = new ArrayList<Inventory>(this.inventories.size() + 1);
        allInventories.add(this.hotbar);
        allInventories.addAll(this.inventories);
        return allInventories;
    }

    public Set<String> getSpells() {
        return this.getSpells(false);
    }

    protected Set<String> getSpells(boolean includePositions) {
        TreeSet<String> spellNames = new TreeSet<String>();
        List<Inventory> allInventories = this.getAllInventories();
        int index = 0;
        for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            int i = 0;
            while (i < items.length) {
                if (items[i] != null && !Wand.isWand(items[i]) && Wand.isSpell(items[i])) {
                    String spellName = Wand.getSpell(items[i]);
                    if (includePositions) {
                        spellName = String.valueOf(spellName) + "@" + index;
                    }
                    spellNames.add(spellName);
                }
                ++index;
                ++i;
            }
        }
        return spellNames;
    }

    protected String getSpellString() {
        return StringUtils.join(this.getSpells(true), (String)",");
    }

    public Set<String> getMaterialKeys() {
        return this.getMaterialKeys(false);
    }

    protected Set<String> getMaterialKeys(boolean includePositions) {
        TreeSet<String> materialNames = new TreeSet<String>();
        ArrayList<Inventory> allInventories = new ArrayList<Inventory>(this.inventories.size() + 1);
        allInventories.add(this.hotbar);
        allInventories.addAll(this.inventories);
        Integer index = 0;
        for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            int i = 0;
            while (i < items.length) {
                String materialKey = Wand.getMaterialKey(items[i], includePositions ? index : null);
                if (materialKey != null) {
                    materialNames.add(materialKey);
                }
                index = index + 1;
                ++i;
            }
        }
        return materialNames;
    }

    protected String getMaterialString() {
        return StringUtils.join(this.getMaterialKeys(true), (String)",");
    }

    protected Integer parseSlot(String[] pieces) {
        Integer slot = null;
        if (pieces.length > 0) {
            try {
                slot = Integer.parseInt(pieces[1]);
            }
            catch (Exception ex) {
                slot = null;
            }
            if (slot != null && slot < 0) {
                slot = null;
            }
        }
        return slot;
    }

    protected void addToInventory(ItemStack itemStack) {
        WandMode wandMode = this.getMode();
        Integer selectedItem = null;
        if (wandMode == WandMode.INVENTORY && this.mage != null && this.mage.getPlayer() != null) {
            selectedItem = this.mage.getPlayer().getInventory().getHeldItemSlot();
            this.hotbar.setItem(selectedItem.intValue(), this.item);
        }
        List<Inventory> checkInventories = wandMode == WandMode.INVENTORY ? this.getAllInventories() : this.inventories;
        boolean added = false;
        for (Inventory inventory : checkInventories) {
            HashMap returned = inventory.addItem(new ItemStack[]{itemStack});
            if (returned.size() != 0) continue;
            added = true;
            break;
        }
        if (!added) {
            Inventory newInventory = InventoryUtils.createInventory(null, 27, "Wand");
            newInventory.addItem(new ItemStack[]{itemStack});
            this.inventories.add(newInventory);
        }
        if (selectedItem != null) {
            this.hotbar.setItem(selectedItem.intValue(), null);
        }
    }

    protected Inventory getDisplayInventory() {
        if (this.displayInventory == null) {
            this.displayInventory = InventoryUtils.createInventory(null, 36, "Wand");
        }
        return this.displayInventory;
    }

    protected Inventory getInventoryByIndex(int inventoryIndex) {
        while (inventoryIndex >= this.inventories.size()) {
            this.inventories.add(InventoryUtils.createInventory(null, 27, "Wand"));
        }
        return this.inventories.get(inventoryIndex);
    }

    protected Inventory getInventory(Integer slot) {
        Inventory inventory = this.hotbar;
        if (slot >= 9) {
            int inventoryIndex = (slot - 9) / 27;
            inventory = this.getInventoryByIndex(inventoryIndex);
        }
        return inventory;
    }

    protected int getInventorySlot(Integer slot) {
        if (slot < 9) {
            return slot;
        }
        return (slot - 9) % 27;
    }

    protected void addToInventory(ItemStack itemStack, Integer slot) {
        if (slot == null) {
            this.addToInventory(itemStack);
            return;
        }
        Inventory inventory = this.getInventory(slot);
        slot = this.getInventorySlot(slot);
        ItemStack existing = inventory.getItem(slot.intValue());
        inventory.setItem(slot.intValue(), itemStack);
        if (existing != null && existing.getType() != Material.AIR) {
            this.addToInventory(existing);
        }
    }

    protected void parseInventoryStrings(String spellString, String materialString) {
        String[] materialNames;
        String[] spellNames;
        this.hotbar.clear();
        this.inventories.clear();
        spellString = spellString.replaceAll("[\\]\\[]", "");
        String[] stringArray = spellNames = StringUtils.split((String)spellString, (String)"|,");
        int n = spellNames.length;
        int n2 = 0;
        while (n2 < n) {
            String spellName = stringArray[n2];
            String[] pieces = spellName.split("@");
            Integer slot = this.parseSlot(pieces);
            String spellKey = pieces[0].trim();
            ItemStack itemStack = this.createSpellIcon(spellKey);
            if (itemStack == null) {
                this.controller.getPlugin().getLogger().warning("Unable to create spell icon for key " + spellKey);
            } else {
                if (this.activeSpell == null || this.activeSpell.length() == 0) {
                    this.activeSpell = spellKey;
                }
                this.addToInventory(itemStack, slot);
            }
            ++n2;
        }
        materialString = materialString.replaceAll("[\\]\\[]", "");
        String[] stringArray2 = materialNames = StringUtils.split((String)materialString, (String)"|,");
        int n3 = materialNames.length;
        n = 0;
        while (n < n3) {
            String materialName = stringArray2[n];
            String[] pieces = materialName.split("@");
            Integer slot = this.parseSlot(pieces);
            String materialKey = pieces[0].trim();
            ItemStack itemStack = this.createMaterialIcon(materialKey);
            if (itemStack == null) {
                this.controller.getPlugin().getLogger().warning("Unable to create material icon for key " + materialKey);
            } else {
                if (this.activeMaterial == null || this.activeMaterial.length() == 0) {
                    this.activeMaterial = materialKey;
                }
                this.addToInventory(itemStack, slot);
            }
            ++n;
        }
        this.hasInventory = spellNames.length + materialNames.length > 1;
    }

    public static ItemStack createSpellItem(String spellKey, MagicController controller, Wand wand, boolean isItem) {
        Spell spell = controller.getSpell(spellKey);
        if (spell == null) {
            return null;
        }
        MaterialAndData icon = spell.getIcon();
        if (icon == null) {
            controller.getPlugin().getLogger().warning("Unable to create spell icon for " + spell.getName() + ", missing material");
        }
        ItemStack itemStack = null;
        ItemStack originalItemStack = null;
        try {
            originalItemStack = new ItemStack(icon.getMaterial(), 1, 0, Byte.valueOf(icon.getData()));
            itemStack = InventoryUtils.getCopy(originalItemStack);
        }
        catch (Exception ex) {
            itemStack = null;
        }
        if (itemStack == null) {
            controller.getPlugin().getLogger().warning("Unable to create spell icon for " + spellKey + " with material " + icon.getMaterial().name());
            return originalItemStack;
        }
        Wand.updateSpellName(itemStack, spell, wand, wand == null ? null : wand.activeMaterial, isItem);
        return itemStack;
    }

    protected ItemStack createSpellIcon(String spellKey) {
        return Wand.createSpellItem(spellKey, this.controller, this, false);
    }

    private String getActiveWandName(String materialKey) {
        Spell spell = this.controller.getSpell(this.activeSpell);
        return this.getActiveWandName(spell, materialKey);
    }

    protected ItemStack createMaterialIcon(String materialKey) {
        return Wand.createMaterialItem(materialKey, this.controller, this, false);
    }

    public static ItemStack createMaterialItem(String materialKey, MagicController controller, Wand wand, boolean isItem) {
        byte dataId;
        MaterialAndData brushData = MaterialBrush.parseMaterialKey(materialKey, false);
        if (brushData == null) {
            return null;
        }
        Material material = brushData.getMaterial();
        ItemStack originalItemStack = new ItemStack(material, 1, 0, Byte.valueOf(dataId = brushData.getData()));
        ItemStack itemStack = InventoryUtils.getCopy(originalItemStack);
        if (itemStack == null) {
            controller.getPlugin().getLogger().warning("Unable to create material icon for " + material.name() + ": " + originalItemStack.getType());
            return originalItemStack;
        }
        ItemMeta meta = itemStack.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        if (material != null) {
            lore.add(ChatColor.GRAY + Messages.get("wand.building_material_info").replace("$material", MaterialBrush.getMaterialName(materialKey)));
            if (material == MaterialBrush.EraseMaterial) {
                lore.add(Messages.get("wand.erase_material_description"));
            } else if (material == MaterialBrush.CopyMaterial) {
                lore.add(Messages.get("wand.copy_material_description"));
            } else if (material == MaterialBrush.CloneMaterial) {
                lore.add(Messages.get("wand.clone_material_description"));
            } else if (material == MaterialBrush.ReplicateMaterial) {
                lore.add(Messages.get("wand.replicate_material_description"));
            } else if (material == MaterialBrush.MapMaterial) {
                lore.add(Messages.get("wand.map_material_description"));
            } else if (material == MaterialBrush.SchematicMaterial) {
                lore.add(Messages.get("wand.schematic_material_description").replace("$schematic", brushData.getCustomName()));
            } else {
                lore.add(ChatColor.LIGHT_PURPLE + Messages.get("wand.building_material_description"));
            }
        }
        if (isItem) {
            lore.add(ChatColor.YELLOW + Messages.get("wand.brush_item_description"));
        }
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        Wand.updateMaterialName(itemStack, materialKey, wand);
        return itemStack;
    }

    protected void saveState() {
        if (this.suspendSave || this.item == null) {
            return;
        }
        Object wandNode = InventoryUtils.createNode(this.item, "wand");
        ConfigurationNode stateNode = new ConfigurationNode();
        this.saveProperties(stateNode);
        InventoryUtils.saveTagsToNBT(stateNode, wandNode, ALL_PROPERTY_KEYS);
    }

    protected void loadState() {
        if (this.item == null) {
            return;
        }
        Object wandNode = InventoryUtils.getNode(this.item, "wand");
        if (wandNode == null) {
            return;
        }
        ConfigurationNode stateNode = new ConfigurationNode();
        InventoryUtils.loadTagsFromNBT(stateNode, wandNode, ALL_PROPERTY_KEYS);
        this.loadProperties(stateNode);
    }

    public void saveProperties(ConfigurationNode node) {
        node.setProperty("id", this.id);
        node.setProperty("materials", this.getMaterialString());
        node.setProperty("spells", this.getSpellString());
        node.setProperty("active_spell", this.activeSpell);
        node.setProperty("active_material", this.activeMaterial);
        node.setProperty("name", this.wandName);
        node.setProperty("description", this.description);
        node.setProperty("owner", this.owner);
        node.setProperty("cost_reduction", Float.valueOf(this.costReduction));
        node.setProperty("cooldown_reduction", Float.valueOf(this.cooldownReduction));
        node.setProperty("power", Float.valueOf(this.power));
        node.setProperty("protection", Float.valueOf(this.damageReduction));
        node.setProperty("protection_physical", Float.valueOf(this.damageReductionPhysical));
        node.setProperty("protection_projectiles", Float.valueOf(this.damageReductionProjectiles));
        node.setProperty("protection_falling", Float.valueOf(this.damageReductionFalling));
        node.setProperty("protection_fire", Float.valueOf(this.damageReductionFire));
        node.setProperty("protection_explosions", Float.valueOf(this.damageReductionExplosions));
        node.setProperty("haste", Float.valueOf(this.speedIncrease));
        node.setProperty("xp", this.xp);
        node.setProperty("xp_regeneration", this.xpRegeneration);
        node.setProperty("xp_max", this.xpMax);
        node.setProperty("health_regeneration", this.healthRegeneration);
        node.setProperty("hunger_regeneration", this.hungerRegeneration);
        node.setProperty("uses", this.uses);
        node.setProperty("locked", this.locked);
        node.setProperty("effect_color", Integer.toString(this.effectColor, 16));
        node.setProperty("effect_bubbles", this.effectBubbles);
        node.setProperty("effect_particle_data", Float.toString(this.effectParticleData));
        node.setProperty("effect_particle_count", this.effectParticleCount);
        node.setProperty("effect_particle_interval", this.effectParticleInterval);
        node.setProperty("effect_sound_interval", this.effectSoundInterval);
        node.setProperty("effect_sound_volume", Float.toString(this.effectSoundVolume));
        node.setProperty("effect_sound_pitch", Float.toString(this.effectSoundPitch));
        node.setProperty("quiet", this.quietLevel);
        node.setProperty("keep", this.keep);
        node.setProperty("bound", this.bound);
        node.setProperty("indestructible", this.indestructible);
        node.setProperty("fill", this.autoFill);
        node.setProperty("upgrade", this.isUpgrade);
        node.setProperty("organize", this.autoOrganize);
        if (this.effectSound != null) {
            node.setProperty("effect_sound", this.effectSound.name());
        } else {
            node.removeProperty("effectSound");
        }
        if (this.effectParticle != null) {
            node.setProperty("effect_particle", this.effectParticle.name());
        } else {
            node.removeProperty("effect_particle");
        }
        if (this.mode != null) {
            node.setProperty("mode", this.mode.name());
        } else {
            node.removeProperty("mode");
        }
        if (this.icon != null) {
            String iconKey = MaterialBrush.getMaterialKey(this.icon);
            if (iconKey != null && iconKey.length() > 0) {
                node.setProperty("icon", iconKey);
            } else {
                node.removeProperty("icon");
            }
        } else {
            node.removeProperty("icon");
        }
        if (this.template != null && this.template.length() > 0) {
            node.setProperty("template", this.template);
        } else {
            node.removeProperty(this.template);
        }
    }

    public void loadProperties(ConfigurationNode wandConfig) {
        this.loadProperties(wandConfig, false);
    }

    public void setEffectColor(String hexColor) {
        if (hexColor == null || hexColor.length() == 0) {
            this.effectColor = 0;
            return;
        }
        try {
            this.effectColor = hexColor.equals("random") ? (int)(Math.random() * 1.6777215E7) : Integer.parseInt(hexColor, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadProperties(ConfigurationNode wandConfig, boolean safe) {
        this.locked = wandConfig.getBoolean("locked", this.locked);
        float _costReduction = (float)wandConfig.getDouble("cost_reduction", this.costReduction);
        this.costReduction = safe ? Math.max(_costReduction, this.costReduction) : _costReduction;
        float _cooldownReduction = (float)wandConfig.getDouble("cooldown_reduction", this.cooldownReduction);
        this.cooldownReduction = safe ? Math.max(_cooldownReduction, this.cooldownReduction) : _cooldownReduction;
        float _power = (float)wandConfig.getDouble("power", this.power);
        this.power = safe ? Math.max(_power, this.power) : _power;
        float _damageReduction = (float)wandConfig.getDouble("protection", this.damageReduction);
        this.damageReduction = safe ? Math.max(_damageReduction, this.damageReduction) : _damageReduction;
        float _damageReductionPhysical = (float)wandConfig.getDouble("protection_physical", this.damageReductionPhysical);
        this.damageReductionPhysical = safe ? Math.max(_damageReductionPhysical, this.damageReductionPhysical) : _damageReductionPhysical;
        float _damageReductionProjectiles = (float)wandConfig.getDouble("protection_projectiles", this.damageReductionProjectiles);
        this.damageReductionProjectiles = safe ? Math.max(_damageReductionProjectiles, this.damageReductionPhysical) : _damageReductionProjectiles;
        float _damageReductionFalling = (float)wandConfig.getDouble("protection_falling", this.damageReductionFalling);
        this.damageReductionFalling = safe ? Math.max(_damageReductionFalling, this.damageReductionFalling) : _damageReductionFalling;
        float _damageReductionFire = (float)wandConfig.getDouble("protection_fire", this.damageReductionFire);
        this.damageReductionFire = safe ? Math.max(_damageReductionFire, this.damageReductionFire) : _damageReductionFire;
        float _damageReductionExplosions = (float)wandConfig.getDouble("protection_explosions", this.damageReductionExplosions);
        this.damageReductionExplosions = safe ? Math.max(_damageReductionExplosions, this.damageReductionExplosions) : _damageReductionExplosions;
        int _xpRegeneration = wandConfig.getInt("xp_regeneration", this.xpRegeneration);
        this.xpRegeneration = safe ? Math.max(_xpRegeneration, this.xpRegeneration) : _xpRegeneration;
        int _xpMax = wandConfig.getInt("xp_max", this.xpMax);
        this.xpMax = safe ? Math.max(_xpMax, this.xpMax) : _xpMax;
        int _xp = wandConfig.getInt("xp", this.xp);
        this.xp = safe ? Math.max(_xp, this.xp) : _xp;
        int _healthRegeneration = wandConfig.getInt("health_regeneration", this.healthRegeneration);
        this.healthRegeneration = safe ? Math.max(_healthRegeneration, this.healthRegeneration) : _healthRegeneration;
        int _hungerRegeneration = wandConfig.getInt("hunger_regeneration", this.hungerRegeneration);
        this.hungerRegeneration = safe ? Math.max(_hungerRegeneration, this.hungerRegeneration) : _hungerRegeneration;
        int _uses = wandConfig.getInt("uses", this.uses);
        this.uses = safe ? Math.max(_uses, this.uses) : _uses;
        float _speedIncrease = (float)wandConfig.getDouble("haste", this.speedIncrease);
        float f = this.speedIncrease = safe ? Math.max(_speedIncrease, this.speedIncrease) : _speedIncrease;
        if (wandConfig.containsKey("effect_color") && !safe) {
            this.setEffectColor(wandConfig.getString("effect_color"));
        }
        if (!safe) {
            this.id = wandConfig.getString("id", this.id);
            if (this.id == null) {
                this.id = "";
            }
            this.quietLevel = wandConfig.getInt("quiet", this.quietLevel);
            this.effectBubbles = wandConfig.getBoolean("effect_bubbles", this.effectBubbles);
            this.keep = wandConfig.getBoolean("keep", this.keep);
            this.indestructible = wandConfig.getBoolean("indestructible", this.indestructible);
            this.bound = wandConfig.getBoolean("bound", this.bound);
            this.autoOrganize = wandConfig.getBoolean("organize", this.autoOrganize);
            this.autoFill = wandConfig.getBoolean("fill", this.autoFill);
            this.isUpgrade = wandConfig.getBoolean("upgrade", this.isUpgrade);
            if (wandConfig.containsKey("effect_particle")) {
                this.parseParticleEffect(wandConfig.getString("effect_particle"));
                this.effectParticleData = 0.0f;
            }
            if (wandConfig.containsKey("effect_sound")) {
                this.parseSoundEffect(wandConfig.getString("effect_sound"));
            }
            this.effectParticleData = wandConfig.getFloat("effect_particle_data", this.effectParticleData);
            this.effectParticleCount = wandConfig.getInt("effect_particle_count", this.effectParticleCount);
            this.effectParticleInterval = wandConfig.getInt("effect_particle_interval", this.effectParticleInterval);
            this.effectSoundInterval = wandConfig.getInt("effect_sound_interval", this.effectSoundInterval);
            this.effectSoundVolume = wandConfig.getFloat("effect_sound_volume", this.effectSoundVolume);
            this.effectSoundPitch = wandConfig.getFloat("effect_sound_pitch", this.effectSoundPitch);
            this.setMode(Wand.parseWandMode(wandConfig.getString("mode"), this.mode));
            this.owner = wandConfig.getString("owner", this.owner);
            this.wandName = wandConfig.getString("name", this.wandName);
            this.description = wandConfig.getString("description", this.description);
            this.template = wandConfig.getString(this.template, this.template);
            this.activeSpell = wandConfig.getString("active_spell", this.activeSpell);
            this.activeMaterial = wandConfig.getString("active_material", this.activeMaterial);
            String wandMaterials = wandConfig.getString("materials", "");
            String wandSpells = wandConfig.getString("spells", "");
            if (wandMaterials.length() > 0 || wandSpells.length() > 0) {
                wandMaterials = wandMaterials.length() == 0 ? this.getMaterialString() : wandMaterials;
                wandSpells = wandSpells.length() == 0 ? this.getSpellString() : wandSpells;
                this.parseInventoryStrings(wandSpells, wandMaterials);
            }
            if (wandConfig.containsKey("icon")) {
                this.setIcon(wandConfig.getMaterialAndData("icon"));
            }
        }
        if (this.effectSound == null) {
            this.effectSoundInterval = 0;
            this.effectSoundVolume = 0.0f;
            this.effectSoundPitch = 0.0f;
        } else {
            this.effectSoundInterval = this.effectSoundInterval == 0 ? 5 : this.effectSoundInterval;
            this.effectSoundVolume = this.effectSoundVolume < 0.01f ? 0.8f : this.effectSoundVolume;
            float f2 = this.effectSoundPitch = this.effectSoundPitch < 0.01f ? 1.1f : this.effectSoundPitch;
        }
        if (this.effectParticle == null) {
            this.effectParticleInterval = 0;
        } else {
            this.effectParticleInterval = this.effectParticleInterval == 0 ? 2 : this.effectParticleInterval;
            int n = this.effectParticleCount = this.effectParticleCount == 0 ? 1 : this.effectParticleCount;
        }
        if (this.xpRegeneration <= 0 || this.xpMax <= 0 || this.costReduction >= 1.0f) {
            this.xpMax = 0;
            this.xpRegeneration = 0;
            this.xp = 0;
        }
        this.checkActiveMaterial();
        this.saveState();
        this.updateName();
        this.updateLore();
    }

    protected void parseSoundEffect(String effectSoundName) {
        if (effectSoundName.length() > 0) {
            String testName = effectSoundName.toUpperCase().replace("_", "");
            try {
                Sound[] soundArray = Sound.values();
                int n = soundArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Sound testType = soundArray[n2];
                    String testTypeName = testType.name().replace("_", "");
                    if (testTypeName.equals(testName)) {
                        this.effectSound = testType;
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                this.effectSound = null;
            }
        } else {
            this.effectSound = null;
        }
    }

    protected void parseParticleEffect(String effectParticleName) {
        if (effectParticleName.length() > 0) {
            String testName = effectParticleName.toUpperCase().replace("_", "");
            try {
                ParticleType[] particleTypeArray = ParticleType.values();
                int n = particleTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ParticleType testType = particleTypeArray[n2];
                    String testTypeName = testType.name().replace("_", "");
                    if (testTypeName.equals(testName)) {
                        this.effectParticle = testType;
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                this.effectParticle = null;
            }
        } else {
            this.effectParticle = null;
        }
    }

    public void describe(CommandSender sender) {
        Object wandNode = InventoryUtils.getNode(this.item, "wand");
        if (wandNode == null) {
            sender.sendMessage("Found a wand with missing NBT data. This may be an old wand, or something may have wiped its data");
            return;
        }
        ChatColor wandColor = this.isModifiable() ? ChatColor.AQUA : ChatColor.RED;
        sender.sendMessage(wandColor + this.wandName);
        if (this.description.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + ChatColor.GREEN + this.description);
        } else {
            sender.sendMessage(ChatColor.ITALIC + ChatColor.GREEN + "(No Description)");
        }
        if (this.owner.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + ChatColor.WHITE + this.owner);
        } else {
            sender.sendMessage(ChatColor.ITALIC + ChatColor.WHITE + "(No Owner)");
        }
        String[] stringArray = PROPERTY_KEYS;
        int n = PROPERTY_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = InventoryUtils.getMeta(wandNode, key);
            if (value != null && value.length() > 0) {
                sender.sendMessage(String.valueOf(key) + ": " + value);
            }
            ++n2;
        }
    }

    public boolean removeMaterial(String materialKey) {
        if (!this.isModifiable() || materialKey == null) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if (materialKey.equals(this.activeMaterial)) {
            this.activeMaterial = null;
        }
        List<Inventory> allInventories = this.getAllInventories();
        boolean found = false;
        block0: for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            int index = 0;
            while (index < items.length) {
                ItemStack itemStack = items[index];
                if (itemStack != null && Wand.isBrush(itemStack)) {
                    String itemKey = Wand.getMaterialKey(itemStack);
                    if (itemKey.equals(materialKey)) {
                        found = true;
                        inventory.setItem(index, null);
                    } else if (this.activeMaterial == null) {
                        this.activeMaterial = materialKey;
                    }
                    if (found && this.activeMaterial != null) continue block0;
                }
                ++index;
            }
        }
        this.updateActiveMaterial();
        this.updateInventory();
        this.updateName();
        this.updateLore();
        this.saveState();
        if (this.isInventoryOpen()) {
            this.updateInventory();
        }
        return found;
    }

    public boolean hasMaterial(String materialKey) {
        return this.getMaterialKeys().contains(materialKey);
    }

    public boolean hasSpell(String spellName) {
        return this.getSpells().contains(spellName);
    }

    public boolean addMaterial(String materialKey) {
        return this.addMaterial(materialKey, false, false);
    }

    public boolean addMaterial(String materialKey, boolean makeActive, boolean force) {
        boolean addedNew;
        if (!this.isModifiable() && !force) {
            return false;
        }
        boolean bl = addedNew = !this.hasMaterial(materialKey);
        if (addedNew) {
            this.addToInventory(this.createMaterialIcon(materialKey));
        }
        if (this.activeMaterial == null || this.activeMaterial.length() == 0 || makeActive) {
            this.setActiveMaterial(materialKey);
        } else {
            this.updateInventory();
        }
        this.updateLore();
        this.saveState();
        this.hasInventory = this.getSpells().size() + this.getMaterialKeys().size() > 1;
        return addedNew;
    }

    public boolean addMaterial(Material material, byte data, boolean makeActive, boolean force) {
        if (!this.isModifiable() && !force) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        String materialKey = MaterialBrush.getMaterialKey(material, data, false);
        return this.addMaterial(materialKey, makeActive, force);
    }

    public boolean removeSpell(String spellName) {
        if (!this.isModifiable()) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if (spellName.equals(this.activeSpell)) {
            this.activeSpell = null;
        }
        List<Inventory> allInventories = this.getAllInventories();
        boolean found = false;
        block0: for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            int index = 0;
            while (index < items.length) {
                ItemStack itemStack = items[index];
                if (itemStack != null && itemStack.getType() != Material.AIR && !Wand.isWand(itemStack) && Wand.isSpell(itemStack)) {
                    if (Wand.getSpell(itemStack).equals(spellName)) {
                        found = true;
                        inventory.setItem(index, null);
                    } else if (this.activeSpell == null) {
                        this.activeSpell = Wand.getSpell(itemStack);
                    }
                    if (found && this.activeSpell != null) continue block0;
                }
                ++index;
            }
        }
        this.updateName();
        this.updateLore();
        this.saveState();
        this.updateInventory();
        return found;
    }

    public boolean addSpell(String spellName, boolean makeActive) {
        if (!this.isModifiable()) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        boolean addedNew = !this.hasSpell(spellName);
        ItemStack spellItem = this.createSpellIcon(spellName);
        if (spellItem == null) {
            this.controller.getPlugin().getLogger().info("Unknown spell: " + spellName);
            return false;
        }
        if (addedNew) {
            this.addToInventory(spellItem);
        }
        if (makeActive) {
            this.setActiveSpell(spellName);
        } else {
            this.updateInventory();
        }
        this.hasInventory = this.getSpells().size() + this.getMaterialKeys().size() > 1;
        this.updateLore();
        this.saveState();
        return addedNew;
    }

    public boolean addSpell(String spellName) {
        return this.addSpell(spellName, false);
    }

    private static String getSpellDisplayName(Spell spell, String materialKey) {
        String name = "";
        if (spell != null) {
            if (materialKey != null && spell instanceof BrushSpell && !((BrushSpell)spell).hasBrushOverride()) {
                String materialName = MaterialBrush.getMaterialName(materialKey);
                if (materialName == null) {
                    materialName = "none";
                }
                name = ChatColor.GOLD + spell.getName() + ChatColor.GRAY + " " + materialName + ChatColor.WHITE;
            } else {
                name = ChatColor.GOLD + spell.getName() + ChatColor.WHITE;
            }
        }
        return name;
    }

    private String getActiveWandName(Spell spell, String materialKey) {
        int remaining;
        ChatColor wandColor = this.isModifiable() ? (this.bound ? ChatColor.DARK_AQUA : ChatColor.AQUA) : ChatColor.RED;
        String name = wandColor + this.wandName;
        if (spell != null) {
            name = String.valueOf(Wand.getSpellDisplayName(spell, materialKey)) + " (" + name + ChatColor.WHITE + ")";
        }
        if ((remaining = this.getRemainingUses()) > 0) {
            name = String.valueOf(name) + " : " + ChatColor.RED + Messages.get("wand.uses_remaining_brief").replace("$count", Integer.valueOf(remaining).toString());
        }
        return name;
    }

    private String getActiveWandName(Spell spell) {
        return this.getActiveWandName(spell, this.activeMaterial);
    }

    private String getActiveWandName() {
        Spell spell = null;
        if (this.hasInventory && this.activeSpell != null && this.activeSpell.length() > 0) {
            spell = this.controller.getSpell(this.activeSpell);
        }
        return this.getActiveWandName(spell);
    }

    public void updateName(boolean isActive) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(isActive ? this.getActiveWandName() : this.wandName);
        this.item.setItemMeta(meta);
        if (EnableGlow) {
            InventoryUtils.addGlow(this.item);
        }
        this.saveState();
    }

    private void updateName() {
        this.updateName(true);
    }

    protected static String convertToHTML(String line) {
        int tagCount = 1;
        line = "<span style=\"color:white\">" + line;
        ChatColor[] chatColorArray = ChatColor.values();
        int n = chatColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatColor c = chatColorArray[n2];
            tagCount += StringUtils.countMatches((String)line, (String)c.toString());
            String replaceStyle = "";
            if (c == ChatColor.ITALIC) {
                replaceStyle = "font-style: italic";
            } else if (c == ChatColor.BOLD) {
                replaceStyle = "font-weight: bold";
            } else if (c == ChatColor.UNDERLINE) {
                replaceStyle = "text-decoration: underline";
            } else {
                String color = c.name().toLowerCase().replace("_", "");
                if (c == ChatColor.LIGHT_PURPLE) {
                    color = "mediumpurple";
                }
                replaceStyle = "color:" + color;
            }
            line = line.replace(c.toString(), "<span style=\"" + replaceStyle + "\">");
            ++n2;
        }
        int i = 0;
        while (i < tagCount) {
            line = String.valueOf(line) + "</span>";
            ++i;
        }
        return line;
    }

    public String getHTMLDescription() {
        List<String> rawLore = this.getLore();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("<h2>" + Wand.convertToHTML(this.getActiveWandName()) + "</h2>");
        for (String line : rawLore) {
            lore.add(Wand.convertToHTML(line));
        }
        return "<div style=\"background-color: black; margin: 8px; padding: 8px\">" + StringUtils.join(lore, (String)"<br/>") + "</div>";
    }

    protected List<String> getLore() {
        return this.getLore(this.getSpells().size(), this.getMaterialKeys().size());
    }

    protected void addPropertyLore(List<String> lore) {
        if (this.usesMana()) {
            lore.add(ChatColor.LIGHT_PURPLE + ChatColor.ITALIC + this.getLevelString("wand.mana_amount", this.xpMax, 1000.0f));
            lore.add(ChatColor.RESET + ChatColor.LIGHT_PURPLE + this.getLevelString("wand.mana_regeneration", this.xpRegeneration, 50.0f));
        }
        if (this.costReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.cost_reduction", this.costReduction));
        }
        if (this.cooldownReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.cooldown_reduction", this.cooldownReduction));
        }
        if (this.power > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.power", this.power));
        }
        if (this.speedIncrease > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.haste", this.speedIncrease));
        }
        if (this.damageReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.protection", this.damageReduction));
        }
        if (this.damageReduction < 1.0f) {
            if (this.damageReductionPhysical > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString("wand.protection_physical", this.damageReductionPhysical));
            }
            if (this.damageReductionProjectiles > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString("wand.protection_projectile", this.damageReductionProjectiles));
            }
            if (this.damageReductionFalling > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString("wand.protection_fall", this.damageReductionFalling));
            }
            if (this.damageReductionFire > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString("wand.protection_fire", this.damageReductionFire));
            }
            if (this.damageReductionExplosions > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString("wand.protection_blast", this.damageReductionExplosions));
            }
        }
        if (this.healthRegeneration > 0) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.health_regeneration", this.healthRegeneration, 5.0f));
        }
        if (this.hungerRegeneration > 0) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.hunger_regeneration", this.hungerRegeneration, 5.0f));
        }
    }

    private String getLevelString(String templateName, float amount) {
        return this.getLevelString(templateName, amount, 1.0f);
    }

    private String getLevelString(String templateName, float amount, float max) {
        String templateString = Messages.get(templateName);
        if (templateString.contains("$roman")) {
            templateString = templateString.replace("$roman", this.getRomanString(amount));
        }
        return templateString.replace("$amount", Integer.toString((int)amount));
    }

    private String getRomanString(float amount) {
        String roman = "";
        roman = amount > 1.0f ? Messages.get("wand.enchantment_level_max") : ((double)amount > 0.8 ? Messages.get("wand.enchantment_level_5") : ((double)amount > 0.6 ? Messages.get("wand.enchantment_level_4") : ((double)amount > 0.4 ? Messages.get("wand.enchantment_level_3") : ((double)amount > 0.2 ? Messages.get("wand.enchantment_level_2") : Messages.get("wand.enchantment_level_1")))));
        return roman;
    }

    protected List<String> getLore(int spellCount, int materialCount) {
        ArrayList<String> lore = new ArrayList<String>();
        Spell spell = this.controller.getSpell(this.activeSpell);
        if (spell != null && spellCount == 1 && materialCount <= 1 && !this.isUpgrade) {
            Wand.addSpellLore(spell, lore, this);
        } else {
            if (this.description.length() > 0) {
                lore.add(ChatColor.ITALIC + ChatColor.GREEN + this.description);
            }
            if (!this.isUpgrade && this.owner.length() > 0) {
                String ownerDescription;
                if (this.bound) {
                    ownerDescription = Messages.get("wand.bound_description", "$name").replace("$name", this.owner);
                    lore.add(ChatColor.ITALIC + ChatColor.DARK_AQUA + ownerDescription);
                } else {
                    ownerDescription = Messages.get("wand.owner_description", "$name").replace("$name", this.owner);
                    lore.add(ChatColor.ITALIC + ChatColor.DARK_GREEN + ownerDescription);
                }
            }
            if (spellCount > 0) {
                if (this.isUpgrade) {
                    lore.add(Messages.get("wand.upgrade_spell_count").replace("$count", Integer.valueOf(spellCount).toString()));
                } else {
                    lore.add(Messages.get("wand.spell_count").replace("$count", Integer.valueOf(spellCount).toString()));
                }
            }
            if (materialCount > 0) {
                if (this.isUpgrade) {
                    lore.add(Messages.get("wand.material_count").replace("$count", Integer.valueOf(materialCount).toString()));
                } else {
                    lore.add(Messages.get("wand.upgrade_material_count").replace("$count", Integer.valueOf(materialCount).toString()));
                }
            }
        }
        int remaining = this.getRemainingUses();
        if (remaining > 0) {
            if (this.isUpgrade) {
                lore.add(ChatColor.RED + Messages.get("wand.upgrade_uses").replace("$count", Integer.valueOf(remaining).toString()));
            } else {
                lore.add(ChatColor.RED + Messages.get("wand.uses_remaining").replace("$count", Integer.valueOf(remaining).toString()));
            }
        }
        this.addPropertyLore(lore);
        if (this.isUpgrade) {
            lore.add(ChatColor.YELLOW + Messages.get("wand.upgrade_item_description"));
        }
        return lore;
    }

    protected void updateLore() {
        ItemMeta meta = this.item.getItemMeta();
        List<String> lore = this.getLore();
        meta.setLore(lore);
        this.item.setItemMeta(meta);
        if (EnableGlow) {
            InventoryUtils.addGlow(this.item);
        }
        this.saveState();
    }

    public int getRemainingUses() {
        return this.uses;
    }

    public void makeEnchantable(boolean enchantable) {
        if (!enchantable) {
            this.item.setType(this.icon.getMaterial());
            this.item.setDurability((short)this.icon.getData());
        } else {
            Set<Material> enchantableMaterials = this.controller.getMaterialSet("echantable");
            if (!enchantableMaterials.contains(this.item.getType())) {
                this.item.setType(EnchantableWandMaterial);
                this.item.setDurability((short)0);
            }
        }
        this.updateName();
    }

    public static boolean hasActiveWand(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static Wand getActiveWand(MagicController spells, Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        if (Wand.isWand(activeItem)) {
            return new Wand(spells, activeItem);
        }
        return null;
    }

    public static boolean isWand(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "wand");
    }

    public static boolean isWandUpgrade(ItemStack item) {
        if (item == null) {
            return false;
        }
        Object wandNode = InventoryUtils.getNode(item, "wand");
        if (wandNode == null) {
            return false;
        }
        String upgradeData = InventoryUtils.getMeta(wandNode, "upgrade");
        return upgradeData != null && upgradeData.equals("true");
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "spell");
    }

    public static boolean isBrush(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "brush");
    }

    public static String getSpell(ItemStack item) {
        if (!Wand.isSpell(item)) {
            return null;
        }
        Object spellNode = InventoryUtils.getNode(item, "spell");
        return InventoryUtils.getMeta(spellNode, "key");
    }

    public static String getMaterialKey(ItemStack item) {
        if (!Wand.isBrush(item)) {
            return null;
        }
        Object brushNode = InventoryUtils.getNode(item, "brush");
        return InventoryUtils.getMeta(brushNode, "key");
    }

    protected static String getMaterialKey(ItemStack itemStack, Integer index) {
        String materialKey = Wand.getMaterialKey(itemStack);
        if (materialKey == null) {
            return null;
        }
        if (index != null) {
            materialKey = String.valueOf(materialKey) + "@" + index;
        }
        return materialKey;
    }

    protected void updateInventoryName(ItemStack item, boolean activeName) {
        if (Wand.isSpell(item)) {
            Spell spell = this.mage.getSpell(Wand.getSpell(item));
            if (spell != null) {
                Wand.updateSpellName(item, spell, activeName ? this : null, this.activeMaterial, false);
            }
        } else if (Wand.isBrush(item)) {
            Wand.updateMaterialName(item, Wand.getMaterialKey(item), activeName ? this : null);
        }
    }

    protected static void updateSpellName(ItemStack itemStack, Spell spell, Wand wand, String activeMaterial, boolean isItem) {
        ItemMeta meta = itemStack.getItemMeta();
        String displayName = null;
        displayName = wand != null ? wand.getActiveWandName(spell) : Wand.getSpellDisplayName(spell, activeMaterial);
        meta.setDisplayName(displayName);
        ArrayList<String> lore = new ArrayList<String>();
        Wand.addSpellLore(spell, lore, wand);
        if (isItem) {
            lore.add(ChatColor.YELLOW + Messages.get("wand.spell_item_description"));
        }
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        InventoryUtils.addGlow(itemStack);
        Object spellNode = InventoryUtils.createNode(itemStack, "spell");
        InventoryUtils.setMeta(spellNode, "key", spell.getKey());
    }

    protected static void updateMaterialName(ItemStack itemStack, String materialKey, Wand wand) {
        ItemMeta meta = itemStack.getItemMeta();
        String displayName = null;
        displayName = wand != null ? wand.getActiveWandName(materialKey) : MaterialBrush.getMaterialName(materialKey);
        meta.setDisplayName(displayName);
        itemStack.setItemMeta(meta);
        Object brushNode = InventoryUtils.createNode(itemStack, "brush");
        InventoryUtils.setMeta(brushNode, "key", materialKey);
    }

    private void updateInventory() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.INVENTORY) {
            if (!this.mage.hasStoredInventory()) {
                return;
            }
            PlayerInventory inventory = player.getInventory();
            inventory.clear();
            this.updateHotbar(inventory);
            this.updateInventory((Inventory)inventory, 9, false);
            this.updateName();
            player.updateInventory();
        } else if (wandMode == WandMode.CHEST) {
            Inventory inventory = this.getDisplayInventory();
            inventory.clear();
            this.updateInventory(inventory, 0, true);
            player.updateInventory();
        }
    }

    private void updateHotbar(PlayerInventory playerInventory) {
        int currentSlot = playerInventory.getHeldItemSlot();
        ItemStack existingHotbar = this.hotbar.getItem(currentSlot);
        if (existingHotbar != null && existingHotbar.getType() != Material.AIR && !Wand.isWand(existingHotbar)) {
            this.addToInventory(existingHotbar);
            this.hotbar.setItem(currentSlot, null);
        }
        playerInventory.setItem(currentSlot, this.item);
        int hotbarSlot = 0;
        while (hotbarSlot < 9) {
            if (hotbarSlot != currentSlot) {
                ItemStack hotbarItem = this.hotbar.getItem(hotbarSlot);
                this.updateInventoryName(hotbarItem, true);
                playerInventory.setItem(hotbarSlot, hotbarItem);
            }
            ++hotbarSlot;
        }
    }

    private void updateInventory(Inventory targetInventory, int startOffset, boolean addHotbar) {
        int currentOffset = startOffset;
        if (this.openInventoryPage < this.inventories.size()) {
            Inventory inventory = this.inventories.get(this.openInventoryPage);
            ItemStack[] contents = inventory.getContents();
            int i = 0;
            while (i < contents.length) {
                ItemStack inventoryItem = contents[i];
                this.updateInventoryName(inventoryItem, false);
                targetInventory.setItem(currentOffset, inventoryItem);
                ++currentOffset;
                ++i;
            }
        }
        if (addHotbar) {
            int i = 0;
            while (i < 9) {
                ItemStack inventoryItem = this.hotbar.getItem(i);
                this.updateInventoryName(inventoryItem, false);
                targetInventory.setItem(currentOffset++, inventoryItem);
                ++i;
            }
        }
    }

    protected static void addSpellLore(Spell spell, List<String> lore, CostReducer reducer) {
        List<CastingCost> activeCosts;
        List<CastingCost> costs;
        String description = spell.getDescription();
        String usage = spell.getUsage();
        if (description != null && description.length() > 0) {
            lore.add(description);
        }
        if (usage != null && usage.length() > 0) {
            lore.add(usage);
        }
        if ((costs = spell.getCosts()) != null) {
            for (CastingCost cost : costs) {
                if (!cost.hasCosts(reducer)) continue;
                lore.add(ChatColor.YELLOW + Messages.get("wand.costs_description").replace("$description", cost.getFullDescription(reducer)));
            }
        }
        if ((activeCosts = spell.getActiveCosts()) != null) {
            for (CastingCost cost : activeCosts) {
                if (!cost.hasCosts(reducer)) continue;
                lore.add(ChatColor.YELLOW + Messages.get("wand.active_costs_description").replace("$description", cost.getFullDescription(reducer)));
            }
        }
    }

    protected Inventory getOpenInventory() {
        while (this.openInventoryPage >= this.inventories.size()) {
            this.inventories.add(InventoryUtils.createInventory(null, 27, "Wand"));
        }
        return this.inventories.get(this.openInventoryPage);
    }

    public void saveInventory() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        if (this.mage.getPlayer() == null) {
            return;
        }
        if (this.getMode() != WandMode.INVENTORY) {
            return;
        }
        if (!this.mage.hasStoredInventory()) {
            return;
        }
        Player player = this.mage.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        int i = 0;
        while (i < 9) {
            ItemStack playerItem = playerInventory.getItem(i);
            if (Wand.isWand(playerItem)) {
                playerItem = null;
            }
            this.hotbar.setItem(i, playerItem);
            ++i;
        }
        Inventory openInventory = this.getOpenInventory();
        int i2 = 0;
        while (i2 < openInventory.getSize()) {
            openInventory.setItem(i2, playerInventory.getItem(i2 + 9));
            ++i2;
        }
        this.saveState();
    }

    public static boolean isActive(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    protected void randomize(int totalLevels, boolean additive) {
        if (!wandTemplates.containsKey("random")) {
            return;
        }
        if (!additive) {
            this.wandName = Messages.get("wands.random.name", this.wandName);
        }
        int maxLevel = WandLevel.getMaxLevel();
        int addLevels = Math.min(totalLevels, maxLevel);
        while (addLevels > 0) {
            WandLevel.randomizeWand(this, additive, addLevels);
            addLevels = Math.min(totalLevels -= maxLevel, maxLevel);
            additive = true;
        }
    }

    public static Wand createWand(MagicController controller, String templateName) {
        Wand wand = null;
        try {
            wand = new Wand(controller, templateName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return wand;
    }

    public boolean add(Wand other) {
        Player player;
        if (!this.isModifiable() || !other.isModifiable()) {
            return false;
        }
        this.costReduction = Math.max(this.costReduction, other.costReduction);
        this.power = Math.max(this.power, other.power);
        this.damageReduction = Math.max(this.damageReduction, other.damageReduction);
        this.damageReductionPhysical = Math.max(this.damageReductionPhysical, other.damageReductionPhysical);
        this.damageReductionProjectiles = Math.max(this.damageReductionProjectiles, other.damageReductionProjectiles);
        this.damageReductionFalling = Math.max(this.damageReductionFalling, other.damageReductionFalling);
        this.damageReductionFire = Math.max(this.damageReductionFire, other.damageReductionFire);
        this.damageReductionExplosions = Math.max(this.damageReductionExplosions, other.damageReductionExplosions);
        this.healthRegeneration = Math.max(this.healthRegeneration, other.healthRegeneration);
        this.hungerRegeneration = Math.max(this.hungerRegeneration, other.hungerRegeneration);
        this.speedIncrease = Math.max(this.speedIncrease, other.speedIncrease);
        Color color1 = Color.fromBGR((int)this.effectColor);
        Color color2 = Color.fromBGR((int)other.effectColor);
        Color newColor = color1.mixColors(new Color[]{color2});
        this.effectColor = newColor.asRGB();
        this.keep = this.keep || other.keep;
        this.bound = this.bound || other.bound;
        boolean bl = this.effectBubbles = this.effectBubbles || other.effectBubbles;
        if (other.effectParticle != null && (other.isUpgrade || this.effectParticle == null)) {
            this.effectParticle = other.effectParticle;
            this.effectParticleData = other.effectParticleData;
            this.effectParticleCount = other.effectParticleCount;
            this.effectParticleInterval = other.effectParticleInterval;
        }
        if (other.effectSound != null && (other.isUpgrade || this.effectSound == null)) {
            this.effectSound = other.effectSound;
            this.effectSoundInterval = other.effectSoundInterval;
            this.effectSoundVolume = other.effectSoundVolume;
            this.effectSoundPitch = other.effectSoundPitch;
        }
        if (other.template != null && other.template.length() > 0) {
            this.template = other.template;
        }
        if (other.isUpgrade && other.mode != null) {
            this.setMode(other.mode);
        }
        if (this.costReduction >= 1.0f) {
            this.xpRegeneration = 0;
            this.xpMax = 0;
            this.xp = 0;
        } else {
            this.xpRegeneration = Math.max(this.xpRegeneration, other.xpRegeneration);
            this.xpMax = Math.max(this.xpMax, other.xpMax);
            this.xp = Math.max(this.xp, other.xp);
        }
        this.uses = this.uses == 0 || other.uses == 0 ? 0 : (this.uses += other.uses);
        Set<String> spells = other.getSpells();
        for (String spell : spells) {
            this.addSpell(spell, false);
        }
        Set<String> materials = other.getMaterialKeys();
        for (String material : materials) {
            this.addMaterial(material, false, true);
        }
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (other.autoFill && player != null) {
            this.fill(player);
        }
        if (other.autoOrganize && this.mage != null) {
            this.organizeInventory(this.mage);
        }
        this.saveState();
        this.updateName();
        this.updateLore();
        return true;
    }

    public boolean canUse(Player player) {
        if (!this.bound || this.owner == null || this.owner.length() == 0) {
            return true;
        }
        if (this.controller.hasPermission(player, "Magic.wand.override_bind", false)) {
            return true;
        }
        return this.owner.equalsIgnoreCase(player.getName());
    }

    public boolean keepOnDeath() {
        return this.keep;
    }

    public static void loadTemplates(ConfigurationNode properties) {
        wandTemplates.clear();
        List<String> wandKeys = properties.getKeys();
        for (String key : wandKeys) {
            ConfigurationNode wandNode = properties.getNode(key);
            wandNode.setProperty("key", key);
            ConfigurationNode existing = wandTemplates.get(key);
            if (existing != null) {
                List<String> overrideKeys = existing.getKeys();
                for (String propertyKey : overrideKeys) {
                    existing.setProperty(propertyKey, existing.getProperty(key));
                }
            } else {
                wandTemplates.put(key, wandNode);
            }
            if (!wandNode.getBoolean("enabled", true)) {
                wandTemplates.remove(key);
            }
            if (!key.equals("random")) continue;
            WandLevel.mapLevels(wandNode);
        }
    }

    public static Collection<String> getWandKeys() {
        return wandTemplates.keySet();
    }

    public static Collection<ConfigurationNode> getWandTemplates() {
        return wandTemplates.values();
    }

    public static WandMode parseWandMode(String modeString, WandMode defaultValue) {
        WandMode[] wandModeArray = WandMode.values();
        int n = wandModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            WandMode testMode = wandModeArray[n2];
            if (testMode.name().equalsIgnoreCase(modeString)) {
                return testMode;
            }
            ++n2;
        }
        return defaultValue;
    }

    private void updateActiveMaterial() {
        if (this.mage == null) {
            return;
        }
        if (this.activeMaterial == null) {
            this.mage.clearBuildingMaterial();
        } else {
            MaterialBrush brush = this.mage.getBrush();
            brush.update(this.activeMaterial);
        }
    }

    public void toggleInventory() {
        if (!this.hasInventory) {
            if (this.activeSpell != null && this.activeSpell.length() > 0) {
                this.activeSpell = "";
            } else {
                Set<String> spells = this.getSpells();
                if (spells.size() > 1) {
                    this.hasInventory = true;
                }
                if (spells.size() > 0) {
                    this.activeSpell = spells.iterator().next();
                }
            }
            this.updateName();
            return;
        }
        if (!this.isInventoryOpen()) {
            this.openInventory();
        } else {
            this.closeInventory();
        }
    }

    public void cycleInventory() {
        if (!this.hasInventory) {
            return;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
            this.openInventoryPage = (this.openInventoryPage + 1) % this.inventories.size();
            this.updateInventory();
            if (this.mage != null && this.inventories.size() > 1) {
                this.mage.playSound(Sound.CHEST_OPEN, 0.3f, 1.5f);
                this.mage.getPlayer().updateInventory();
            }
        }
    }

    private void openInventory() {
        if (this.mage == null) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.CHEST) {
            this.inventoryIsOpen = true;
            this.mage.playSound(Sound.CHEST_OPEN, 0.4f, 0.2f);
            this.updateInventory();
            this.mage.getPlayer().openInventory(this.getDisplayInventory());
        } else if (wandMode == WandMode.INVENTORY) {
            if (this.mage.hasStoredInventory()) {
                return;
            }
            if (this.mage.storeInventory()) {
                this.inventoryIsOpen = true;
                this.mage.playSound(Sound.CHEST_OPEN, 0.4f, 0.2f);
                this.updateInventory();
                this.mage.getPlayer().updateInventory();
            }
        }
    }

    public void closeInventory() {
        if (!this.isInventoryOpen()) {
            return;
        }
        this.saveInventory();
        this.inventoryIsOpen = false;
        if (this.mage != null) {
            this.mage.playSound(Sound.CHEST_CLOSE, 0.4f, 0.2f);
            if (this.getMode() == WandMode.INVENTORY) {
                this.mage.restoreInventory();
                Player player = this.mage.getPlayer();
                player.setItemInHand(this.item);
                player.updateInventory();
            } else {
                this.mage.getPlayer().closeInventory();
            }
        }
        this.saveState();
    }

    protected void updateSpeed(Player player) {
        if (this.speedIncrease > 0.0f) {
            try {
                float newWalkSpeed = this.defaultWalkSpeed + this.speedIncrease * WandLevel.maxWalkSpeedIncrease;
                newWalkSpeed = Math.min(WandLevel.maxWalkSpeed, newWalkSpeed);
                if (newWalkSpeed != player.getWalkSpeed()) {
                    player.setWalkSpeed(newWalkSpeed);
                }
                float newFlySpeed = this.defaultFlySpeed + this.speedIncrease * WandLevel.maxFlySpeedIncrease;
                if ((newFlySpeed = Math.min(WandLevel.maxFlySpeed, newFlySpeed)) != player.getFlySpeed()) {
                    player.setFlySpeed(newFlySpeed);
                }
            }
            catch (Exception ex2) {
                try {
                    player.setWalkSpeed(this.defaultWalkSpeed);
                    player.setFlySpeed(this.defaultFlySpeed);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void fill(Player player) {
        List<Spell> allSpells = this.controller.getAllSpells();
        for (Spell spell : allSpells) {
            if (!spell.hasSpellPermission(player) || spell.getIcon().getMaterial() == Material.AIR) continue;
            this.addSpell(spell.getKey());
        }
        this.autoFill = false;
        this.saveState();
    }

    public void activate(Mage mage) {
        Player player = mage.getPlayer();
        if (!Wand.hasActiveWand(player)) {
            this.controller.getLogger().warning("Wand activated without holding a wand!");
            try {
                throw new Exception("Wand activated without holding a wand!");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (!this.canUse(player)) {
            mage.sendMessage(Messages.get("wand.bound").replace("$name", this.owner));
            player.setItemInHand(null);
            Location location = player.getLocation();
            location.setY(location.getY() + 1.0);
            Item droppedItem = player.getWorld().dropItemNaturally(location, this.item);
            Vector velocity = droppedItem.getVelocity();
            velocity.setY(velocity.getY() * 2.0 + 1.0);
            droppedItem.setVelocity(velocity);
            return;
        }
        this.activate(mage, player.getItemInHand());
    }

    public void activate(Mage mage, ItemStack wandItem) {
        if (mage == null || wandItem == null) {
            return;
        }
        this.checkId();
        this.item = wandItem;
        this.mage = mage;
        Player player = mage.getPlayer();
        boolean modified = false;
        ItemStack[] items = player.getInventory().getContents();
        int i = 0;
        while (i < items.length) {
            ItemStack item = items[i];
            if (this.addItem(item)) {
                modified = true;
                items[i] = null;
            }
            ++i;
        }
        if (modified) {
            player.getInventory().setContents(items);
        }
        if (!this.isUpgrade && (this.controller.fillWands() || this.autoFill) && this.getSpells().size() == 0) {
            this.fill(mage.getPlayer());
        }
        if (this.autoOrganize && !this.isUpgrade) {
            this.organizeInventory(mage);
        }
        this.checkActiveMaterial();
        this.saveState();
        mage.setActiveWand(this);
        this.updateSpeed(player);
        if (this.usesMana()) {
            this.storedXpLevel = player.getLevel();
            this.storedXpProgress = player.getExp();
            this.storedXp = 0;
            this.updateMana();
        }
        this.updateActiveMaterial();
        this.updateName();
        this.updateLore();
        this.updateEffects();
    }

    protected void checkActiveMaterial() {
        Set<String> materials;
        if ((this.activeMaterial == null || this.activeMaterial.length() == 0) && (materials = this.getMaterialKeys()).size() > 0) {
            this.activeMaterial = materials.iterator().next();
        }
    }

    public boolean addItem(ItemStack item) {
        Wand wand;
        if (this.isUpgrade) {
            return false;
        }
        if (Wand.isSpell(item)) {
            Spell spell;
            String spellKey = Wand.getSpell(item);
            Set<String> spells = this.getSpells();
            if (!spells.contains(spellKey) && this.addSpell(spellKey) && (spell = this.controller.getSpell(spellKey)) != null) {
                this.mage.sendMessage(Messages.get("wand.spell_added").replace("$spell", spell.getName()));
                return true;
            }
        } else if (Wand.isBrush(item)) {
            String materialKey = Wand.getMaterialKey(item);
            Set<String> materials = this.getMaterialKeys();
            if (!materials.contains(materialKey) && this.addMaterial(materialKey)) {
                this.mage.sendMessage(Messages.get("wand.brush_added").replace("$brush", MaterialBrush.getMaterialName(materialKey)));
                return true;
            }
        } else if (Wand.isWandUpgrade(item) && this.add(wand = new Wand(this.controller, item))) {
            this.mage.sendMessage(Messages.get("wand.upgraded"));
            return true;
        }
        return false;
    }

    protected void updateEffects() {
        if (this.mage == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (this.effectBubbles) {
            InventoryUtils.addPotionEffect((LivingEntity)player, this.effectColor);
        }
        Location location = this.mage.getLocation();
        if (this.effectParticle != null && location != null && this.effectParticleCounter++ % this.effectParticleInterval == 0) {
            if (this.effectPlayer == null) {
                this.effectPlayer = new EffectRing((Plugin)this.controller.getPlugin());
                this.effectPlayer.setParticleCount(2);
                this.effectPlayer.setIterations(2);
                this.effectPlayer.setRadius(2.0f);
                this.effectPlayer.setSize(5);
                this.effectPlayer.setMaterial(location.getBlock().getRelative(BlockFace.DOWN));
            }
            this.effectPlayer.setParticleType(this.effectParticle);
            this.effectPlayer.setParticleData(this.effectParticleData);
            this.effectPlayer.setParticleCount(this.effectParticleCount);
            this.effectPlayer.start(player.getEyeLocation(), null);
        }
        if (this.effectSound != null && location != null && this.controller.soundsEnabled() && this.effectSoundCounter++ % this.effectSoundInterval == 0) {
            this.mage.getLocation().getWorld().playSound(location, this.effectSound, this.effectSoundVolume, this.effectSoundPitch);
        }
    }

    protected void updateMana() {
        if (this.mage != null && this.xpMax > 0 && this.xpRegeneration > 0) {
            Player player = this.mage.getPlayer();
            if (displayManaAsBar) {
                player.setLevel(0);
                player.setExp((float)this.xp / (float)this.xpMax);
            } else {
                player.setLevel(this.xp);
                player.setExp(0.0f);
            }
        }
    }

    public boolean isInventoryOpen() {
        return this.mage != null && this.inventoryIsOpen;
    }

    public void deactivate() {
        if (this.mage == null) {
            return;
        }
        this.saveState();
        if (this.effectBubbles) {
            InventoryUtils.removePotionEffect((LivingEntity)this.mage.getPlayer());
        }
        this.mage.deactivateAllSpells();
        if (this.isInventoryOpen()) {
            this.closeInventory();
        }
        this.mage.restoreInventory();
        if (this.usesMana()) {
            this.mage.getPlayer().setExp(this.storedXpProgress);
            this.mage.getPlayer().setLevel(this.storedXpLevel);
            this.mage.getPlayer().giveExp(this.storedXp);
            this.storedXp = 0;
            this.storedXpProgress = 0.0f;
            this.storedXpLevel = 0;
        }
        if (this.speedIncrease > 0.0f) {
            try {
                this.mage.getPlayer().setWalkSpeed(this.defaultWalkSpeed);
                this.mage.getPlayer().setFlySpeed(this.defaultFlySpeed);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mage.setActiveWand(null);
        this.mage = null;
    }

    public Spell getActiveSpell() {
        if (this.mage == null || this.activeSpell == null || this.activeSpell.length() == 0) {
            return null;
        }
        return this.mage.getSpell(this.activeSpell);
    }

    public boolean cast() {
        Spell spell = this.getActiveSpell();
        if (spell != null && spell.cast()) {
            this.use();
            return true;
        }
        return false;
    }

    protected void use() {
        if (this.mage == null) {
            return;
        }
        if (this.uses > 0) {
            --this.uses;
            if (this.uses <= 0) {
                Player player = this.mage.getPlayer();
                this.mage.playSound(Sound.ITEM_BREAK, 1.0f, 0.8f);
                PlayerInventory playerInventory = player.getInventory();
                playerInventory.setItemInHand(new ItemStack(Material.AIR, 1));
                player.updateInventory();
                this.deactivate();
            } else {
                this.updateName();
                this.updateLore();
                this.saveState();
            }
        }
    }

    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        if (this.mage == null) {
            return;
        }
        if (this.usesMana()) {
            this.storedXp += event.getAmount();
            event.setAmount(0);
        }
    }

    public void tick() {
        if (this.mage == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        this.updateSpeed(player);
        if (this.usesMana()) {
            this.xp = Math.min(this.xpMax, this.xp + this.xpRegeneration);
            this.updateMana();
        }
        double maxHealth = player.getMaxHealth();
        if (this.healthRegeneration > 0 && player.getHealth() < maxHealth) {
            player.setHealth(Math.min(maxHealth, player.getHealth() + (double)this.healthRegeneration));
        }
        double maxFoodLevel = 20.0;
        if (this.hungerRegeneration > 0 && (double)player.getFoodLevel() < maxFoodLevel) {
            player.setExhaustion(0.0f);
            player.setFoodLevel(Math.min(20, player.getFoodLevel() + this.hungerRegeneration));
        }
        if (this.damageReductionFire > 0.0f && player.getFireTicks() > 0) {
            player.setFireTicks(0);
        }
        this.updateEffects();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Wand)) {
            return false;
        }
        Wand otherWand = (Wand)other;
        if (this.id.length() == 0 || otherWand.id.length() == 0) {
            return false;
        }
        return otherWand.id.equals(this.id);
    }

    public MagicController getMaster() {
        return this.controller;
    }

    public void cycleSpells(ItemStack newItem) {
        Set<String> spellsSet;
        ArrayList<String> spells;
        if (Wand.isWand(newItem)) {
            this.item = newItem;
        }
        if ((spells = new ArrayList<String>(spellsSet = this.getSpells())).size() == 0) {
            return;
        }
        if (this.activeSpell == null) {
            this.activeSpell = spells.get(0).split("@")[0];
            return;
        }
        int spellIndex = 0;
        int i = 0;
        while (i < spells.size()) {
            if (spells.get(i).split("@")[0].equals(this.activeSpell)) {
                spellIndex = i;
                break;
            }
            ++i;
        }
        spellIndex = (spellIndex + 1) % spells.size();
        this.setActiveSpell(spells.get(spellIndex).split("@")[0]);
    }

    public void cycleMaterials(ItemStack newItem) {
        Set<String> materialsSet;
        ArrayList<String> materials;
        if (Wand.isWand(newItem)) {
            this.item = newItem;
        }
        if ((materials = new ArrayList<String>(materialsSet = this.getMaterialKeys())).size() == 0) {
            return;
        }
        if (this.activeMaterial == null) {
            this.activeMaterial = materials.get(0).split("@")[0];
            return;
        }
        int materialIndex = 0;
        int i = 0;
        while (i < materials.size()) {
            if (materials.get(i).split("@")[0].equals(this.activeMaterial)) {
                materialIndex = i;
                break;
            }
            ++i;
        }
        materialIndex = (materialIndex + 1) % materials.size();
        this.activateBrush(materials.get(materialIndex).split("@")[0]);
    }

    public boolean hasExperience() {
        return this.xpRegeneration > 0;
    }

    public void organizeInventory(Mage mage) {
        WandOrganizer organizer = new WandOrganizer(this, mage);
        organizer.organize();
        this.openInventoryPage = 0;
        this.autoOrganize = false;
        this.saveState();
    }

    public Mage getActivePlayer() {
        return this.mage;
    }

    public String getId() {
        return this.id;
    }

    protected void clearInventories() {
        this.inventories.clear();
        this.hotbar.clear();
    }

    public int getEffectColor() {
        return this.effectColor;
    }

    public Inventory getHotbar() {
        return this.hotbar;
    }

    public WandMode getMode() {
        return this.mode != null ? this.mode : this.controller.getDefaultWandMode();
    }

    public void setMode(WandMode mode) {
        this.mode = mode;
    }

    public boolean showCastMessages() {
        return this.quietLevel == 0;
    }

    public boolean showMessages() {
        return this.quietLevel < 2;
    }
}

