/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.SimulateBatch;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SimulateSpell
extends BlockSpell {
    private static final int DEFAULT_RADIUS = 32;
    private Integer taskId = null;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        Target t = this.getTarget();
        if (t == null) {
            return SpellResult.NO_TARGET;
        }
        Block target = t.getBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", 32);
        radius = parameters.getInt("r", radius);
        radius = (int)((float)radius * this.mage.getConstructionMultiplier());
        int yRadius = parameters.getInt("yradius", 0);
        yRadius = (int)((float)yRadius * this.mage.getConstructionMultiplier());
        MaterialAndData birthMaterial = new MaterialAndData(target);
        birthMaterial = parameters.getMaterialAndData("material", birthMaterial);
        birthMaterial = parameters.getMaterialAndData("m", birthMaterial);
        Double dmxValue = parameters.getDouble("omx", null);
        Double dmyValue = parameters.getDouble("omy", null);
        Double dmzValue = parameters.getDouble("omz", null);
        if (dmxValue != null || dmyValue != null || dmzValue != null) {
            Vector offset = new Vector(dmxValue == null ? 0.0 : dmxValue, dmyValue == null ? 0.0 : dmyValue, dmzValue == null ? 0.0 : dmzValue);
            Location targetLocation = target.getLocation().add(offset);
            if (!targetLocation.getBlock().getChunk().isLoaded()) {
                return SpellResult.FAIL;
            }
            birthMaterial = new MaterialAndData(targetLocation.getBlock());
        }
        Material deathMaterial = parameters.getMaterial("death_material", Material.AIR);
        Location location = this.getLocation();
        Location targetLocation = target.getLocation();
        targetLocation.setPitch(location.getPitch());
        targetLocation.setYaw(location.getYaw());
        HashSet<Integer> birthCounts = new HashSet<Integer>();
        HashSet<Integer> liveCounts = new HashSet<Integer>();
        Double dlcxValue = parameters.getDouble("olcx", null);
        Double dlcyValue = parameters.getDouble("olcy", null);
        Double dlczValue = parameters.getDouble("olcz", null);
        if (dlcxValue != null || dlczValue != null || dlczValue != null) {
            Location liveChestLocation = targetLocation.clone().add(new Vector(dlcxValue == null ? 0.0 : dlcxValue, dlcyValue == null ? 0.0 : dlcyValue, dlczValue == null ? 0.0 : dlczValue));
            Block chestBlock = liveChestLocation.getBlock();
            BlockState chestState = chestBlock.getState();
            if (chestState instanceof InventoryHolder) {
                ItemStack[] items = ((InventoryHolder)chestState).getInventory().getContents();
                int index = 0;
                while (index < items.length) {
                    if (items[index] != null && items[index].getType() != Material.AIR) {
                        liveCounts.add(index + 1);
                    }
                    ++index;
                }
            } else {
                this.controller.getLogger().warning("SimulateSpell: Chest for live rules not found at " + liveChestLocation.toVector());
            }
        } else if (parameters.containsKey("live_rules")) {
            liveCounts.addAll(parameters.getIntList("live_rules", new ArrayList<Integer>()));
        } else {
            liveCounts.add(2);
            liveCounts.add(3);
        }
        Double dbcxValue = parameters.getDouble("obcx", null);
        Double dbcyValue = parameters.getDouble("obcy", null);
        Double dbczValue = parameters.getDouble("obcz", null);
        if (dbcxValue != null || dbczValue != null || dbczValue != null) {
            Location birthChestLocation = targetLocation.clone().add(new Vector(dbcxValue == null ? 0.0 : dbcxValue, dbcyValue == null ? 0.0 : dbcyValue, dbczValue == null ? 0.0 : dbczValue));
            Block chestBlock = birthChestLocation.getBlock();
            BlockState chestState = chestBlock.getState();
            if (chestState instanceof InventoryHolder) {
                ItemStack[] items = ((InventoryHolder)chestState).getInventory().getContents();
                int index = 0;
                while (index < items.length) {
                    if (items[index] != null && items[index].getType() != Material.AIR) {
                        birthCounts.add(index + 1);
                    }
                    ++index;
                }
            } else {
                this.controller.getLogger().warning("SimulateSpell: Chest for birth rules not found at " + birthChestLocation.toVector());
            }
        } else if (parameters.containsKey("birth_rules")) {
            birthCounts.addAll(parameters.getIntList("birth_rules", new ArrayList<Integer>()));
        } else {
            birthCounts.add(3);
        }
        if (liveCounts.size() == 0 || birthCounts.size() == 0) {
            return SpellResult.FAIL;
        }
        final SimulateBatch batch = new SimulateBatch(this, targetLocation, radius, yRadius, birthMaterial, deathMaterial, liveCounts, birthCounts);
        boolean includeCommands = parameters.getBoolean("animate", false);
        if (includeCommands) {
            if (this.mage.getCommandSender() instanceof BlockCommandSender) {
                BlockCommandSender commandBlock = (BlockCommandSender)this.mage.getCommandSender();
                batch.setCommandBlock(commandBlock.getBlock());
            } else if (target.getType() == Material.COMMAND) {
                batch.setCommandBlock(target);
            }
            SimulateBatch.TargetMode targetMode = null;
            String targetModeString = parameters.getString("target_mode", "");
            if (targetModeString.length() > 0) {
                try {
                    targetMode = SimulateBatch.TargetMode.valueOf(targetModeString.toUpperCase());
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning(ex.getMessage());
                }
            }
            batch.setCommandMoveRange(parameters.getInt("move", 3), parameters.getBoolean("reload", true));
            SimulateBatch.TargetType targetType = null;
            String targetTypeString = parameters.getString("target_types", "");
            if (targetTypeString.length() > 0) {
                try {
                    targetType = SimulateBatch.TargetType.valueOf(targetTypeString.toUpperCase());
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning(ex.getMessage());
                }
            }
            batch.setTargetType(targetType);
            batch.setMinHuntRange(parameters.getInt("target_min_range", 4));
            batch.setMaxHuntRange(parameters.getInt("target_max_range", 128));
            batch.setTickCast(parameters.getString("cast", ""), parameters.getFloat("cast_probability", 1.0f));
            batch.setDeathCast(parameters.getString("death_cast", ""));
            batch.target(targetMode);
            batch.setDrop(parameters.getString("drop"));
        }
        batch.setBirthRange(parameters.getInt("birth_range", 0));
        batch.setLiveRange(parameters.getInt("live_range", 0));
        int delay = parameters.getInt("delay", 0);
        boolean success = true;
        if ((delay /= 50) > 0 && this.taskId == null) {
            this.taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    SimulateSpell.this.taskId = null;
                    SimulateSpell.this.mage.addPendingBlockBatch(batch);
                }
            }, (long)delay);
        } else {
            success = this.mage.addPendingBlockBatch(batch);
        }
        this.clearTarget();
        return success ? SpellResult.CAST : SpellResult.FAIL;
    }
}

