/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.effects.EffectUtils;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.MagicPlugin;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.wand.LostWand;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RecallSpell
extends Spell {
    public Location location;
    public boolean isActive;
    private static int MAX_RETRY_COUNT = 8;
    private static int RETRY_INTERVAL = 10;
    private int retryCount = 0;
    private boolean allowCrossWorld = true;
    private int selectedWarpIndex = 0;
    private List<String> warps = new ArrayList<String>();
    private RecallType selectedType = RecallType.MARKER;
    private int selectedTypeIndex = 0;
    private List<RecallType> enabledTypes = new ArrayList<RecallType>();

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        Player player;
        boolean allowMarker = true;
        this.selectedTypeIndex = 0;
        int cycleRetries = 5;
        this.enabledTypes.clear();
        this.warps = null;
        this.allowCrossWorld = parameters.getBoolean("cross_world", true);
        RecallType[] recallTypeArray = RecallType.values();
        int n = recallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RecallType testType = recallTypeArray[n2];
            if (testType == RecallType.WARPS) {
                if (parameters.containsKey("allow_warps")) {
                    this.warps = parameters.getStringList("allow_warps");
                    this.enabledTypes.add(testType);
                    if (testType == this.selectedType) {
                        this.selectedTypeIndex = this.enabledTypes.size() - 1;
                    }
                }
            } else if (parameters.getBoolean("allow_" + testType.name().toLowerCase(), true)) {
                this.enabledTypes.add(testType);
                if (testType == this.selectedType) {
                    this.selectedTypeIndex = this.enabledTypes.size() - 1;
                }
            } else if (testType == RecallType.MARKER) {
                allowMarker = false;
            }
            ++n2;
        }
        boolean reverseDirection = false;
        if (parameters.containsKey("type")) {
            cycleRetries = 0;
            String typeString = parameters.getString("type", "");
            if (this.isActive && typeString.equalsIgnoreCase("remove")) {
                this.removeMarker();
                return SpellResult.TARGET_SELECTED;
            }
            RecallType newType = RecallType.valueOf(typeString.toUpperCase());
            if (newType == null) {
                this.controller.getLogger().warning("Unknown recall type " + typeString);
                return SpellResult.FAIL;
            }
            this.selectedType = newType;
        } else if (this.getYRotation() > 70.0 || this.getYRotation() < -70.0 || !allowMarker) {
            reverseDirection = this.getYRotation() < 70.0;
            this.cycleTarget(reverseDirection);
        } else {
            Target target = this.getTarget();
            if (!target.isValid()) {
                return SpellResult.NO_TARGET;
            }
            return this.placeMarker(target.getBlock()) ? SpellResult.CAST : SpellResult.FAIL;
        }
        if (this.selectedType == null) {
            if (this.enabledTypes.size() == 0) {
                return SpellResult.FAIL;
            }
            this.selectedType = this.enabledTypes.get(0);
        }
        if ((player = this.getPlayer()) == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        boolean success = false;
        while (!success && cycleRetries >= 0) {
            success = this.tryCurrentType(player, cycleRetries == 0);
            if (!success && cycleRetries > 0) {
                this.cycleTarget(reverseDirection);
            }
            --cycleRetries;
        }
        return success ? SpellResult.CAST : SpellResult.FAIL;
    }

    protected void cycleTargetType(boolean reverse) {
        this.selectedTypeIndex = reverse ? --this.selectedTypeIndex : ++this.selectedTypeIndex;
        if (this.selectedTypeIndex < 0) {
            this.selectedTypeIndex = this.enabledTypes.size() - 1;
        }
        if (this.selectedTypeIndex >= this.enabledTypes.size()) {
            this.selectedTypeIndex = 0;
        }
        this.selectedType = this.enabledTypes.get(this.selectedTypeIndex);
        if (this.selectedType == RecallType.WARPS) {
            this.selectedWarpIndex = reverse ? this.warps.size() - 1 : 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void cycleTarget(boolean reverse) {
        if (this.selectedType == RecallType.WARPS) {
            if (reverse) {
                --this.selectedWarpIndex;
                if (this.selectedWarpIndex >= 0) return;
                this.selectedWarpIndex = this.warps.size() - 1;
            } else {
                ++this.selectedWarpIndex;
                if (this.selectedWarpIndex < this.warps.size()) return;
                this.selectedWarpIndex = 0;
            }
        }
        this.cycleTargetType(reverse);
    }

    protected boolean tryCurrentType(Player player, boolean showFailMessage) {
        switch (this.selectedType) {
            case MARKER: {
                if (!this.isActive) {
                    return this.placeMarker(this.getLocation().getBlock());
                }
                return this.tryTeleport(this.location, this.getMessage("cast_marker"));
            }
            case DEATH: {
                Location deathLocation = this.mage.getLastDeathLocation();
                if (deathLocation == null) {
                    if (showFailMessage) {
                        this.sendMessage(this.getMessage("no_target_death"));
                    }
                    return false;
                }
                return this.tryTeleport(deathLocation, this.getMessage("cast_death"));
            }
            case SPAWN: {
                return this.tryTeleport(this.getWorld().getSpawnLocation(), this.getMessage("cast_spawn"));
            }
            case HOME: {
                Location bedLocation = player.getBedSpawnLocation();
                if (bedLocation == null) {
                    if (showFailMessage) {
                        this.castMessage(this.getMessage("no_target_home"));
                    }
                    return false;
                }
                return this.tryTeleport(bedLocation, this.getMessage("cast_home"));
            }
            case WAND: {
                Location wandLocation;
                List<LostWand> lostWands = this.mage.getLostWands();
                Location location = wandLocation = lostWands.size() > 0 ? lostWands.get(0).getLocation() : null;
                if (wandLocation == null) {
                    if (showFailMessage) {
                        this.sendMessage(this.getMessage("no_target_wand"));
                    }
                    return false;
                }
                return this.tryTeleport(wandLocation, this.getMessage("cast_wand"));
            }
            case WARPS: {
                if (this.warps == null || this.selectedWarpIndex < 0 || this.selectedWarpIndex >= this.warps.size()) {
                    return false;
                }
                String warpName = this.warps.get(this.selectedWarpIndex);
                Location warpLocation = this.controller.getWarp(warpName);
                if (warpLocation == null) {
                    return false;
                }
                return this.tryTeleport(warpLocation, this.getMessage("cast_warp").replace("$name", warpName));
            }
        }
        return false;
    }

    protected boolean removeMarker() {
        if (!this.isActive || this.location == null) {
            return false;
        }
        this.isActive = false;
        return true;
    }

    protected boolean tryTeleport(final Location targetLocation, final String message) {
        Player player;
        if (!this.allowCrossWorld && !this.mage.getLocation().getWorld().equals(targetLocation.getWorld())) {
            this.sendMessage(this.getMessage("cross_world_disallowed"));
            return false;
        }
        Chunk chunk = targetLocation.getBlock().getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
            if (this.retryCount < MAX_RETRY_COUNT) {
                MagicPlugin plugin = this.controller.getPlugin();
                final RecallSpell me = this;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                    @Override
                    public void run() {
                        me.tryTeleport(targetLocation, message);
                    }
                }, (long)RETRY_INTERVAL);
                return true;
            }
        }
        if ((player = this.getPlayer()) != null) {
            if (!this.isActive) {
                this.placeMarker(this.getLocation().getBlock());
            }
            Location playerLocation = player.getLocation();
            targetLocation.setYaw(playerLocation.getYaw());
            targetLocation.setPitch(playerLocation.getPitch());
            player.teleport(this.tryFindPlaceToStand(targetLocation));
            this.castMessage(message);
        }
        return true;
    }

    protected boolean placeMarker(Block target) {
        if (target == null) {
            return false;
        }
        Block targetBlock = target.getRelative(BlockFace.UP);
        if (targetBlock.getType() != Material.AIR) {
            targetBlock = this.getFaceBlock();
        }
        if (targetBlock.getType() != Material.AIR) {
            return false;
        }
        if (this.removeMarker()) {
            this.castMessage(this.getMessage("cast_marker_move"));
        } else {
            this.castMessage(this.getMessage("cast_marker_place"));
        }
        this.location = this.getLocation();
        this.location.setX((double)targetBlock.getX());
        this.location.setY((double)targetBlock.getY());
        this.location.setZ((double)targetBlock.getZ());
        this.getPlayer().setCompassTarget(this.location);
        EffectUtils.playEffect(targetBlock.getLocation(), ParticleType.CLOUD, 1.0f, 1);
        this.isActive = true;
        return true;
    }

    @Override
    public void onLoad(ConfigurationNode node) {
        this.isActive = node.getBoolean("active", false);
        this.location = node.getLocation("location");
    }

    @Override
    public void onSave(ConfigurationNode node) {
        node.setProperty("active", this.isActive);
        node.setProperty("location", this.location);
    }

    private static enum RecallType {
        MARKER,
        DEATH,
        SPAWN,
        HOME,
        WAND,
        WARPS;

    }
}

