/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class PushSpell
extends Spell {
    private int DEFAULT_ITEM_MAGNITUDE = 1;
    private int DEFAULT_ENTITY_MAGNITUDE = 3;
    private int DEFAULT_MAX_ALL_DISTANCE = 20;

    public void forceAll(double mutliplier, boolean pull, int entityMagnitude, int itemMagnitude, int maxAllDistance) {
        float maxDistance = (float)maxAllDistance * this.mage.getRangeMultiplier();
        float maxDistanceSquared = maxDistance * maxDistance;
        List entities = this.getWorld().getEntities();
        for (Entity target : entities) {
            Location targetLocation;
            Location playerLocation;
            if (target == this.getPlayer() || target.hasMetadata("NPC") || (playerLocation = this.getLocation()).distanceSquared(targetLocation = target.getLocation()) > (double)maxDistanceSquared) continue;
            Location to = pull ? targetLocation : playerLocation;
            Location from = pull ? playerLocation : targetLocation;
            int magnitude = target instanceof LivingEntity ? entityMagnitude : itemMagnitude;
            this.forceEntity(target, mutliplier, from, to, magnitude);
        }
    }

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        boolean push = false;
        boolean pull = false;
        String typeString = parameters.getString("type", "");
        push = typeString.equals("push");
        pull = typeString.equals("pull");
        double multiplier = parameters.getDouble("size", 1.0);
        if (push) {
            multiplier *= (double)this.mage.getDamageMultiplier();
        }
        int count = parameters.getInt("count", 0);
        boolean allowAll = parameters.getBoolean("allow_area", true);
        int itemMagnitude = parameters.getInt("item_force", this.DEFAULT_ITEM_MAGNITUDE);
        int entityMagnitude = parameters.getInt("entity_force", this.DEFAULT_ENTITY_MAGNITUDE);
        int maxAllDistance = parameters.getInt("area_range", this.DEFAULT_MAX_ALL_DISTANCE);
        List<Target> targets = this.getAllTargetEntities();
        if (allowAll && (this.getYRotation() < -80.0 || this.getYRotation() > 80.0)) {
            this.forceAll(multiplier, pull, entityMagnitude, itemMagnitude, maxAllDistance);
            return SpellResult.AREA;
        }
        if (targets.size() == 0) {
            return SpellResult.COST_FREE;
        }
        int pushed = 0;
        for (Target target : targets) {
            Entity targetEntity = target.getEntity();
            Location to = pull ? target.getLocation() : this.getLocation();
            Location from = pull ? this.getLocation() : target.getLocation();
            int magnitude = target instanceof LivingEntity ? entityMagnitude : itemMagnitude;
            this.forceEntity(targetEntity, multiplier, from, to, magnitude);
            if (count > 0 && ++pushed >= count) break;
        }
        return SpellResult.CAST;
    }

    protected void forceEntity(Entity target, double multiplier, Location from, Location to, int magnitude) {
        Vector fromVector;
        Mage targetMage;
        if (target instanceof Player && (targetMage = this.controller.getMage((Player)target)).isSuperProtected()) {
            return;
        }
        magnitude = (int)((double)magnitude * multiplier);
        Vector toVector = new Vector(to.getBlockX(), to.getBlockY(), to.getBlockZ());
        Vector forceVector = fromVector = new Vector(from.getBlockX(), from.getBlockY(), from.getBlockZ());
        forceVector.subtract(toVector);
        forceVector.normalize();
        forceVector.multiply(magnitude);
        target.setVelocity(forceVector);
    }
}

