/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.effects.EffectRing;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class FlingSpell
extends Spell {
    private final long safetyLength = 20000L;
    private long lastFling = 0L;
    protected int defaultMaxSpeedAtElevation = 64;
    protected double defaultMinMagnitude = 1.5;
    protected double defaultMaxMagnitude = 4.0;
    private static final int effectSpeed = 1;
    private static final int effectPeriod = 3;
    private static final int minRingEffectRange = 2;
    private static final int maxRingEffectRange = 15;
    private static final int maxDamageAmount = 200;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        int height = 0;
        Block playerBlock = this.getLocation().getBlock();
        int maxSpeedAtElevation = parameters.getInt("cruising_altitude", this.defaultMaxSpeedAtElevation);
        double minMagnitude = parameters.getDouble("min_speed", this.defaultMinMagnitude);
        double maxMagnitude = parameters.getDouble("max_speed", this.defaultMaxMagnitude);
        double yOffset = parameters.getDouble("yo", 0.0);
        Double yValue = parameters.getDouble("dy", null);
        Double xValue = parameters.getDouble("dx", null);
        Double zValue = parameters.getDouble("dz", null);
        while (height < maxSpeedAtElevation && playerBlock.getType() == Material.AIR) {
            playerBlock = playerBlock.getRelative(BlockFace.DOWN);
            ++height;
        }
        double heightModifier = maxSpeedAtElevation > 0 ? (double)height / (double)maxSpeedAtElevation : 1.0;
        double magnitude = minMagnitude + (maxMagnitude - minMagnitude) * heightModifier;
        Vector velocity = this.mage.getLocation().getDirection();
        if (yValue != null) {
            velocity.setY(yValue.doubleValue());
        } else if (yOffset > 0.0) {
            velocity.setY(velocity.getY() + yOffset);
        }
        if (xValue != null) {
            velocity.setX(xValue.doubleValue());
        }
        if (zValue != null) {
            velocity.setZ(zValue.doubleValue());
        }
        if (this.mage.getLocation().getBlockY() >= 256) {
            velocity.setY(0);
        }
        velocity.multiply(magnitude);
        this.getPlayer().setVelocity(velocity);
        this.controller.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
        this.lastFling = System.currentTimeMillis();
        return SpellResult.CAST;
    }

    @Override
    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        this.controller.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
        if (this.lastFling == 0L) {
            return;
        }
        if (this.lastFling + 20000L > System.currentTimeMillis()) {
            event.setCancelled(true);
            this.lastFling = 0L;
            Location effectLocation = event.getEntity().getLocation();
            Block block = event.getEntity().getLocation().getBlock();
            block = block.getRelative(BlockFace.DOWN);
            int ringEffectRange = (int)Math.ceil(13.0 * event.getDamage() / 200.0 + 2.0);
            int effectRange = Math.min(15, ringEffectRange);
            effectRange = Math.min(this.getMaxRange(), effectRange / 1);
            EffectRing effect = new EffectRing((Plugin)this.controller.getPlugin());
            effect.setRadius(effectRange);
            effect.setEffect(Effect.STEP_SOUND);
            effect.setEffectData(block.getTypeId());
            effect.setPeriod(3);
            effect.start(effectLocation, null);
        }
    }
}

