/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;

public class BlinkSpell
extends Spell {
    private int verticalSearchDistance = 255;
    private static int DEFAULT_PASSTHROUGH_RANGE = 4;

    protected SpellResult ascend() {
        Location targetLocation = this.getLocation();
        int i = 0;
        while (i < 2) {
            if (!this.allowPassThrough(targetLocation.getBlock().getType())) {
                return SpellResult.NO_TARGET;
            }
            targetLocation.setY(targetLocation.getY() + 1.0);
            ++i;
        }
        Location location = this.findPlaceToStand(targetLocation, true);
        if (location != null) {
            this.setTarget(location);
            this.getPlayer().teleport(location);
            return SpellResult.CAST;
        }
        return SpellResult.NO_TARGET;
    }

    protected SpellResult descend() {
        Location targetLocation = this.getLocation();
        int i = 0;
        while (i < 2) {
            if (!this.allowPassThrough(targetLocation.getBlock().getType())) {
                return SpellResult.NO_TARGET;
            }
            targetLocation.setY(targetLocation.getY() - 1.0);
            ++i;
        }
        Location location = this.findPlaceToStand(targetLocation, false);
        if (location != null) {
            this.setTarget(location);
            this.getPlayer().teleport(location);
            return SpellResult.CAST;
        }
        return SpellResult.NO_TARGET;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        block14: {
            block13: {
                elevateType = parameters.getString("type", "");
                player = this.getPlayer();
                if (player == null) {
                    return SpellResult.PLAYER_REQUIRED;
                }
                autoAscend = parameters.getBoolean("allow_ascend", true);
                autoDescend = parameters.getBoolean("allow_descend", true);
                autoPassthrough = parameters.getBoolean("allow_passthrough", true);
                if (elevateType.equals("descend") || this.getYRotation() < -80.0 && autoDescend) {
                    return this.descend();
                }
                if (elevateType.equals("ascend") || this.getYRotation() > 80.0 && autoAscend) {
                    return this.ascend();
                }
                if (autoPassthrough) {
                    firstBlock = this.getNextBlock();
                    if (!this.allowPassThrough(firstBlock.getType())) {
                        return SpellResult.NO_TARGET;
                    }
                    if (firstBlock != null && firstBlock.getType() != Material.AIR && !this.isWater(firstBlock.getType())) {
                        passthroughRange = (int)Math.floor(this.mage.getRangeMultiplier() * (float)parameters.getInteger("passthrough_range", BlinkSpell.DEFAULT_PASSTHROUGH_RANGE));
                        this.setMaxRange(passthroughRange);
                        this.offsetTarget(0, -1, 0);
                        this.setReverseTargeting(true);
                        this.setTargetSpaceRequired();
                        this.targetThrough(Material.AIR);
                    }
                }
                target = this.getTargetBlock();
                face = this.getLastBlock();
                if (target == null) {
                    return SpellResult.NO_TARGET;
                }
                world = this.getWorld();
                destination = face;
                distanceUp = 0;
                distanceDown = 0;
                if (this.isReverseTargeting()) {
                    destination = target;
                }
                if (!player.isFlying()) {
                    groundBlock = destination.getRelative(BlockFace.DOWN);
                    while (distanceDown < this.verticalSearchDistance && !this.isOkToStandOn(groundBlock.getType())) {
                        destination = groundBlock;
                        groundBlock = destination.getRelative(BlockFace.DOWN);
                        ++distanceDown;
                    }
                }
                ledge = null;
                if (this.isReverseTargeting() || face.equals(target.getRelative(BlockFace.DOWN)) && !autoAscend) break block13;
                ledge = target;
                inFront = face;
                oneUp = ledge.getRelative(BlockFace.UP);
                twoUp = oneUp.getRelative(BlockFace.UP);
                faceOneUp = face.getRelative(BlockFace.UP);
                faceTwoUp = faceOneUp.getRelative(BlockFace.UP);
                if (autoPassthrough || autoAscend || this.isTransparent(oneUp.getType()) && this.isTransparent(twoUp.getType()) && this.isTransparent(face.getType()) && this.isTransparent(faceOneUp.getType()) && this.isTransparent(faceTwoUp.getType())) ** GOTO lbl56
                ledge = null;
                break block14;
lbl-1000:
                // 1 sources

                {
                    faceOneUp = faceOneUp.getRelative(BlockFace.UP);
                    faceTwoUp = faceOneUp.getRelative(BlockFace.UP);
                    inFront = inFront.getRelative(BlockFace.UP);
                    ledge = ledge.getRelative(BlockFace.UP);
                    ++distanceUp;
lbl56:
                    // 2 sources

                    ** while ((autoPassthrough || autoAscend || this.isTransparent((Material)face.getType()) && this.isTransparent((Material)faceOneUp.getType()) && this.isTransparent((Material)faceTwoUp.getType())) && distanceUp < this.verticalSearchDistance && this.isOkToStandIn((Material)inFront.getType()) && (!this.isOkToStandOn((Material)ledge.getType()) || !this.isOkToStandIn((Material)oneUp.getType()) || !this.isOkToStandIn((Material)twoUp.getType())))
                }
lbl57:
                // 1 sources

                break block14;
            }
            ledge = null;
        }
        if (ledge != null && distanceUp < distanceDown && this.isOkToStandOn(ledge.getType())) {
            destination = ledge.getRelative(BlockFace.UP);
        }
        oneUp = destination.getRelative(BlockFace.UP);
        twoUp = oneUp.getRelative(BlockFace.UP);
        if (!this.isOkToStandIn(oneUp.getType()) || !this.isOkToStandIn(twoUp.getType())) {
            return SpellResult.NO_TARGET;
        }
        targetLocation = new Location(world, (double)destination.getX() + 0.5, (double)destination.getY(), (double)destination.getZ() + 0.5, this.getPlayer().getLocation().getYaw(), this.getPlayer().getLocation().getPitch());
        this.setTarget(targetLocation);
        player.teleport(targetLocation);
        return SpellResult.CAST;
    }
}

