/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.block.SimulateBatch;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.spell.SimulateSpell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.plugin.Plugin;

public class AnimateSpell
extends SimulateSpell {
    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        if (parameters.getBoolean("animate", false)) {
            return super.onCast(parameters);
        }
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialAndData targetMaterial = new MaterialAndData(targetBlock);
        BlockFace powerFace = SimulateBatch.findPowerLocation(targetBlock, targetMaterial);
        if (powerFace == null) {
            return SpellResult.NO_TARGET;
        }
        final Block powerBlock = targetBlock.getRelative(powerFace);
        final BlockList modifiedBlocks = new BlockList();
        modifiedBlocks.add(targetBlock);
        modifiedBlocks.add(powerBlock);
        if (!this.isDestructible(targetBlock) || !this.isDestructible(powerBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int seedRadius = parameters.getInt("seed_radius", 0);
        if (seedRadius > 0) {
            targetMaterial = parameters.getMaterialAndData("material", targetMaterial);
            int dx = -seedRadius;
            while (dx < seedRadius) {
                int dz = -seedRadius;
                while (dz < seedRadius) {
                    int dy = -seedRadius;
                    while (dy < seedRadius) {
                        Block seedBlock = targetBlock.getRelative(dx, dy, dz);
                        if (this.isDestructible(seedBlock)) {
                            targetMaterial.modify(seedBlock);
                        }
                        ++dy;
                    }
                    ++dz;
                }
                ++dx;
            }
        }
        boolean simCheckDestructible = parameters.getBoolean("sim_check_destructible", true);
        simCheckDestructible = parameters.getBoolean("scd", simCheckDestructible);
        String commandLine = "cast " + this.getKey() + " animate true target self cooldown 0 bu true m " + targetMaterial.getKey() + " cd " + (simCheckDestructible ? "true" : "false");
        String commandName = parameters.getString("name", "Automata");
        commandName = String.valueOf(commandName) + " " + MaterialBrush.getMaterialName(targetMaterial);
        targetBlock.setType(Material.COMMAND);
        BlockState commandData = targetBlock.getState();
        if (commandData == null || !(commandData instanceof CommandBlock)) {
            return SpellResult.FAIL;
        }
        CommandBlock copyCommand = (CommandBlock)commandData;
        copyCommand.setCommand(commandLine);
        copyCommand.setName(commandName);
        copyCommand.update();
        this.controller.updateBlock(targetBlock);
        String message = this.getMessage("cast_broadcast").replace("$name", commandName);
        if (message.length() > 0) {
            this.controller.sendToMages(message, targetBlock.getLocation());
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.controller.getPlugin(), new Runnable(){

            @Override
            public void run() {
                powerBlock.setType(Material.REDSTONE_BLOCK);
                AnimateSpell.this.controller.updateBlock(powerBlock);
                AnimateSpell.this.registerForUndo(modifiedBlocks);
            }
        }, (long)(SimulateBatch.POWER_DELAY_TICKS + 1));
        return SpellResult.CAST;
    }
}

