/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.CleanupBlocksTask;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class UndoQueue {
    private final LinkedList<BlockList> blockQueue = new LinkedList();
    private final Set<BlockList> scheduledBlocks = new HashSet<BlockList>();
    private int maxSize = 0;

    public void add(BlockList blocks) {
        if (this.maxSize > 0 && this.blockQueue.size() > this.maxSize) {
            BlockList expired = this.blockQueue.removeFirst();
            expired.commit();
        }
        blocks.prepareForUndo();
        this.blockQueue.add(blocks);
    }

    public void scheduleCleanup(Mage mage, BlockList blocks) {
        blocks.prepareForUndo();
        this.scheduledBlocks.add(blocks);
        MagicPlugin plugin = mage.getController().getPlugin();
        Server server = plugin.getServer();
        BukkitScheduler scheduler = server.getScheduler();
        long ticksToLive = blocks.getTimeToLive() * 20 / 1000;
        scheduler.scheduleSyncDelayedTask((Plugin)plugin, (Runnable)new CleanupBlocksTask(mage, blocks), ticksToLive);
    }

    public boolean isEmpty() {
        return this.scheduledBlocks.isEmpty() && this.blockQueue.isEmpty();
    }

    public void removeScheduledCleanup(BlockList blockList) {
        this.scheduledBlocks.remove(blockList);
    }

    public BlockList getLast() {
        if (this.blockQueue.isEmpty()) {
            return null;
        }
        return this.blockQueue.getLast();
    }

    public BlockList getLast(Block target) {
        if (this.blockQueue.size() == 0) {
            return null;
        }
        for (BlockList blocks : this.blockQueue) {
            if (!blocks.contains(target)) continue;
            return blocks;
        }
        return null;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public boolean undo(Mage mage) {
        if (this.blockQueue.size() == 0) {
            return false;
        }
        BlockList blocks = this.blockQueue.removeLast();
        if (blocks.undo(mage)) {
            return true;
        }
        this.blockQueue.add(blocks);
        return false;
    }

    public boolean undo(Mage mage, Block target) {
        BlockList lastActionOnTarget = this.getLast(target);
        if (lastActionOnTarget == null) {
            return false;
        }
        if (lastActionOnTarget.undo(mage)) {
            this.blockQueue.remove(lastActionOnTarget);
            return true;
        }
        return false;
    }

    public void load(Mage mage, ConfigurationNode node) {
        try {
            BlockList list;
            if (node == null) {
                return;
            }
            List<ConfigurationNode> nodeList = node.getNodeList("undo", null);
            for (ConfigurationNode listNode : nodeList) {
                list = new BlockList();
                list.load(listNode);
                this.blockQueue.add(list);
            }
            nodeList = node.getNodeList("scheduled", null);
            for (ConfigurationNode listNode : nodeList) {
                list = new BlockList();
                list.load(listNode);
                this.scheduleCleanup(mage, list);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            mage.getController().getPlugin().getLogger().warning("Failed to load undo data: " + ex.getMessage());
        }
    }

    public void save(Mage mage, ConfigurationNode node) {
        MagicController controller = mage.getController();
        int maxSize = controller.getMaxUndoPersistSize();
        try {
            HashMap<String, Object> listNode;
            ArrayList<HashMap<String, Object>> nodeList = new ArrayList<HashMap<String, Object>>();
            for (BlockList list : this.blockQueue) {
                if (maxSize > 0 && list.size() > maxSize) {
                    controller.getLogger().info("Discarding undo batch, size " + list.size() + " for player " + mage.getName());
                    continue;
                }
                listNode = new HashMap<String, Object>();
                list.save(listNode);
                nodeList.add(listNode);
            }
            node.setProperty("undo", nodeList);
            nodeList = new ArrayList();
            for (BlockList list : this.scheduledBlocks) {
                listNode = new HashMap();
                list.save(listNode);
                nodeList.add(listNode);
            }
            node.setProperty("scheduled", nodeList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            controller.getLogger().warning("Failed to save undo data: " + ex.getMessage());
        }
    }

    public int getSize() {
        return this.blockQueue.size();
    }

    public boolean commit() {
        if (this.blockQueue.size() == 0) {
            return false;
        }
        for (BlockList list : this.blockQueue) {
            list.commit();
        }
        this.blockQueue.clear();
        return true;
    }
}

