/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.VolumeBatch;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class UndoBatch
extends VolumeBatch {
    private final BlockList blockList;
    private int blockIndex = 0;
    private boolean finishedAttachables = false;
    private final Set<Material> attachables;
    private final Set<Material> attachablesWall;
    private final Set<Material> attachablesDouble;
    private final Set<Material> delayed;

    public UndoBatch(MagicController controller, BlockList blockList) {
        super(controller, blockList.getWorldName());
        this.blockList = blockList;
        this.attachables = controller.getMaterialSet("attachable");
        this.attachablesWall = controller.getMaterialSet("attachable_wall");
        this.attachablesDouble = controller.getMaterialSet("attachable_double");
        this.delayed = controller.getMaterialSet("delayed");
    }

    @Override
    public int size() {
        return this.blockList.size();
    }

    @Override
    public int remaining() {
        return this.blockList.size() - this.blockIndex;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks = 0;
        ArrayList<BlockData> undoList = this.blockList.getBlockList();
        while (undoList != null && this.blockIndex < undoList.size() && processedBlocks < maxBlocks) {
            boolean isAttachable;
            BlockData blockData = undoList.get(this.blockIndex);
            Block block = blockData.getBlock();
            if (!block.getChunk().isLoaded()) {
                block.getChunk().load();
                break;
            }
            Material material = block.getType();
            boolean bl = isAttachable = this.attachables.contains(material) || this.attachablesWall.contains(material) || this.attachablesDouble.contains(material) || this.delayed.contains(material);
            if (isAttachable && !this.finishedAttachables || !isAttachable && this.finishedAttachables) {
                if (!this.blockList.undo(blockData)) break;
                this.updateBlock(blockData);
            }
            ++this.blockIndex;
            ++processedBlocks;
        }
        if (undoList == null || this.blockIndex >= undoList.size() && this.finishedAttachables) {
            this.finish();
        } else if (this.blockIndex >= undoList.size()) {
            this.finishedAttachables = true;
            this.blockIndex = 0;
        }
        return processedBlocks;
    }
}

