/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BlockVector;

public class BlockData
extends MaterialAndData {
    public static final BlockFace[] FACES = new BlockFace[]{BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.UP, BlockFace.DOWN};
    public static final BlockFace[] SIDES = new BlockFace[]{BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST};
    protected static Server server;
    protected Block block;
    protected BlockData nextState;
    protected BlockData priorState;
    protected BlockVector location;
    protected String world;

    public static void setServer(Server server) {
        BlockData.server = server;
    }

    public static long getBlockId(Block block) {
        return BlockData.getBlockId(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    public static long getBlockId(String world, int x, int y, int z) {
        return (long)((world.hashCode() & 0xF) << 56) | ((long)x & 0xFFFFFFL) << 32 | ((long)z & 0xFFFFFFL) << 8 | (long)y & 0xFFL;
    }

    public long getId() {
        return BlockData.getBlockId(this.world, this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ());
    }

    public static BlockFace getReverseFace(BlockFace blockFace) {
        switch (blockFace) {
            case NORTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.EAST;
            }
            case SOUTH: {
                return BlockFace.NORTH;
            }
            case EAST: {
                return BlockFace.WEST;
            }
            case UP: {
                return BlockFace.DOWN;
            }
            case DOWN: {
                return BlockFace.UP;
            }
        }
        return BlockFace.SELF;
    }

    public BlockData() {
    }

    public BlockData(Block block) {
        super(block);
        this.block = block;
        this.location = new BlockVector(block.getX(), block.getY(), block.getZ());
        this.world = block.getWorld().getName();
    }

    public BlockData(BlockData copy) {
        super(copy);
        this.location = copy.location;
        this.world = copy.world;
        this.block = copy.block;
    }

    public BlockData(Location location, Material material, byte data) {
        super(material, data);
        this.location = new BlockVector(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.world = location.getWorld().getName();
    }

    public BlockData(int x, int y, int z, String world, Material material, byte data) {
        super(material, data);
        this.location = new BlockVector(x, y, z);
        this.world = world;
    }

    public BlockData(ConfigurationNode node) {
        this(node.getLocation("location"), node.getMaterial("material"), (byte)node.getInt("data", 0));
    }

    public void save(ConfigurationNode node) {
        node.setProperty("material", this.material);
        node.setProperty("data", this.data);
        Location location = new Location(Bukkit.getWorld((String)this.world), this.location.getX(), this.location.getY(), this.location.getZ());
        node.setProperty("location", location);
    }

    protected boolean checkBlock() {
        if (this.block == null) {
            this.block = this.getBlock();
        }
        return this.block != null;
    }

    public World getWorld() {
        return server.getWorld(this.world);
    }

    public Block getBlock() {
        if (this.block == null && this.location != null && server != null && this.world != null) {
            World world = this.getWorld();
            this.block = world.getBlockAt(this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ());
        }
        return this.block;
    }

    public BlockVector getPosition() {
        return this.location;
    }

    public void setPosition(BlockVector location) {
        this.location = location;
    }

    protected boolean undo() {
        if (!this.checkBlock()) {
            return true;
        }
        Chunk chunk = this.block.getChunk();
        if (!chunk.isLoaded()) {
            chunk.load();
            return false;
        }
        if (this.isDifferent(this.block)) {
            this.modify(this.block);
        }
        if (this.priorState != null) {
            this.priorState.setNextState(this.nextState);
        }
        if (this.nextState != null) {
            this.nextState.setPriorState(this.priorState);
            this.nextState.updateFrom(this);
        }
        return true;
    }

    protected void commit() {
        if (this.nextState != null) {
            this.nextState.setPriorState(null);
            this.nextState.updateFrom(this.block);
        }
        if (this.priorState != null) {
            this.priorState.setNextState(null);
            this.priorState.commit();
        }
    }

    public String toString() {
        return String.valueOf(this.location.getBlockX()) + "," + this.location.getBlockY() + "," + this.location.getBlockZ() + "," + this.world + "|" + this.getMaterial().getId() + ":" + this.getData();
    }

    public static BlockData fromString(String s) {
        BlockData result = null;
        if (s == null) {
            return null;
        }
        try {
            String[] pieces = StringUtils.split((String)s, (char)'|');
            String[] locationPieces = StringUtils.split((String)pieces[0], (char)',');
            int x = Integer.parseInt(locationPieces[0]);
            int y = Integer.parseInt(locationPieces[1]);
            int z = Integer.parseInt(locationPieces[2]);
            String world = locationPieces[3];
            String[] materialPieces = StringUtils.split((String)pieces[1], (char)':');
            int materialId = Integer.parseInt(materialPieces[0]);
            byte dataId = Byte.parseByte(materialPieces[1]);
            return new BlockData(x, y, z, world, Material.getMaterial((int)materialId), dataId);
        }
        catch (Exception exception) {
            return result;
        }
    }

    public String getWorldName() {
        return this.world;
    }

    public BlockVector getLocation() {
        return this.location;
    }

    public BlockData getNextState() {
        return this.nextState;
    }

    public void setNextState(BlockData next) {
        this.nextState = next;
    }

    public BlockData getPriorState() {
        return this.priorState;
    }

    public void setPriorState(BlockData prior) {
        this.priorState = prior;
    }

    public void restore() {
        this.modify(this.getBlock());
    }
}

