/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.Vector;

public class ThrustSpell
extends Spell {
    public static int tickSpan = 2;
    protected int targetHeight = 0;
    protected int checkCounter = 0;
    protected int groundHeight = 0;
    protected float hoverHeight = 0.0f;
    protected long lastTick = 0L;
    private final long safetyLength = 20000L;
    private long lastLevitate = 0L;
    protected int checkFrequency = 10;
    protected int maxTerrainChangeHeight = 4;
    protected int defaultHoverHeight = 5;
    protected int elevateRate = 32;
    protected int maxSpeedAtElevation = 32;
    protected int maxSpeed = 20;
    protected int minSpeed = 6;
    protected float gravity = 0.98f;
    protected static LevitateAction action = null;

    protected void checkForGround() {
        this.checkCounter = 0;
        Location playerLocation = this.getLocation();
        World world = playerLocation.getWorld();
        Block targetBlock = world.getBlockAt(playerLocation);
        targetBlock = targetBlock.getRelative(BlockFace.DOWN);
        int newGroundHeight = targetBlock.getY();
        while (targetBlock.getType() == Material.AIR && newGroundHeight > 1) {
            --newGroundHeight;
            targetBlock = targetBlock.getRelative(BlockFace.DOWN);
        }
        if (this.groundHeight == 0 || this.targetHeight == 0) {
            this.hoverHeight = this.getPlayer().getLocation().getBlockY() - newGroundHeight;
            if (this.hoverHeight < (float)this.defaultHoverHeight) {
                this.hoverHeight = this.defaultHoverHeight;
            }
        } else if (Math.abs(newGroundHeight - this.groundHeight) > this.maxTerrainChangeHeight) {
            this.hoverHeight = this.targetHeight - newGroundHeight;
        }
        this.groundHeight = newGroundHeight;
        this.updateTargetHeight();
    }

    protected void updateTargetHeight() {
        this.targetHeight = (int)(this.hoverHeight + (float)this.groundHeight);
        if (this.targetHeight > 255) {
            this.targetHeight = 255;
        }
    }

    public boolean isActive() {
        return this.getPlayer() != null && !this.getPlayer().isDead() && this.getPlayer().isOnline();
    }

    protected void applyForce() {
        if (!this.isActive()) {
            action.deactivate(this);
            return;
        }
        float timeDeltaSeconds = (float)(System.currentTimeMillis() - this.lastTick) / 1000.0f;
        Vector force = new Vector(0.0f, this.gravity * timeDeltaSeconds, 0.0f);
        float elevateMagnitude = (float)this.elevateRate * timeDeltaSeconds;
        float speedMinMagnitude = (float)this.minSpeed * timeDeltaSeconds;
        float speedMaxMagnitude = (float)this.maxSpeed * timeDeltaSeconds;
        Location playerLocation = this.getPlayer().getLocation();
        float pitch = playerLocation.getPitch();
        float yaw = playerLocation.getYaw();
        Vector scaledForce = force.clone();
        int playerHeight = playerLocation.getBlockY();
        int heightDelta = this.targetHeight - playerHeight;
        if (heightDelta > 0) {
            int heightBoost = heightDelta > 16 ? 16 : heightDelta;
            scaledForce.multiply(heightBoost);
        } else if (heightDelta < 0) {
            scaledForce.setY(0);
        }
        Vector aim = new Vector(0.0 - Math.sin(Math.toRadians(yaw)), 0.0 - Math.sin(Math.toRadians(pitch += 15.0f)), Math.cos(Math.toRadians(yaw)));
        aim.normalize();
        if (heightDelta < 5 && pitch < -45.0f) {
            this.hoverHeight = (float)((double)this.hoverHeight + (double)elevateMagnitude * aim.getY());
            if (this.hoverHeight > 255.0f) {
                this.hoverHeight = 255.0f;
            }
            if (this.hoverHeight < (float)this.defaultHoverHeight) {
                this.hoverHeight = this.defaultHoverHeight;
            }
            this.updateTargetHeight();
        }
        if (this.checkCounter++ > this.checkFrequency) {
            this.checkForGround();
        }
        float multiplier = speedMinMagnitude;
        if (!this.getPlayer().isSneaking()) {
            int heightFactor = this.hoverHeight > (float)this.maxSpeedAtElevation ? this.maxSpeedAtElevation : (int)this.hoverHeight;
            multiplier *= speedMaxMagnitude * (float)heightFactor / (float)this.maxSpeedAtElevation;
        }
        float verticalMultipler = 1.0f - (float)Math.abs(aim.getY());
        aim.multiply(multiplier * verticalMultipler);
        aim.setY(0);
        scaledForce.add(aim);
        this.getPlayer().setVelocity(scaledForce);
        this.lastTick = System.currentTimeMillis();
    }

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        this.lastTick = System.currentTimeMillis();
        this.hoverHeight = this.defaultHoverHeight;
        if (action == null) {
            action = new LevitateAction((Plugin)this.controller.getPlugin());
        }
        if (action.isActive(this.getPlayer())) {
            action.deactivate(this);
        } else {
            action.activate(this);
        }
        this.lastLevitate = System.currentTimeMillis();
        return SpellResult.CAST;
    }

    @Override
    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (this.lastLevitate == 0L) {
            return;
        }
        if (this.lastLevitate + 20000L > System.currentTimeMillis()) {
            event.setCancelled(true);
            this.lastLevitate = 0L;
        }
    }

    public class LevitateAction
    implements Runnable {
        protected HashMap<String, ThrustSpell> players = new HashMap();
        protected BukkitScheduler scheduler;
        protected Plugin plugin;
        protected Server server;

        public LevitateAction(Plugin plugin) {
            this.plugin = plugin;
            this.server = plugin.getServer();
            this.scheduler = this.server.getScheduler();
        }

        public boolean isActive(Player player) {
            return this.players.containsKey(player.getName());
        }

        public void activate(ThrustSpell spell) {
            spell.controller.registerEvent(SpellEventType.PLAYER_DAMAGE, spell);
            this.players.put(spell.getPlayer().getName(), spell);
            spell.checkForGround();
            this.scheduleForce();
        }

        protected void scheduleForce() {
            this.scheduler.scheduleSyncDelayedTask(this.plugin, (Runnable)this, (long)tickSpan);
        }

        public void deactivate(ThrustSpell spell) {
            spell.controller.unregisterEvent(SpellEventType.PLAYER_DAMAGE, spell);
            this.players.remove(spell.getPlayer().getName());
            ThrustSpell.this.getPlayer().setVelocity(new Vector(0, 0, 0));
        }

        @Override
        public void run() {
            ArrayList<String> levitatingPlayers = new ArrayList<String>();
            levitatingPlayers.addAll(this.players.keySet());
            for (String playerName : levitatingPlayers) {
                ThrustSpell spell = this.players.get(playerName);
                if (spell.isActive()) {
                    spell.applyForce();
                    continue;
                }
                this.players.remove(playerName);
            }
            if (this.players.size() > 0) {
                this.scheduleForce();
            }
        }
    }
}

