/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.block.RegenerateBatch;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.TargetType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;

public class RegenerateSpell
extends BlockSpell {
    private static final int DEFAULT_MAX_DIMENSION = 128;
    private Block targetBlock = null;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        boolean singleBlock;
        Block targetBlock = this.getTargetBlock();
        boolean bl = singleBlock = this.getTargetType() != TargetType.SELECT;
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (singleBlock) {
            this.deactivate();
            World world = targetBlock.getWorld();
            Chunk chunk = targetBlock.getChunk();
            world.regenerateChunk(chunk.getX(), chunk.getZ());
            return SpellResult.CAST;
        }
        if (this.targetLocation2 != null) {
            this.targetBlock = this.targetLocation2.getBlock();
        }
        if (this.targetBlock != null) {
            RegenerateBatch batch = new RegenerateBatch(this, this.targetBlock.getLocation(), targetBlock.getLocation());
            int maxDimension = parameters.getInteger("max_dimension", 128);
            maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)maxDimension);
            if (!batch.checkDimension(maxDimension)) {
                return SpellResult.FAIL;
            }
            boolean success = this.mage.addPendingBlockBatch(batch);
            this.deactivate();
            return success ? SpellResult.CAST : SpellResult.FAIL;
        }
        this.targetBlock = targetBlock;
        this.activate();
        return SpellResult.TARGET_SELECTED;
    }

    @Override
    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.deactivate();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivate() {
        this.targetBlock = null;
    }
}

