/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;

public class OcelotSpell
extends Spell {
    private static int DEFAULT_MAX_OCELOTS = 30;
    protected List<Ocelot> ocelots = new ArrayList<Ocelot>();

    public Ocelot newOcelot(Target target) {
        Ocelot entity;
        Block targetBlock = target.getBlock();
        if (targetBlock == null) {
            return null;
        }
        targetBlock = targetBlock.getRelative(BlockFace.UP);
        if (target.hasEntity()) {
            targetBlock = targetBlock.getRelative(BlockFace.SOUTH);
        }
        if ((entity = (Ocelot)this.getWorld().spawnEntity(targetBlock.getLocation(), EntityType.OCELOT)) == null) {
            return null;
        }
        this.tameOcelot(entity);
        return entity;
    }

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        Ocelot Ocelot2;
        Target target = this.getTarget();
        ArrayList<Ocelot> newocelots = new ArrayList<Ocelot>();
        for (Ocelot Ocelot3 : this.ocelots) {
            if (Ocelot3.isDead()) continue;
            newocelots.add(Ocelot3);
        }
        this.ocelots = newocelots;
        int maxOcelots = parameters.getInt("max_ocelots", DEFAULT_MAX_OCELOTS);
        int scaledMaxOcelots = (int)(this.mage.getRadiusMultiplier() * (float)maxOcelots);
        if (this.ocelots.size() >= scaledMaxOcelots) {
            Ocelot killOcelot = this.ocelots.remove(0);
            killOcelot.setHealth(0.0);
        }
        if ((Ocelot2 = this.newOcelot(target)) == null) {
            return SpellResult.FAIL;
        }
        this.ocelots.add(Ocelot2);
        Entity e = target.getEntity();
        if (e != null && e instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)e;
            for (Ocelot w : this.ocelots) {
                w.setTarget(targetEntity);
            }
        }
        return SpellResult.CAST;
    }

    protected void tameOcelot(Ocelot Ocelot2) {
        Ocelot2.setHealth(8.0);
        Ocelot2.setTamed(true);
        Ocelot2.setOwner((AnimalTamer)this.getPlayer());
    }
}

